/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.wizards.mvc;

import com.nxp.s32ds.ext.ide.ui.dialogs.ProjectSelectionDialog;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtWizards;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.MvcBase;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.MvcModelChangeListener;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.ProjectNameMvc;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TargetProjectMvc
extends MvcBase
implements MvcModelChangeListener {
    private String targetProject = "";
    private boolean useDefault = true;
    protected Text targetProjectText;
    private Button useDefaultButton;
    private Consumer<Boolean> enableConsumer;
    private final ProjectNameMvc projectNameMvc;

    public TargetProjectMvc(ProjectNameMvc projectNameMvc) {
        this.projectNameMvc = projectNameMvc;
        projectNameMvc.addChangeListener(this);
    }

    public void setTargetProject(String targetProject) {
        this.targetProject = targetProject == null ? "" : targetProject.trim();
        this.updateTargetProjectText();
        this.fireModelChanged();
    }

    public String getTargetProject() {
        if (this.useDefault || this.targetProject.isEmpty()) {
            return null;
        }
        return this.targetProject;
    }

    public void setUseDefault(boolean useDefaultTargetProject) {
        this.useDefault = useDefaultTargetProject;
        if (this.useDefaultButton != null) {
            this.useDefaultButton.setSelection(useDefaultTargetProject);
            this.enableConsumer.accept(!useDefaultTargetProject);
        }
        this.updateTargetProjectText();
        this.fireModelChanged();
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public void create(final Composite parent, FontMetrics fontMetrics) {
        int columns = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.useDefaultButton = new Button(composite, 131104);
        this.useDefaultButton.setText(UiMessages.TargetProjectMvc_use_default_target_project);
        this.useDefaultButton.setSelection(true);
        GridData gridData = new GridData();
        gridData.horizontalSpan = columns;
        this.useDefaultButton.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(UiMessages.TargetProjectMvc_target_project);
        this.targetProjectText = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.targetProjectText.setLayoutData((Object)gridData);
        this.targetProjectText.setEditable(false);
        Button browseButton = new Button(composite, 8);
        browseButton.setText(UiMessages.TargetProjectMvc_browse_target_project);
        VgtWizards.setButtonLayoutData(browseButton, fontMetrics);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog dialog = new ProjectSelectionDialog(parent.getShell(), UiMessages.TargetProjectMvc_select_target_project_to_emit_source_code);
                if (dialog.open() == 0) {
                    IProject selectedProject = dialog.getSelectedProject();
                    TargetProjectMvc.this.targetProject = selectedProject.getName();
                    TargetProjectMvc.this.updateTargetProjectText();
                    TargetProjectMvc.this.fireModelChanged();
                }
            }
        });
        this.enableConsumer = enabled -> {
            label.setEnabled(enabled.booleanValue());
            this.targetProjectText.setEnabled(enabled.booleanValue());
            browseButton.setEnabled(enabled.booleanValue());
        };
        this.enableConsumer.accept(!this.useDefault);
        this.useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = TargetProjectMvc.this.useDefaultButton.getSelection();
                TargetProjectMvc.this.enableConsumer.accept(!useDefaults);
                TargetProjectMvc.this.useDefault = useDefaults;
                TargetProjectMvc.this.updateTargetProjectText();
                TargetProjectMvc.this.fireModelChanged();
            }
        });
    }

    private void updateTargetProjectText() {
        if (this.targetProjectText != null) {
            this.targetProjectText.setText(this.getTargetProjectText());
        }
    }

    private String getTargetProjectText() {
        String projectName = this.projectNameMvc.getProjectName();
        if (this.useDefault) {
            return projectName;
        }
        return this.targetProject;
    }

    @Override
    public void modelChanged(MvcBase mvcBase) {
        if (mvcBase == this.projectNameMvc) {
            this.updateTargetProjectText();
        }
    }
}

