/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.wizards.mvc;

import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtWizards;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.MvcBase;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.MvcModelChangeListener;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.ProjectNameMvc;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LocationMvc
extends MvcBase
implements MvcModelChangeListener {
    private String projectLocation = "";
    private boolean useDefault = true;
    private Text projectLocationText;
    private Button useDefaultButton;
    private Consumer<Boolean> enableConsumer;
    private final ProjectNameMvc projectNameMvc;

    public LocationMvc(ProjectNameMvc projectNameMvc) {
        this.projectNameMvc = projectNameMvc;
        projectNameMvc.addChangeListener(this);
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation == null ? "" : projectLocation.trim();
        this.updateProjectLocationText();
        this.fireModelChanged();
    }

    public String getProjectLocation() {
        if (!this.useDefault && this.projectLocation.isEmpty()) {
            return null;
        }
        return this.getProjectLocationText();
    }

    public void setUseDefault(boolean useDefaultProjectLocation) {
        this.useDefault = useDefaultProjectLocation;
        if (this.useDefaultButton != null) {
            this.useDefaultButton.setSelection(useDefaultProjectLocation);
            this.enableConsumer.accept(!useDefaultProjectLocation);
        }
        this.updateProjectLocationText();
        this.fireModelChanged();
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public void create(final Composite parent, FontMetrics fontMetrics) {
        int columns;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.useDefaultButton = new Button(composite, 131104);
        this.useDefaultButton.setText(UiMessages.LocationMvc_use_default_location);
        this.useDefaultButton.setSelection(this.useDefault);
        GridData gridData = new GridData();
        gridData.horizontalSpan = columns;
        this.useDefaultButton.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(UiMessages.LocationMvc_location);
        this.projectLocationText = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectLocationText.setLayoutData((Object)gridData);
        this.projectLocationText.setEditable(false);
        this.projectLocationText.setText(this.getProjectLocationText());
        Button browseButton = new Button(composite, 8);
        VgtWizards.setButtonLayoutData(browseButton, fontMetrics);
        browseButton.setText(UiMessages.LocationMvc_browse_location);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selectedDirectory;
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 0x10000000);
                dialog.setMessage(UiMessages.LocationMvc_select_location_directory);
                if (Files.isDirectory(Paths.get(LocationMvc.this.projectLocation, new String[0]), new LinkOption[0])) {
                    dialog.setFilterPath(LocationMvc.this.projectLocation);
                }
                if ((selectedDirectory = dialog.open()) != null) {
                    LocationMvc.this.projectLocation = selectedDirectory;
                    LocationMvc.this.updateProjectLocationText();
                    LocationMvc.this.fireModelChanged();
                }
            }
        });
        this.enableConsumer = enabled -> {
            label.setEnabled(enabled.booleanValue());
            this.projectLocationText.setEnabled(enabled.booleanValue());
            browseButton.setEnabled(enabled.booleanValue());
        };
        this.enableConsumer.accept(!this.useDefault);
        this.useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = LocationMvc.this.useDefaultButton.getSelection();
                LocationMvc.this.enableConsumer.accept(!useDefaults);
                LocationMvc.this.useDefault = useDefaults;
                LocationMvc.this.updateProjectLocationText();
                LocationMvc.this.fireModelChanged();
            }
        });
    }

    private void updateProjectLocationText() {
        if (this.projectLocationText != null) {
            this.projectLocationText.setText(this.getProjectLocationText());
        }
    }

    private String getProjectLocationText() {
        String projectName = this.projectNameMvc.getProjectName();
        if (this.useDefault) {
            return String.valueOf(Platform.getLocation().toOSString()) + File.separator + projectName;
        }
        if (this.projectLocation.isEmpty()) {
            return "";
        }
        return String.valueOf(this.projectLocation) + File.separator + projectName;
    }

    @Override
    public void modelChanged(MvcBase mvcBase) {
        if (mvcBase == this.projectNameMvc) {
            this.updateProjectLocationText();
            this.fireModelChanged();
        }
    }
}

