/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.wizards;

import com.nxp.s32ds.ext.ide.resources.ResourceNameValidator;
import com.nxp.s32ds.ext.ide.resources.path.ProjectDirectoryFileSystemValidator;
import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.internal.ui.VgtIdeUiActivator;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtProjectWizardPageChangeListener;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.LocationMvc;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.MvcBase;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.MvcModelChangeListener;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.ProjectNameMvc;
import com.nxp.s32ds.vgt.ide.ui.wizards.mvc.TargetProjectMvc;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;

public class VgtProjectWizardPage
extends WizardPage
implements MvcModelChangeListener {
    public static final int PROJECT_NAME = 1;
    public static final int PROJECT_LOCATION = 2;
    public static final int TARGET_PROJECT = 3;
    private static final ProjectDirectoryFileSystemValidator projectPathValidator = new ProjectDirectoryFileSystemValidator();
    private static final CIdentifierValidator cIdentifierValidator = new CIdentifierValidator();
    private static final ResourceNameValidator projectNameValidator = new ResourceNameValidator();
    private final List<VgtProjectWizardPageChangeListener> listeners = new ArrayList<VgtProjectWizardPageChangeListener>();
    protected ProjectNameMvc projectNameMvc;
    protected LocationMvc locationMvc;
    protected TargetProjectMvc targetProjectMvc;
    private WorkingSetGroup workingSetGroup;
    private boolean createTargetProjectGroup;
    protected FontMetrics fontMetrics;
    private String helpContextId = null;

    public VgtProjectWizardPage(String pageName) {
        this(pageName, false);
    }

    public VgtProjectWizardPage(String pageName, boolean createTargetProjectGroup) {
        super(pageName);
        this.createTargetProjectGroup = createTargetProjectGroup;
        this.projectNameMvc = new ProjectNameMvc();
        this.projectNameMvc.addChangeListener(this);
        this.locationMvc = new LocationMvc(this.projectNameMvc);
        this.locationMvc.addChangeListener(this);
        this.targetProjectMvc = new TargetProjectMvc(this.projectNameMvc);
        this.targetProjectMvc.addChangeListener(this);
    }

    public void addPageChangeListener(VgtProjectWizardPageChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePageChangeListener(VgtProjectWizardPageChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePageChanged(int id) {
        VgtProjectWizardPageChangeListener[] array;
        VgtProjectWizardPageChangeListener[] vgtProjectWizardPageChangeListenerArray = array = this.listeners.toArray(new VgtProjectWizardPageChangeListener[this.listeners.size()]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            VgtProjectWizardPageChangeListener listener = vgtProjectWizardPageChangeListenerArray[n2];
            try {
                listener.pageChanged(id);
            }
            catch (Throwable e) {
                VgtIdeUiActivator.log(UiMessages.VgtProjectWizardPage_error_during_event_dispatching, e);
            }
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        this.fontMetrics = VgtProjectWizardPage.getFontMetrics((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createContent(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.helpContextId);
        }
    }

    private static FontMetrics getFontMetrics(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    protected void createContent(Composite parent) {
        this.projectNameMvc.create(parent, this.fontMetrics);
        this.locationMvc.create(parent, this.fontMetrics);
        this.workingSetGroup = new WorkingSetGroup(parent, (IStructuredSelection)new StructuredSelection(), new String[]{"org.eclipse.ui.resourceWorkingSetPage"});
        if (this.createTargetProjectGroup) {
            this.targetProjectMvc.create(parent, this.fontMetrics);
        }
    }

    public IPath getLocationPath() {
        String projectLocation = this.locationMvc.getProjectLocation();
        if (projectLocation == null) {
            return null;
        }
        return new Path(projectLocation);
    }

    public URI getLocationURI() {
        String projectLocation = this.locationMvc.getProjectLocation();
        if (projectLocation == null) {
            return null;
        }
        return URIUtil.toURI((String)projectLocation);
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.projectNameMvc.getProjectName();
    }

    public String getTargetProject() {
        return this.targetProjectMvc.getTargetProject();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.projectNameMvc.setProjectName(null);
        } else {
            this.projectNameMvc.setProjectName(name.trim());
        }
    }

    protected boolean validatePage() {
        IStatus validateProjectPath;
        IStatus locationStatus;
        String projectName = this.projectNameMvc.getProjectName();
        if (projectName.isEmpty()) {
            this.setErrorMessage(null);
            this.setMessage(UiMessages.VgtProjectWizardPage_project_name_must_be_specified);
            return false;
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IStatus validate = projectNameValidator.validate((Object)projectName);
        if (!validate.isOK()) {
            this.setErrorMessage(validate.getMessage());
            return false;
        }
        IStatus validateAsCidentifier = cIdentifierValidator.validate((Object)projectName);
        if (!validateAsCidentifier.isOK()) {
            this.setErrorMessage(validateAsCidentifier.getMessage());
            return false;
        }
        if (!this.locationMvc.isUseDefault() && this.locationMvc.getProjectLocation() == null) {
            this.setErrorMessage(null);
            this.setMessage(UiMessages.VgtProjectWizardPage_project_location_directory_must_be_specified);
            return false;
        }
        IProject[] projectsList = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projectsList.length) {
            if (projectsList[i].getName().toLowerCase().equals(this.getProjectName().toLowerCase())) {
                this.setErrorMessage(UiMessages.VgtProjectWizardPage_e_project_already_exist);
                return false;
            }
            ++i;
        }
        URI locationURI = this.getLocationURI();
        if (locationURI != null && !(locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocationURI(this.getProjectHandle(), locationURI)).isOK()) {
            this.setErrorMessage(locationStatus.getMessage());
            return false;
        }
        IPath locationPath = this.getLocationPath();
        if (locationPath != null && !(validateProjectPath = projectPathValidator.validate((Object)locationPath.toOSString())).isOK()) {
            this.setErrorMessage(validateProjectPath.getMessage());
            return false;
        }
        if (!this.targetProjectMvc.isUseDefault() && this.targetProjectMvc.getTargetProject() == null) {
            this.setErrorMessage(null);
            this.setMessage(UiMessages.VgtProjectWizardPage_target_project_must_be_specified);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameMvc.setFocus();
        }
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    @Override
    public void modelChanged(MvcBase mvcBase) {
        if (mvcBase == this.projectNameMvc) {
            this.firePageChanged(1);
        } else if (mvcBase == this.locationMvc) {
            this.firePageChanged(2);
        } else if (mvcBase == this.targetProjectMvc) {
            this.firePageChanged(3);
        }
        this.setPageComplete(this.validatePage());
    }

    public void setHelpContextId(String helpContextId) {
        this.helpContextId = helpContextId;
    }
}

