/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.viewers;

import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.ui.VgtIdeUi;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class VgtResourcesFilter
extends ViewerFilter {
    private final Set<String> extensions = new HashSet<String>();

    public VgtResourcesFilter() {
        this.extensions.add("aird");
        List<VgtRepresenter> representers = VgtIdeUi.getRepresenters();
        for (VgtRepresenter representer : representers) {
            String generator;
            String semantic = representer.getSemanticFileExtension();
            if (semantic != null) {
                this.extensions.add(semantic);
            }
            if ((generator = representer.getGeneratorFileExtension()) == null) continue;
            this.extensions.add(generator);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return !this.extensions.contains(file.getFileExtension());
        }
        if (element instanceof DSemanticDiagram) {
            DSemanticDiagram semantiDiagram = (DSemanticDiagram)element;
            EObject eContainer = semantiDiagram.getTarget();
            if (eContainer == null) {
                return false;
            }
            if (DRepresentation.class.isAssignableFrom(eContainer.getClass())) {
                return false;
            }
        }
        return true;
    }
}

