/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameParticipant;
import com.nxp.s32ds.ext.ide.ui.refactoring.IChangeValidator;
import com.nxp.s32ds.ext.ide.validation.ui.TextChangeFinder;
import com.nxp.s32ds.ext.rcp.jface.ListDialogWithToggle;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class VgtResourcesRefactoring
implements IRenameParticipant,
IChangeValidator {
    private static final String BUNDLE_ID = "com.nxp.s32ds.vgt.ide.ui.refactoring";
    private static final String[] VGT_FILES = new String[]{"*.aird", "*.apugen", "*.apuprogram", "*.apugraph", "*.apukernel", "*.isp", "*.ispgen", "*.sptgen", "*.spt1", "*.spt2", "*.spt25", "*.spt", "*.pax"};
    private static final List<IChangeValidator.AttributeLine> ATTRIBUTES_AFFECTED = new ArrayList<IChangeValidator.AttributeLine>();
    private static final String REGEX_FOR_VALUE_NAME = VgtResourcesRefactoring.createRegexForValueName("name");
    private Set<IProject> closedProjects = new HashSet<IProject>();

    static {
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<semanticResources>", Arrays.asList(">.*%s.*<"), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<ownedRepresentationDescriptors", Arrays.asList(REGEX_FOR_VALUE_NAME), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<target", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<diagram:DSemanticDiagram", Arrays.asList(REGEX_FOR_VALUE_NAME), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<com.nxp.s32ds.isp:IspGraph", Arrays.asList(REGEX_FOR_VALUE_NAME), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<pax:PaxGraph", Arrays.asList(REGEX_FOR_VALUE_NAME), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<com.nxp.s32ds.apu:ApuProgram", Arrays.asList(REGEX_FOR_VALUE_NAME), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<ownedDiagramElements", Arrays.asList(REGEX_FOR_VALUE_NAME, VgtResourcesRefactoring.createRegexForValueName("tooltipText")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<semanticElements", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<com.nxp.s32ds.apu:ApuKernelSource", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("category"), VgtResourcesRefactoring.createRegexForValueName("include")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<kernelInfos", Arrays.asList(REGEX_FOR_VALUE_NAME), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<kernels", Arrays.asList(REGEX_FOR_VALUE_NAME, VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<kernelInfo", Arrays.asList(REGEX_FOR_VALUE_NAME, VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<portInfo", Arrays.asList(REGEX_FOR_VALUE_NAME, VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<portInfos", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("alias")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<com.nxp.s32ds.apu:ApuGraph", Arrays.asList(REGEX_FOR_VALUE_NAME), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<graph", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<graphSource", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<graphSink", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("href")), null));
        ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine("<headers", Arrays.asList(VgtResourcesRefactoring.createRegexForValueName("path")), null));
    }

    private static String createRegexForValueName(String valueName) {
        return String.valueOf(valueName) + "=\"[^\"]*?%s[^\"]*?\"";
    }

    public IStatus renameProject(IProject target, IProject source, String search, String replace, IProgressMonitor monitor) {
        MultiStatus s;
        this.closedProjects.clear();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((s = this.applyOperation((IResource)target, source, VGT_FILES, search, replace, monitor)).isOK()) {
            this.postProcess(s, monitor);
        }
        return s;
    }

    private MultiStatus postProcess(MultiStatus s, IProgressMonitor monitor) {
        if (this.closedProjects.isEmpty()) {
            return s;
        }
        this.closeProjects(s, monitor);
        if (!s.isOK()) {
            return s;
        }
        Shell shell = null;
        try {
            Display display = Display.getDefault();
            if (display == null) {
                return s;
            }
            shell = display.getActiveShell();
        }
        catch (Exception exception) {
            return s;
        }
        if (shell == null) {
            return s;
        }
        Collection names = this.closedProjects.stream().map(IResource::getName).collect(Collectors.toSet());
        ListDialogWithToggle dialog = ListDialogWithToggle.openWithoutToggle((int)3, (Shell)shell, (String)UiMessages.VgtResourcesRefactoring_reopen_title, (String)UiMessages.VgtResourcesRefactoring_reopen_message, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (Collection)names);
        if (dialog.getReturnCode() == 2) {
            this.openProjects(s, monitor);
        }
        return s;
    }

    private void closeProjects(MultiStatus s, IProgressMonitor monitor) {
        for (IProject p : this.closedProjects) {
            try {
                p.close(monitor);
            }
            catch (CoreException e) {
                s.add(e.getStatus());
            }
        }
    }

    private void openProjects(MultiStatus s, IProgressMonitor monitor) {
        for (IProject p : this.closedProjects) {
            try {
                p.open(monitor);
            }
            catch (CoreException e) {
                s.add(e.getStatus());
            }
        }
    }

    private MultiStatus applyOperation(IResource target, IProject source, String[] filesExt, String search, String replace, IProgressMonitor monitor) {
        IProject[] projects;
        ArrayList filesMoved;
        MultiStatus mtStatus;
        block19: {
            IWorkspaceRoot root;
            block18: {
                mtStatus = new MultiStatus(BUNDLE_ID, 0, "", null);
                Map mapEdit = TextChangeFinder.findInResource((IResource)target, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
                List fileForRenameNotMatcher = TextChangeFinder.findResourceOutofMatching((IResource)target, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
                if (!mapEdit.isEmpty()) {
                    for (Map.Entry iter : mapEdit.entrySet()) {
                        this.applyChanges((IFile)iter.getKey(), (List)iter.getValue(), monitor);
                        mtStatus.add(this.renameFile((IFile)iter.getKey(), search, replace, monitor));
                    }
                }
                if (!fileForRenameNotMatcher.isEmpty()) {
                    for (IFile file : fileForRenameNotMatcher) {
                        mtStatus.add(this.renameFile(file, search, replace, monitor));
                    }
                }
                filesMoved = new ArrayList();
                filesMoved.addAll(mapEdit.keySet());
                filesMoved.addAll(fileForRenameNotMatcher);
                root = target.getWorkspace().getRoot();
                if (root != null) break block18;
                return null;
            }
            projects = root.getProjects();
            if (projects != null) break block19;
            return null;
        }
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (!p.equals((Object)target) && !p.equals((Object)source)) {
                    for (IFile file : filesMoved) {
                        IPath filePath = file.getProjectRelativePath();
                        String searchPattern = source.getFullPath().append(filePath).toOSString().replace("\\", "/");
                        String fileName = file.getName();
                        int position = fileName.lastIndexOf(".");
                        if (position > 0 && position < fileName.length() - 1) {
                            fileName = fileName.substring(0, position);
                            fileName = fileName.replace(search, replace);
                            fileName = String.valueOf(fileName) + "." + file.getFileExtension();
                        }
                        IPath middlePath = filePath.removeLastSegments(1).append(fileName);
                        String replacePattern = target.getFullPath().append(middlePath).toOSString().replace("\\", "/");
                        Map changes = TextChangeFinder.findInResource((IResource)p, (String[])this.getFileExtension(), (String)searchPattern, (String)replacePattern, (IProgressMonitor)monitor);
                        if (changes.isEmpty()) {
                            searchPattern = searchPattern.replaceAll(Pattern.quote("model/"), "model//");
                            replacePattern = replacePattern.replaceAll(Pattern.quote("model/"), "model//");
                            changes = TextChangeFinder.findInResource((IResource)p, (String[])this.getFileExtension(), (String)searchPattern, (String)replacePattern, (IProgressMonitor)monitor);
                            if (!changes.isEmpty()) {
                                for (IFile f : changes.keySet()) {
                                    if (f.getName().endsWith("aird")) continue;
                                    this.closedProjects.add(p);
                                    break;
                                }
                            }
                        }
                        for (Map.Entry iter : changes.entrySet()) {
                            this.applyChanges((IFile)iter.getKey(), (List)iter.getValue(), monitor);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            mtStatus.add(e.getStatus());
        }
        catch (MalformedTreeException e) {
            mtStatus.add((IStatus)new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e));
        }
        catch (BadLocationException e) {
            mtStatus.add((IStatus)new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e));
        }
        return mtStatus;
    }

    public IStatus renameProject(IProject resource, String search, String replace, IProgressMonitor monitor) {
        this.closedProjects.clear();
        return Status.OK_STATUS;
    }

    private void applyChanges(IFile fCurrentFile, List<ReplaceEdit> lstChanges, IProgressMonitor monitor) throws CoreException, MalformedTreeException, BadLocationException {
        IDocument doc = null;
        monitor.beginTask("", 2);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            IPath path = fCurrentFile.getFullPath();
            manager.connect(path, LocationKind.NORMALIZE, monitor);
            ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
            doc = buffer.getDocument();
            MultiTextEdit mte = this.getAffectedChanges(fCurrentFile, lstChanges, doc);
            mte.apply(doc);
            buffer.commit(monitor, true);
        }
        finally {
            if (doc != null) {
                manager.disconnect(fCurrentFile.getFullPath(), LocationKind.NORMALIZE, monitor);
            }
            monitor.done();
        }
    }

    private MultiTextEdit getAffectedChanges(IFile currentFile, List<ReplaceEdit> lstChanges, IDocument doc) {
        MultiTextEdit mte = new MultiTextEdit();
        if (lstChanges != null) {
            lstChanges.stream().forEach(p -> {
                if (!this.skipChange(ATTRIBUTES_AFFECTED, doc, (ReplaceEdit)p)) {
                    mte.addChild((TextEdit)p);
                }
            });
        }
        return mte;
    }

    public MultiTextEdit getAffectedChanges(IFile currentFile, List<ReplaceEdit> lstChanges, IProgressMonitor monitor) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath currentPath = currentFile.getFullPath();
        try {
            MultiTextEdit mte = new MultiTextEdit();
            manager.connect(currentPath, LocationKind.NORMALIZE, monitor);
            ITextFileBuffer buffer = manager.getTextFileBuffer(currentPath, LocationKind.NORMALIZE);
            if (buffer != null) {
                IDocument result = buffer.getDocument();
                lstChanges.stream().forEach(p -> {
                    if (!this.skipChange(ATTRIBUTES_AFFECTED, result, (ReplaceEdit)p)) {
                        mte.addChild((TextEdit)p);
                    }
                });
            }
            MultiTextEdit multiTextEdit = mte;
            return multiTextEdit;
        }
        finally {
            if (manager != null) {
                manager.disconnect(currentPath, LocationKind.NORMALIZE, monitor);
            }
        }
    }

    public String[] getFileExtension() {
        return VGT_FILES;
    }
}

