/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.operations;

import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtIdeCore;
import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.ui.VgtIdeUi;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectConfigurator;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class VgtProjectCreationOperation
extends WorkspaceModifyOperation {
    private final VgtRepresenter representer;
    private final VgtDescriptor descriptor;
    private final IProject projectHandle;
    private final URI projectLocation;
    private final IWorkingSet[] selectedWorkingSets;
    private final List<VgtProjectConfigurator> configurators;
    private final IRunnableWithProgress runBeforeBuild;

    public VgtProjectCreationOperation(VgtRepresenter representer, VgtDescriptor descriptor, IProject projectHandle, IProject targetProject, URI projectLocation, IWorkingSet[] selectedWorkingSets, IRunnableWithProgress runBeforeBuild) {
        this.representer = representer;
        this.descriptor = descriptor;
        this.projectHandle = projectHandle;
        this.projectLocation = projectLocation;
        this.selectedWorkingSets = selectedWorkingSets;
        this.runBeforeBuild = runBeforeBuild;
        this.configurators = new ArrayList<VgtProjectConfigurator>();
    }

    public VgtProjectCreationOperation(VgtRepresenter representer, VgtDescriptor descriptor, IProject projectHandle, IProject targetProject, URI projectLocation, IWorkingSet[] selectedWorkingSets) {
        this(representer, descriptor, projectHandle, targetProject, projectLocation, selectedWorkingSets, null);
    }

    public void addConfigurator(VgtProjectConfigurator configurator) {
        if (configurator != null) {
            this.configurators.add(configurator);
        }
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(UiMessages.GraphToolsProjectCreationOperation_task_create_project, 200);
            VgtIdeUi.createProject(this.projectHandle, this.projectLocation, this.selectedWorkingSets, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)30));
            EObject semanticModel = VgtIdeUi.createModelingResources(this.representer, this.descriptor, this.projectHandle, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
            monitor.subTask(UiMessages.GraphToolsProjectCreationOperation_subtask_prepare_the_modeling_project);
            ModelingProjectManager.INSTANCE.convertToModelingProject(this.projectHandle, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10));
            int size = this.configurators.size();
            if (size > 0) {
                SubMonitor configuratorMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                configuratorMonitor.beginTask(UiMessages.GraphToolsProjectCreationOperation_subtask_additional_configuration, size);
                for (VgtProjectConfigurator configurator : this.configurators) {
                    configurator.configure(this.descriptor, (IProgressMonitor)configuratorMonitor);
                    configuratorMonitor.worked(1);
                }
            }
            if (this.runBeforeBuild != null) {
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    this.runBeforeBuild.run((IProgressMonitor)sm);
                }
                finally {
                    sm.done();
                }
            }
            VgtIdeCore.addDisabledMdtBuilder((VgtRepresenter)this.representer, (VgtDescriptor)this.descriptor, (EObject)semanticModel, (IProgressMonitor)monitor);
            VgtIdeUi.createLaunchConfiguration(this.representer, this.descriptor, semanticModel, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

