/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.rcp.runtime.util.FilePaths;
import com.nxp.s32ds.ext.sirius.SiriusCore;
import com.nxp.s32ds.ext.sirius.SiriusViewpoints;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.internal.ui.VgtIdeUiActivator;
import com.nxp.s32ds.vgt.ide.ui.actions.ActionMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.command.RenameRepresentationCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.progress.WorkbenchJob;

public class VgtIdeUi {
    public static String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.vgt.ide.ui";
    public static final String PREFERENCE_SHOW_GENERATION_RESULT = "show_generation_result";
    public static final String NEW_PROJECT_GRAPHTOOLS = "com.nxp.s32ds.vgt.ide.ui.wizard.new.gteproject";
    public static final String PERSPECTIVE_GRAPHTOOLS = "com.nxp.s32ds.vgt.ide.ui.perspectives.perspective.vgt";

    public static String getShowGenerationResultPreference() {
        IPreferenceStore preferenceStore = VgtIdeUi.getPreferenceStore();
        return preferenceStore.getString(PREFERENCE_SHOW_GENERATION_RESULT);
    }

    public static IPreferenceStore getPreferenceStore() {
        IPreferenceStore preferenceStore = VgtIdeUiActivator.getDefault().getPreferenceStore();
        return preferenceStore;
    }

    public static IProject createProject(IProject projectHandle, java.net.URI location, IWorkingSet[] workingSets, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = projectHandle.getName();
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocationURI(location);
        projectHandle.create(description, monitor);
        projectHandle.open(monitor);
        IProject created = projectHandle;
        if (workingSets != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)created, workingSets);
        }
        if (!(folder = created.getFolder("model")).exists()) {
            folder.create(true, true, monitor);
        }
        return created;
    }

    public static void createLaunchConfiguration(VgtRepresenter representer, VgtDescriptor descriptor, EObject semanticModel, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfiguration = representer.createLaunchConfiguration(descriptor, semanticModel, monitor);
        if (launchConfiguration != null) {
            launchConfiguration.doSave();
        }
    }

    public static ResourceSet getResourceSet(IWorkbenchPart activePart, ISelection selection) {
        Object element;
        if (activePart instanceof DiagramEditor) {
            return ((DiagramEditor)activePart).getEditingDomain().getResourceSet();
        }
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)element).getTarget().eResource().getResourceSet();
        }
        return null;
    }

    public static void fillSession(Session session, String diagramName, List<String> semanticPaths, Set<Viewpoint> selectedViewpoints, IProgressMonitor monitor) {
        if (session != null) {
            TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
            ResourceSet resourceSet = editingDomain.getResourceSet();
            resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
            monitor.subTask(UiMessages.GraphToolsProjectCreationOperation_task_prepare_gte_project);
            CompoundCommand cc = new CompoundCommand(UiMessages.GraphToolsProjectCreationOperation_command_prepare_gte_project){

                public boolean canUndo() {
                    return false;
                }
            };
            for (String path : semanticPaths) {
                URI semanticUri = URI.createPlatformResourceURI((String)path, (boolean)true);
                SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                cc.append((Command)new AddSemanticResourceCommand(session, semanticUri, (IProgressMonitor)submonitor));
            }
            cc.append((Command)new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), selectedViewpoints, Collections.emptySet(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1)));
            monitor.subTask(UiMessages.GraphToolsProjectCreationOperation_task_link_models);
            CommandStack commandStack = editingDomain.getCommandStack();
            commandStack.execute((Command)cc);
            monitor.worked(10);
            cc = new CompoundCommand(UiMessages.GraphToolsProjectCreationOperation_command_prepare_gte_project){

                public boolean canUndo() {
                    return false;
                }
            };
            Collection ownedViews = session.getOwnedViews();
            for (DView dView : ownedViews) {
                EList ownedRepresentations = dView.getOwnedRepresentationDescriptors();
                for (DRepresentationDescriptor dRepresentationDecr : ownedRepresentations) {
                    DRepresentation dRepresentation = dRepresentationDecr.getRepresentation();
                    String representationName = dRepresentation.getName();
                    String rename = NLS.bind((String)UiMessages.GraphToolsUI_representation_name_pattern, (Object)representationName, (Object)diagramName);
                    RenameRepresentationCommand command = new RenameRepresentationCommand(editingDomain, dRepresentationDecr, rename);
                    cc.append((Command)command);
                }
            }
            commandStack.execute((Command)cc);
            session.save(monitor);
            monitor.worked(15);
        }
    }

    public static Image getImage(String key) {
        return VgtIdeUiActivator.getDefault().getImage(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return VgtIdeUiActivator.getDefault().getImageDescriptor(key);
    }

    public static List<VgtRepresenter> getRepresenters() {
        return VgtIdeUiActivator.getDefault().getRepresenters();
    }

    public static IFile createModelingResources(EObject semanticRoot, String semanticName, EObject generatorRoot, String generatorName, String representationsName, List<String> viewpointNames, IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(UiMessages.GraphToolsProjectCreationOperation_task_create_modeling_resources, 100);
        String modelPath = String.valueOf('/') + project.getName() + '/' + "model";
        ArrayList<String> paths = new ArrayList<String>();
        monitor.subTask(UiMessages.GraphToolsProjectCreationOperation_task_create_semantic_model);
        String semanticPath = String.valueOf(modelPath) + '/' + semanticName;
        IStatus saveSemantic = EmfResources.savePlatformResource((String)semanticPath, (EObject)semanticRoot);
        if (!saveSemantic.isOK()) {
            throw new CoreException(saveSemantic);
        }
        paths.add(semanticPath);
        monitor.worked(20);
        if (generatorRoot != null) {
            monitor.subTask(UiMessages.GraphToolsProjectCreationOperation_task_create_generation_model);
            String generatorPath = String.valueOf(modelPath) + '/' + generatorName;
            IStatus saveGenerator = EmfResources.savePlatformResource((String)generatorPath, (EObject)generatorRoot);
            if (!saveGenerator.isOK()) {
                throw new CoreException(saveGenerator);
            }
            paths.add(generatorPath);
        }
        monitor.worked(25);
        monitor.subTask(UiMessages.GraphToolsProjectCreationOperation_task_create_representation_model);
        Session session = SiriusCore.extractSession((IProject)project, (String)modelPath, (String)representationsName, (IProgressMonitor)monitor);
        monitor.worked(25);
        Set viewpoints = SiriusViewpoints.collectViewpoints(viewpointNames);
        Path path = new Path(semanticPath);
        String lastSegment = path.lastSegment();
        String diagramName = FilePaths.replaceExtension((String)lastSegment, null);
        VgtIdeUi.fillSession(session, diagramName, paths, viewpoints, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)30));
        IFile semanticFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(semanticPath));
        return semanticFile;
    }

    public static EObject createModelingResources(VgtRepresenter representer, VgtDescriptor descriptor, IProject project, IProgressMonitor monitor) throws CoreException {
        String semanticName = representer.getSemanticFileName(descriptor);
        EObject semanticModel = representer.createSemanticModel(descriptor);
        String generatorName = representer.getGeneratorFileName(descriptor);
        EObject generatorModel = representer.createGeneratorModel(descriptor, semanticModel);
        String representationsName = representer.getRepresentationFileName(descriptor);
        List viewpointNames = representer.getViewpointNames();
        VgtIdeUi.createModelingResources(semanticModel, semanticName, generatorModel, generatorName, representationsName, viewpointNames, project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
        return semanticModel;
    }

    public static void openFirstRepresentation(IProject project, IProgressMonitor monitor) {
        Session session;
        Option opionalModelingProject = ModelingProject.asModelingProject((IProject)project);
        if (opionalModelingProject.some() && (session = ((ModelingProject)opionalModelingProject.get()).getSession()) != null && !session.getSelectedViews().isEmpty()) {
            LinkedHashSet<DRepresentation> representationsToOpen = new LinkedHashSet<DRepresentation>();
            for (DView view : session.getSelectedViews()) {
                for (DRepresentationDescriptor dRepresentation : view.getOwnedRepresentationDescriptors()) {
                    representationsToOpen.add(dRepresentation.getRepresentation());
                }
            }
            for (DRepresentation dRepresentation : representationsToOpen) {
                final IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win.getActivePage() == null) {
                    try {
                        PlatformUI.getWorkbench().showPerspective(PERSPECTIVE_GRAPHTOOLS, win);
                    }
                    catch (WorkbenchException workbenchException) {
                        ErrorDialog errorDialog = new ErrorDialog(win.getShell(), UiMessages.GraphToolPerspectiveOpeningError, UiMessages.GraphToolPerspectiveOpeningErrorTitle, (IStatus)new Status(4, "com.nxp.s32ds.vgt.ide.ui", UiMessages.GraphToolPerspectiveOpeningErrorDesc), 4);
                        errorDialog.open();
                    }
                }
                if (win.getActivePage() == null) continue;
                DialectUIManager.INSTANCE.openEditor(session, dRepresentation, monitor);
                WorkbenchJob job = new WorkbenchJob(Display.getDefault(), ActionMessages.SaveAction){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        win.getActivePage().saveEditor(win.getActivePage().getActiveEditor(), false);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    public static void selectAndReveal(IResource resource, IWorkbenchPage page) {
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            part.getSite().getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                @Override
                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    public static void saveDiagram(IWorkbenchWindow activeWorkbenchWindow) {
        IWorkbenchPart activePart = activeWorkbenchWindow.getActivePage().getActivePart();
        DiagramEditor diagramEditor = (DiagramEditor)activePart;
        if (!(activePart instanceof DiagramEditor)) {
            return;
        }
        TransactionalEditingDomain editingDomain = diagramEditor.getEditingDomain();
        EcoreUtil.resolveAll((ResourceSet)editingDomain.getResourceSet());
        diagramEditor.doSave((IProgressMonitor)new NullProgressMonitor());
    }
}

