/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.internal.ui.handlers;

import com.nxp.s32ds.vgt.ide.core.VgtReconciler;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.internal.ui.VgtIdeUiActivator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.diagram.ui.part.ValidateAction;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ValidateDiagramHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof DiagramEditor)) {
            return null;
        }
        DiagramEditor diagramEditor = (DiagramEditor)activePart;
        this.saveEditor(diagramEditor);
        EObject element = diagramEditor.getDiagram().getElement();
        if (!(element instanceof DSemanticDecorator)) {
            return null;
        }
        EObject semanticElement = ((DSemanticDecorator)element).getTarget();
        this.saveEditor(diagramEditor);
        IStatus iStatus = BasicDiagnostic.toIStatus((Diagnostic)Diagnostician.INSTANCE.validate(semanticElement));
        ValidateAction.runValidation((View)diagramEditor.getDiagram());
        if (iStatus.isOK()) {
            MessageDialog.openInformation((Shell)shell, (String)UiMessages.ValidateDiagramHandler_information_title, (String)UiMessages.ValidateDiagramHandler_information_message);
        } else if (iStatus.getSeverity() == 2) {
            MessageDialog.openWarning((Shell)shell, (String)UiMessages.ValidateDiagramHandler_warning_title, (String)UiMessages.ValidateDiagramHandler_warning_message);
        } else if (iStatus.getSeverity() == 4) {
            MessageDialog.openError((Shell)shell, (String)UiMessages.ValidateDiagramHandler_error_title, (String)UiMessages.ValidateDiagramHandler_error_message);
        }
        return null;
    }

    private void saveEditor(DiagramEditor diagramEditor) {
        if (diagramEditor.isDirty()) {
            diagramEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void reconcile(EObject semanticElement) {
        List<VgtReconciler> reconcilers = VgtIdeUiActivator.getDefault().getReconcilers();
        for (VgtReconciler reconciler : reconcilers) {
            if (!reconciler.isApplicable(semanticElement)) continue;
            reconciler.doUpdate(semanticElement);
        }
    }
}

