/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff;

import com.ibm.icu.text.DateFormat;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class XCoff32 {
    public static final String NL = System.getProperty("line.separator", "\n");
    String filename;
    FileHeader filehdr;
    OptionalHeader opthdr;
    RandomAccessFile rfile;
    long startingOffset;
    byte[] string_table;
    SectionHeader[] scnhdrs;
    Symbol[] symbols;

    public Attribute getAttributes() {
        Attribute attrib = new Attribute();
        switch (this.filehdr.f_magic) {
            case 479: {
                attrib.cpu = "xcoff32";
                break;
            }
            case 503: {
                attrib.cpu = "xcoff64";
                break;
            }
            default: {
                attrib.cpu = "unknown";
            }
        }
        attrib.type = (this.filehdr.f_flags & 0x2000) != 0 ? 2 : ((this.filehdr.f_flags & 2) != 0 ? 1 : 3);
        attrib.isle = false;
        short cfr_ignored_0 = this.filehdr.f_flags;
        attrib.bDebug = !false;
        return attrib;
    }

    public FileHeader getFileHeader() throws IOException {
        return this.filehdr;
    }

    public OptionalHeader getOptionalHeader() throws IOException {
        return this.opthdr;
    }

    public SectionHeader[] getSectionHeaders() throws IOException {
        if (this.scnhdrs == null) {
            this.getRandomAccessFile();
            this.scnhdrs = new SectionHeader[this.getFileHeader().f_nscns];
            long sec = this.startingOffset + 20L + (long)this.getFileHeader().f_opthdr;
            int i = 0;
            while (i < this.scnhdrs.length) {
                this.scnhdrs[i] = new SectionHeader(this.rfile, sec);
                ++i;
                sec += 40L;
            }
        }
        return this.scnhdrs;
    }

    public Symbol[] getSymbols() throws IOException {
        if (this.symbols == null) {
            long offset = this.startingOffset + (long)this.getFileHeader().f_symptr;
            this.getRandomAccessFile();
            this.rfile.seek(offset);
            int numSymbols = this.getFileHeader().f_nsyms;
            ArrayList<Symbol> symList = new ArrayList<Symbol>(numSymbols);
            int i = 0;
            while (i < numSymbols) {
                Symbol v = new Symbol(this.rfile);
                symList.add(v);
                i += v.n_numaux;
                ++i;
            }
            this.symbols = symList.toArray(new Symbol[symList.size()]);
        }
        return this.symbols;
    }

    public byte[] getStringTable() throws IOException {
        if (this.string_table == null && this.filehdr.f_nsyms > 0) {
            this.getRandomAccessFile();
            long symbolsize = 18 * this.getFileHeader().f_nsyms;
            long offset = this.startingOffset + (long)this.getFileHeader().f_symptr + symbolsize;
            this.rfile.seek(offset);
            byte[] bytes = new byte[4];
            this.rfile.readFully(bytes);
            int str_len = ReadMemoryAccess.getIntBE(bytes);
            if (str_len > 4 && (long)str_len < this.rfile.length()) {
                this.string_table = new byte[str_len -= 4];
                this.rfile.seek(offset + 4L);
                this.rfile.readFully(this.string_table);
            } else {
                this.string_table = new byte[0];
            }
        }
        return this.string_table;
    }

    protected XCoff32() {
    }

    public XCoff32(String filename) throws IOException {
        this(filename, 0L);
    }

    public XCoff32(String filename, long offset) throws IOException {
        this.filename = filename;
        this.commonSetup(new RandomAccessFile(filename, "r"), offset);
    }

    void commonSetup(RandomAccessFile file, long offset) throws IOException {
        this.startingOffset = offset;
        this.rfile = file;
        try {
            this.filehdr = new FileHeader(this.rfile, this.startingOffset);
            if (this.filehdr.f_opthdr > 0) {
                this.opthdr = new OptionalHeader(this.rfile, this.startingOffset + 20L);
            }
            if (this.filehdr.f_opthdr < 72) {
                this.getSectionHeaders();
                int i = 0;
                while (i < this.filehdr.f_nscns) {
                    if ((this.scnhdrs[i].s_flags & 0x20) != 0) {
                        this.opthdr.o_sntext = (short)(i + 1);
                    } else if ((this.scnhdrs[i].s_flags & 0x80) != 0) {
                        this.opthdr.o_snbss = (short)(i + 1);
                    } else if ((this.scnhdrs[i].s_flags & 0x40) != 0) {
                        this.opthdr.o_sndata = (short)(i + 1);
                    }
                    ++i;
                }
            }
        }
        finally {
            this.dispose();
        }
    }

    public String toString() {
        int n;
        int n2;
        Object[] objectArray;
        StringBuilder buffer = new StringBuilder();
        try {
            FileHeader header = null;
            header = this.getFileHeader();
            if (header != null) {
                buffer.append(header);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            OptionalHeader opt = null;
            opt = this.getOptionalHeader();
            if (opt != null) {
                buffer.append(opt);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            SectionHeader[] sections = this.getSectionHeaders();
            objectArray = sections;
            n2 = sections.length;
            n = 0;
            while (n < n2) {
                Object section = objectArray[n];
                buffer.append(section);
                ++n;
            }
        }
        catch (IOException iOException) {}
        try {
            Symbol[] table = this.getSymbols();
            objectArray = table;
            n2 = table.length;
            n = 0;
            while (n < n2) {
                Object element = objectArray[n];
                buffer.append(element).append("n_name = ");
                buffer.append(((Symbol)element).getName(this.getStringTable())).append(NL);
                ++n;
            }
        }
        catch (IOException iOException) {}
        return buffer.toString();
    }

    public void dispose() throws IOException {
        if (this.rfile != null) {
            this.rfile.close();
            this.rfile = null;
        }
    }

    RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.rfile == null) {
            this.rfile = new RandomAccessFile(this.filename, "r");
        }
        return this.rfile;
    }

    public static void main(String[] args) {
        try {
            XCoff32 xcoff = new XCoff32(args[0]);
            System.out.println(xcoff);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isXCOFF32Header(byte[] hints) {
        return hints != null && hints[0] == 1 && hints[1] == -33;
    }

    public static Attribute getAttributes(byte[] hints) throws IOException {
        XCoff32 emptyXCoff = new XCoff32();
        emptyXCoff.filehdr = new FileHeader(hints, false);
        Attribute attribute = emptyXCoff.getAttributes();
        emptyXCoff.dispose();
        return attribute;
    }

    public static Attribute getAttributes(String file) throws IOException {
        XCoff32 xcoff = new XCoff32(file);
        Attribute attribute = xcoff.getAttributes();
        xcoff.dispose();
        return attribute;
    }

    public static class Attribute {
        public static final int XCOFF_TYPE_EXE = 1;
        public static final int XCOFF_TYPE_SHLIB = 2;
        public static final int XCOFF_TYPE_OBJ = 3;
        public static final int XCOFF_TYPE_CORE = 4;
        String cpu;
        int type;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.bDebug;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }
    }

    public static class FileHeader {
        public static final int FILHSZ = 20;
        public static final int U802TOCMAGIC = 479;
        public static final int U803TOCMAGIC = 487;
        public static final int U803XTOCMAGIC = 495;
        public static final int U64_TOCMAGIC = 503;
        public static final int F_RELFLG = 1;
        public static final int F_EXEC = 2;
        public static final int F_LNNO = 4;
        public static final int F_LSYMS = 8;
        public static final int F_FDPR_PROF = 16;
        public static final int F_FDPR_OPTI = 32;
        public static final int F_DSA = 64;
        public static final int F_DYNLOAD = 4096;
        public static final int F_SHROBJ = 8192;
        public static final int F_LOADONLY = 16384;
        public short f_magic;
        public short f_nscns;
        public int f_timdat;
        public int f_symptr;
        public int f_nsyms;
        public short f_opthdr;
        public short f_flags;

        public FileHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public FileHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[20];
            file.readFully(hdr);
            this.commonSetup(hdr, false);
        }

        public FileHeader(byte[] hdr, boolean little) throws IOException {
            this.commonSetup(hdr, little);
        }

        public void commonSetup(byte[] hdr, boolean little) throws IOException {
            if (hdr == null || hdr.length < 20) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.arrayToSmall"));
            }
            if (!XCoff32.isXCOFF32Header(hdr)) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notXCOFF32"));
            }
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, little);
            this.f_magic = memory.getShort();
            this.f_nscns = memory.getShort();
            this.f_timdat = memory.getInt();
            this.f_symptr = memory.getInt();
            this.f_nsyms = memory.getInt();
            this.f_opthdr = memory.getShort();
            this.f_flags = memory.getShort();
        }

        public boolean isStrip() {
            return (this.f_flags & 1) == 1;
        }

        public boolean isExec() {
            return (this.f_flags & 2) == 2;
        }

        public boolean isDebug() {
            return (this.f_flags & 4) != 4;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("FILE HEADER VALUES").append(NL);
            buffer.append("f_magic  = ").append(this.f_magic).append(NL);
            buffer.append("f_nscns  = ").append(this.f_nscns).append(NL);
            buffer.append("f_timdat = ");
            buffer.append(DateFormat.getDateInstance().format(new Date(this.f_timdat)));
            buffer.append(NL);
            buffer.append("f_symptr = ").append(this.f_symptr).append(NL);
            buffer.append("f_nsyms  = ").append(this.f_nsyms).append(NL);
            buffer.append("f_opthdr = ").append(this.f_opthdr).append(NL);
            buffer.append("f_flags  = ").append(this.f_flags).append(NL);
            return buffer.toString();
        }
    }

    public static class OptionalHeader {
        public static final int AOUTHDRSZ = 72;
        public short magic;
        public short vstamp;
        public int tsize;
        public int dsize;
        public int bsize;
        public int entry;
        public int text_start;
        public int data_start;
        public int o_toc;
        public short o_snentry;
        public short o_sntext;
        public short o_sndata;
        public short o_sntoc;
        public short o_snloader;
        public short o_snbss;
        public short o_algntext;
        public short o_algndata;
        public short o_modtype;
        public byte o_cpuflag;
        public byte o_cputype;
        public int o_maxstack;
        public int o_maxdata;
        public int o_debugger;

        public OptionalHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer() + 20L);
        }

        public OptionalHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[72];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, false);
            this.magic = memory.getShort();
            this.vstamp = memory.getShort();
            this.tsize = memory.getInt();
            this.dsize = memory.getInt();
            this.bsize = memory.getInt();
            this.entry = memory.getInt();
            this.text_start = memory.getInt();
            this.data_start = memory.getInt();
            this.o_toc = memory.getInt();
            this.o_snentry = memory.getShort();
            this.o_sntext = memory.getShort();
            this.o_sndata = memory.getShort();
            this.o_sntoc = memory.getShort();
            this.o_snloader = memory.getShort();
            this.o_snbss = memory.getShort();
            this.o_algntext = memory.getShort();
            this.o_algndata = memory.getShort();
            this.o_modtype = memory.getShort();
            this.o_cpuflag = memory.getByte();
            this.o_cputype = memory.getByte();
            this.o_maxstack = memory.getInt();
            this.o_maxdata = memory.getInt();
            this.o_debugger = memory.getInt();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("OPTIONAL HEADER VALUES").append(NL);
            buffer.append("magic      = ").append(this.magic).append(NL);
            buffer.append("vstamp     = ").append(this.vstamp).append(NL);
            buffer.append("tsize      = ").append(this.tsize).append(NL);
            buffer.append("dsize      = ").append(this.dsize).append(NL);
            buffer.append("bsize      = ").append(this.bsize).append(NL);
            buffer.append("entry      = ").append(this.entry).append(NL);
            buffer.append("text_start = ").append(this.text_start).append(NL);
            buffer.append("data_start = ").append(this.data_start).append(NL);
            buffer.append("o_toc      = ").append(this.o_toc).append(NL);
            buffer.append("o_snentry  = ").append(this.o_snentry).append(NL);
            buffer.append("o_sntext   = ").append(this.o_sntext).append(NL);
            buffer.append("o_sndata   = ").append(this.o_sndata).append(NL);
            buffer.append("o_sntoc    = ").append(this.o_sntoc).append(NL);
            buffer.append("o_snloader = ").append(this.o_snloader).append(NL);
            buffer.append("o_snbss    = ").append(this.o_snbss).append(NL);
            buffer.append("o_algntext = ").append(this.o_algntext).append(NL);
            buffer.append("o_algndata = ").append(this.o_algndata).append(NL);
            buffer.append("o_modtype  = ").append(this.o_modtype).append(NL);
            buffer.append("o_cpuflag  = ").append(this.o_cpuflag).append(NL);
            buffer.append("o_cputype  = ").append(this.o_cputype).append(NL);
            buffer.append("o_maxstack = ").append(this.o_maxstack).append(NL);
            buffer.append("o_maxdata  = ").append(this.o_maxdata).append(NL);
            buffer.append("o_debugger = ").append(this.o_debugger).append(NL);
            return buffer.toString();
        }
    }

    public static class SectionHeader {
        public static final int SCNHSZ = 40;
        public static final String _TEXT = ".text";
        public static final String _DATA = ".data";
        public static final String _BSS = ".bss";
        public static final String _PAD = ".pad";
        public static final String _LOADER = ".loader";
        public static final String _DEBUG = ".debug";
        public static final String _TYPCHK = ".typchk";
        public static final String _EXCEPT = ".except";
        public static final String _OVRFLO = ".ovrflo";
        public static final String _INFO = ".info";
        public static final int STYP_PAD = 8;
        public static final int STYP_TEXT = 32;
        public static final int STYP_DATA = 64;
        public static final int STYP_BSS = 128;
        public static final int STYP_EXCEPT = 128;
        public static final int STYP_INFO = 512;
        public static final int STYP_LOADER = 4096;
        public static final int STYP_DEBUG = 8192;
        public static final int STYP_TYPCHK = 16384;
        public static final int STYP_OVRFLO = 32768;
        public byte[] s_name = new byte[8];
        public int s_paddr;
        public int s_vaddr;
        public int s_size;
        public int s_scnptr;
        public int s_relptr;
        public int s_lnnoptr;
        public short s_nreloc;
        public short s_nlnno;
        public int s_flags;
        RandomAccessFile sfile;

        public SectionHeader(RandomAccessFile file, long offset) throws IOException {
            this.sfile = file;
            file.seek(offset);
            byte[] hdr = new byte[40];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, false);
            memory.getBytes(this.s_name);
            this.s_paddr = memory.getInt();
            this.s_vaddr = memory.getInt();
            this.s_size = memory.getInt();
            this.s_scnptr = memory.getInt();
            this.s_relptr = memory.getInt();
            this.s_lnnoptr = memory.getInt();
            this.s_nreloc = memory.getShort();
            this.s_nlnno = memory.getShort();
            this.s_flags = memory.getInt();
        }

        public byte[] getRawData() throws IOException {
            byte[] data = new byte[this.s_size];
            this.sfile.seek(this.s_scnptr);
            this.sfile.readFully(data);
            return data;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SECTION HEADER VALUES").append(NL);
            buffer.append(new String(this.s_name)).append(NL);
            buffer.append("s_paddr = ").append(this.s_paddr).append(NL);
            buffer.append("s_vaddr = ").append(this.s_vaddr).append(NL);
            buffer.append("s_size = ").append(this.s_size).append(NL);
            buffer.append("s_scnptr = ").append(this.s_scnptr).append(NL);
            buffer.append("s_relptr = ").append(this.s_relptr).append(NL);
            buffer.append("s_lnnoptr = ").append(this.s_lnnoptr).append(NL);
            buffer.append("s_nreloc = ").append(this.s_nreloc).append(NL);
            buffer.append("s_nlnno = ").append(this.s_nlnno).append(NL);
            buffer.append("s_flags = ").append(this.s_flags).append(NL);
            return buffer.toString();
        }
    }

    public class Symbol {
        public static final int SYMSZ = 18;
        public static final int SYMNMLEN = 8;
        public static final int N_DEBUG = -2;
        public static final int N_ABS = -1;
        public static final int N_UNDEF = 0;
        public static final int C_BCOMM = 135;
        public static final int C_BINCL = 108;
        public static final int C_BLOCK = 100;
        public static final int C_BSTAT = 143;
        public static final int C_DECL = 140;
        public static final int C_ECOML = 136;
        public static final int C_ECOMM = 127;
        public static final int C_EINCL = 109;
        public static final int C_ENTRY = 141;
        public static final int C_ESTAT = 144;
        public static final int C_EXT = 2;
        public static final int C_FCN = 101;
        public static final int C_FILE = 103;
        public static final int C_FUN = 142;
        public static final int C_GSYM = 128;
        public static final int C_HIDEXT = 107;
        public static final int C_INFO = 100;
        public static final int C_LSYM = 129;
        public static final int C_NULL = 0;
        public static final int C_PSYM = 130;
        public static final int C_RPSYM = 132;
        public static final int C_RSYM = 131;
        public static final int C_STAT = 3;
        public static final int C_STSYM = 133;
        public static final int C_TCSYM = 134;
        public static final int C_WEAKEXT = 111;
        public static final int XMC_PR = 0;
        public static final int XMC_RO = 1;
        public static final int XMC_DB = 2;
        public static final int XMC_TC = 3;
        public static final int XMC_UA = 4;
        public static final int XMC_RW = 5;
        public static final int XMC_GL = 6;
        public static final int XMC_XO = 7;
        public static final int XMC_SV = 8;
        public static final int XMC_BS = 9;
        public static final int XMC_DS = 10;
        public static final int XMC_UC = 11;
        public static final int XMC_TI = 12;
        public static final int XMC_TB = 13;
        public static final int XMC_TC0 = 15;
        public static final int XMC_TD = 16;
        public static final int XMC_SV64 = 17;
        public static final int XMC_SV3264 = 18;
        public byte[] _n_name = new byte[8];
        public int n_value;
        public short n_scnum;
        public short n_type;
        public byte n_sclass;
        public byte n_numaux;
        private byte[] aux;
        public byte x_smclas;

        public Symbol(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public Symbol(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] bytes = new byte[18];
            file.readFully(bytes);
            ReadMemoryAccess memory = new ReadMemoryAccess(bytes, false);
            memory.getBytes(this._n_name);
            this.n_value = memory.getInt();
            this.n_scnum = memory.getShort();
            this.n_type = memory.getShort();
            this.n_sclass = memory.getByte();
            this.n_numaux = memory.getByte();
            this.aux = new byte[this.n_numaux * 18];
            file.readFully(this.aux);
            this.x_smclas = this.n_numaux > 0 ? this.aux[this.aux.length - 7] : (byte)0;
        }

        private boolean isLongName() {
            return this._n_name[0] == 0 && this._n_name[1] == 0 && this._n_name[2] == 0 && this._n_name[3] == 0;
        }

        private String getShortName() {
            int i = 0;
            while (i < this._n_name.length) {
                if (this._n_name[i] == 0) {
                    return new String(this._n_name, 0, i);
                }
                ++i;
            }
            return "";
        }

        public String getName(byte[] table) {
            if (table.length > 0 && this.isLongName()) {
                ReadMemoryAccess memory = new ReadMemoryAccess(this._n_name, false);
                memory.getInt();
                int offset = memory.getInt() - 4;
                if (offset >= 0) {
                    int i = offset;
                    while (i < table.length) {
                        if (table[i] == 0) {
                            return new String(table, offset, i - offset);
                        }
                        ++i;
                    }
                }
            }
            return this.getShortName();
        }

        public boolean isFunction() {
            return (this.n_sclass == 2 || this.n_sclass == 107 || this.n_sclass == 111) && this.n_scnum == XCoff32.this.opthdr.o_sntext && !this.getShortName().equals(".text");
        }

        public boolean isVariable() {
            return !(this.n_sclass != 2 && this.n_sclass != 107 && this.n_sclass != 111 || this.n_scnum != XCoff32.this.opthdr.o_snbss && this.n_scnum != XCoff32.this.opthdr.o_sndata || this.x_smclas == 15 || this.x_smclas == 3 || this.x_smclas == 10 || this.getShortName().equals(".bss") || this.getShortName().equals(".data"));
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SYMBOL TABLE ENTRY").append(NL);
            buffer.append("n_value = ").append(this.n_value).append(NL);
            buffer.append("n_scnum = ").append(this.n_scnum).append(NL);
            buffer.append("n_type = ").append(this.n_type).append(NL);
            buffer.append("n_sclass = ").append(this.n_sclass).append(NL);
            buffer.append("n_numaux = ").append(this.n_numaux).append(NL);
            return buffer.toString();
        }
    }
}

