/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.DefaultGnuToolFactory;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.som.AR;
import org.eclipse.cdt.utils.som.SOM;
import org.eclipse.cdt.utils.som.parser.SOMBinaryArchive;
import org.eclipse.cdt.utils.som.parser.SOMBinaryExecutable;
import org.eclipse.cdt.utils.som.parser.SOMBinaryObject;
import org.eclipse.cdt.utils.som.parser.SOMBinaryShared;
import org.eclipse.core.runtime.IPath;

public class SOMParser
extends AbstractCExtension
implements IBinaryParser {
    private DefaultGnuToolFactory toolFactory;

    @Override
    public IBinaryParser.IBinaryFile getBinary(byte[] hints, IPath path) throws IOException {
        if (path == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile binary = null;
        try {
            SOM.Attribute attribute = null;
            if (hints != null && hints.length > 0) {
                try {
                    attribute = SOM.getAttributes(hints);
                }
                catch (EOFException eOFException) {}
            }
            if (attribute == null) {
                attribute = SOM.getAttributes(path.toOSString());
            }
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        binary = this.createBinaryExecutable(path);
                        break;
                    }
                    case 2: {
                        binary = this.createBinaryShared(path);
                        break;
                    }
                    case 3: {
                        binary = this.createBinaryObject(path);
                        break;
                    }
                    case 4: {
                        binary = this.createBinaryCore(path);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            binary = this.createBinaryArchive(path);
        }
        return binary;
    }

    @Override
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        return this.getBinary(null, path);
    }

    @Override
    public String getFormat() {
        return "SOM";
    }

    @Override
    public boolean isBinary(byte[] hints, IPath path) {
        return SOM.isSOMHeader(hints) || AR.isARHeader(hints);
    }

    @Override
    public int getHintBufferSize() {
        return 512;
    }

    private IBinaryParser.IBinaryExecutable createBinaryExecutable(IPath path) {
        return new SOMBinaryExecutable(this, path);
    }

    private IBinaryParser.IBinaryShared createBinaryShared(IPath path) {
        return new SOMBinaryShared(this, path);
    }

    private IBinaryParser.IBinaryObject createBinaryObject(IPath path) {
        return new SOMBinaryObject((IBinaryParser)this, path, 1);
    }

    private IBinaryParser.IBinaryObject createBinaryCore(IPath path) {
        return new SOMBinaryObject((IBinaryParser)this, path, 16);
    }

    private IBinaryParser.IBinaryArchive createBinaryArchive(IPath path) throws IOException {
        return new SOMBinaryArchive(this, path);
    }

    protected DefaultGnuToolFactory createGNUToolFactory() {
        return new DefaultGnuToolFactory(this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IGnuToolFactory.class)) {
            if (this.toolFactory == null) {
                this.toolFactory = this.createGNUToolFactory();
            }
            return (T)this.toolFactory;
        }
        return (T)super.getAdapter(adapter);
    }
}

