/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.stabs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.debug.DebugArrayType;
import org.eclipse.cdt.utils.debug.DebugBaseType;
import org.eclipse.cdt.utils.debug.DebugCrossRefType;
import org.eclipse.cdt.utils.debug.DebugEnumField;
import org.eclipse.cdt.utils.debug.DebugEnumType;
import org.eclipse.cdt.utils.debug.DebugField;
import org.eclipse.cdt.utils.debug.DebugFunctionType;
import org.eclipse.cdt.utils.debug.DebugParameterKind;
import org.eclipse.cdt.utils.debug.DebugPointerType;
import org.eclipse.cdt.utils.debug.DebugReferenceType;
import org.eclipse.cdt.utils.debug.DebugStructType;
import org.eclipse.cdt.utils.debug.DebugType;
import org.eclipse.cdt.utils.debug.DebugUnknownType;
import org.eclipse.cdt.utils.debug.DebugVariableKind;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.stabs.StringField;
import org.eclipse.cdt.utils.debug.stabs.TypeInformation;
import org.eclipse.cdt.utils.debug.stabs.TypeNumber;
import org.eclipse.cdt.utils.debug.tools.DebugSym;
import org.eclipse.cdt.utils.debug.tools.DebugSymsRequestor;
import org.eclipse.cdt.utils.elf.Elf;

public class Stabs {
    static final String LLLOW = "01000000000000000000000";
    static final String LLHIGH = "0777777777777777777777";
    static final String ULLHIGH = "01777777777777777777777";
    byte[] stabData;
    byte[] stabstrData;
    boolean isLe;
    boolean inCompilationUnit;
    boolean inFunction;
    boolean inInclude;
    int bracket;
    String currentFile;
    Map<TypeNumber, DebugType> mapTypes = new HashMap<TypeNumber, DebugType>();
    DebugType voidType = new DebugBaseType("void", 0, false);

    public Stabs(String file) throws IOException {
        try {
            Elf exe = new Elf(file);
            this.init(exe);
            exe.dispose();
        }
        catch (IOException iOException) {
            PE exe = new PE(file);
            this.init(exe);
            exe.dispose();
        }
    }

    public Stabs(Elf exe) throws IOException {
        this.init(exe);
    }

    public Stabs(byte[] stab, byte[] stabstr, boolean le) {
        this.init(stab, stabstr, le);
    }

    void init(Elf exe) throws IOException {
        boolean isLE;
        Elf.Section[] sections;
        byte[] data = null;
        byte[] stabstr = null;
        Elf.Section[] sectionArray = sections = exe.getSections();
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            Elf.Section section = sectionArray[n2];
            String name = section.toString();
            if (name.equals(".stab")) {
                data = section.loadSectionData();
            } else if (name.equals(".stabstr")) {
                stabstr = section.loadSectionData();
            }
            ++n2;
        }
        Elf.ELFhdr header = exe.getELFhdr();
        boolean bl = isLE = header.e_ident[5] == 1;
        if (data != null && stabstr != null) {
            this.init(data, stabstr, isLE);
        }
    }

    void init(PE exe) throws IOException {
        Coff.SectionHeader[] sections;
        byte[] data = null;
        byte[] stabstr = null;
        Coff.SectionHeader[] sectionHeaderArray = sections = exe.getSectionHeaders();
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            Coff.SectionHeader section = sectionHeaderArray[n2];
            String name = new String(section.s_name).trim();
            if (name.equals(".stab")) {
                data = section.getRawData();
            } else if (name.equals(".stabstr")) {
                stabstr = section.getRawData();
            }
            ++n2;
        }
        PE.Attribute att = exe.getAttribute();
        if (data != null && stabstr != null) {
            this.init(data, stabstr, att.isLittleEndian());
        }
    }

    void init(byte[] stab, byte[] stabstr, boolean le) {
        this.stabData = stab;
        this.stabstrData = stabstr;
        this.isLe = le;
    }

    String makeString(long offset) {
        StringBuilder buf = new StringBuilder();
        while (offset < (long)this.stabstrData.length) {
            byte b = this.stabstrData[(int)offset];
            if (b == 0) break;
            buf.append((char)b);
            ++offset;
        }
        return buf.toString();
    }

    int read_4_bytes(byte[] bytes, int offset) {
        if (this.isLe) {
            return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
        }
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    short read_2_bytes(byte[] bytes, int offset) {
        if (this.isLe) {
            return (short)((bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF);
        }
        return (short)((bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF);
    }

    public void parse(IDebugEntryRequestor requestor) {
        long nstab = this.stabData.length / 12;
        String holder = null;
        long stroff = 0L;
        int type = 0;
        int other = 0;
        short desc = 0;
        long value = 0L;
        int offset = 0;
        int i = 0;
        this.bracket = 0;
        while ((long)i < nstab) {
            stroff = this.read_4_bytes(this.stabData, offset);
            type = 0xFF & this.stabData[offset + 4];
            other = 0xFF & this.stabData[offset + 5];
            desc = this.read_2_bytes(this.stabData, offset + 6);
            value = this.read_4_bytes(this.stabData, offset + 8);
            String field = stroff > 0L ? this.makeString(stroff) : "";
            if (field.endsWith("\\") || field.endsWith("?")) {
                field = field.substring(0, field.length() - 1);
                holder = holder == null ? field : String.valueOf(holder) + field;
            } else {
                if (holder != null) {
                    field = String.valueOf(holder) + field;
                    holder = null;
                }
                this.parseStabEntry(requestor, field, type, other, desc, value);
            }
            ++i;
            offset += 12;
        }
        if (this.inFunction) {
            requestor.exitFunction(-1L);
            this.inFunction = false;
        }
        if (this.inInclude) {
            requestor.exitInclude();
            this.inInclude = false;
        }
        if (this.inCompilationUnit) {
            requestor.exitCompilationUnit(value);
            this.inCompilationUnit = false;
            this.currentFile = null;
        }
    }

    void parseStabEntry(IDebugEntryRequestor requestor, String field, int type, int other, short desc, long value) {
        switch (type) {
            case 32: 
            case 128: 
            case 160: {
                this.parseStabString(requestor, field, value);
                break;
            }
            case 68: {
                requestor.acceptStatement(desc, value);
                break;
            }
            case 36: {
                if (this.inFunction) {
                    requestor.exitFunction(value);
                    this.inFunction = false;
                }
                if (field.length() == 0) {
                    field = " anon ";
                }
                this.inFunction = true;
                this.parseStabString(requestor, field, value);
                break;
            }
            case 192: {
                if (this.inFunction) {
                    requestor.enterCodeBlock(value);
                }
                ++this.bracket;
                break;
            }
            case 224: {
                requestor.exitCodeBlock(value);
                --this.bracket;
                break;
            }
            case 130: {
                requestor.enterInclude(field);
                this.inInclude = true;
                break;
            }
            case 162: {
                requestor.exitInclude();
                this.inInclude = false;
                break;
            }
            case 132: {
                if (this.inInclude) {
                    requestor.exitInclude();
                    this.inInclude = false;
                }
                requestor.enterInclude(field);
                this.inInclude = true;
                break;
            }
            case 84: {
                this.parseStabString(requestor, field, value);
                break;
            }
            case 100: {
                if (this.inFunction) {
                    requestor.exitFunction(-1L);
                    this.inFunction = false;
                }
                if (this.inInclude) {
                    requestor.exitInclude();
                    this.inInclude = false;
                }
                if (this.inCompilationUnit) {
                    requestor.exitCompilationUnit(value);
                    this.inCompilationUnit = false;
                    this.currentFile = null;
                }
                if (field == null || field.length() <= 0) break;
                if (field.endsWith("/")) {
                    this.currentFile = field;
                    break;
                }
                this.currentFile = this.currentFile != null ? String.valueOf(this.currentFile) + field : field;
                requestor.enterCompilationUnit(this.currentFile, value);
                this.inCompilationUnit = true;
                this.currentFile = null;
            }
        }
    }

    void parseStabString(IDebugEntryRequestor requestor, String field, long value) {
        StringField sf = new StringField(field);
        switch (sf.getSymbolDescriptor()) {
            case ':': {
                break;
            }
            case 'a': {
                String information = sf.getTypeInformation();
                String paramName = sf.getName();
                DebugParameterKind paramKind = DebugParameterKind.REGISTER_REFERENCE;
                DebugType paramType = this.parseStabType("", information);
                requestor.acceptParameter(paramName, paramType, paramKind, value);
                break;
            }
            case 'b': {
                break;
            }
            case 'c': {
                String name = sf.getName();
                String information = sf.getTypeInformation();
                this.parseStabConstant(requestor, name, information, value);
                break;
            }
            case 'C': {
                String excName = sf.getName();
                String information = sf.getTypeInformation();
                DebugType excType = this.parseStabType("", information);
                requestor.acceptCaughtException(excName, excType, value);
                break;
            }
            case 'F': 
            case 'f': {
                String funcName = sf.getName();
                String funcInfo = sf.getTypeInformation();
                DebugType funcType = this.parseStabType("", funcInfo);
                boolean funcGlobal = sf.getSymbolDescriptor() == 'F';
                requestor.enterFunction(funcName, funcType, funcGlobal, value);
                break;
            }
            case 'G': {
                String varName = sf.getName();
                String varInfo = sf.getTypeInformation();
                DebugVariableKind varKind = DebugVariableKind.GLOBAL;
                DebugType varType = this.parseStabType("", varInfo);
                requestor.acceptVariable(varName, varType, varKind, value);
                break;
            }
            case 'i': {
                break;
            }
            case 'I': {
                break;
            }
            case 'J': {
                break;
            }
            case 'L': {
                break;
            }
            case 'm': {
                break;
            }
            case 'p': {
                String paramName = sf.getName();
                String paramInfo = sf.getTypeInformation();
                DebugParameterKind paramKind = DebugParameterKind.STACK;
                DebugType paramType = this.parseStabType("", paramInfo);
                requestor.acceptParameter(paramName, paramType, paramKind, value);
                break;
            }
            case 'D': 
            case 'P': 
            case 'R': {
                String paramName = sf.getName();
                String paramInfo = sf.getTypeInformation();
                DebugParameterKind paramKind = DebugParameterKind.REGISTER;
                DebugType paramType = this.parseStabType("", paramInfo);
                requestor.acceptParameter(paramName, paramType, paramKind, value);
                break;
            }
            case 'Q': {
                break;
            }
            case 'd': 
            case 'r': {
                String varName = sf.getName();
                String varInfo = sf.getTypeInformation();
                DebugVariableKind varKind = DebugVariableKind.REGISTER;
                DebugType varType = this.parseStabType("", varInfo);
                requestor.acceptVariable(varName, varType, varKind, value);
                break;
            }
            case 'S': {
                String varName = sf.getName();
                String varInfo = sf.getTypeInformation();
                DebugVariableKind varKind = DebugVariableKind.STATIC;
                DebugType varType = this.parseStabType("", varInfo);
                requestor.acceptVariable(varName, varType, varKind, value);
                break;
            }
            case 't': {
                String name = sf.getName();
                String infoField = sf.getTypeInformation();
                DebugType type = this.parseStabType(name, infoField);
                requestor.acceptTypeDef(name, type);
                break;
            }
            case 'T': {
                String infoField = sf.getTypeInformation();
                if (infoField.length() > 0 && infoField.charAt(0) == 't') {
                    String s = field.replaceFirst(":T", ":");
                    this.parseStabString(requestor, s, value);
                    break;
                }
                String name = sf.getName();
                this.parseStabType(name, infoField);
                break;
            }
            case 'v': {
                String paramName = sf.getName();
                String paramInfo = sf.getTypeInformation();
                DebugParameterKind paramKind = DebugParameterKind.REFERENCE;
                DebugType paramType = this.parseStabType("", paramInfo);
                requestor.acceptParameter(paramName, paramType, paramKind, value);
                break;
            }
            case 'V': {
                String varName = sf.getName();
                String varInfo = sf.getTypeInformation();
                DebugVariableKind varKind = DebugVariableKind.LOCAL_STATIC;
                DebugType varType = this.parseStabType("", varInfo);
                requestor.acceptVariable(varName, varType, varKind, value);
                break;
            }
            case 'x': {
                break;
            }
            default: {
                String varName = sf.getName();
                String varInfo = sf.getTypeInformation();
                DebugVariableKind varKind = DebugVariableKind.LOCAL;
                DebugType varType = this.parseStabType("", varInfo);
                requestor.acceptVariable(varName, varType, varKind, value);
            }
        }
    }

    DebugType parseStabType(String name, String typeInformation) {
        try {
            StringReader reader = new StringReader(typeInformation);
            return this.parseStabType(name, reader);
        }
        catch (IOException iOException) {
            return new DebugUnknownType(name);
        }
    }

    DebugType parseStabType(String name, Reader reader) throws IOException {
        return this.parseStabType(name, null, reader);
    }

    DebugType parseStabType(String name, TypeInformation oldType, Reader reader) throws IOException {
        TypeInformation typeInfo = new TypeInformation(reader);
        DebugType type = null;
        switch (typeInfo.getTypeDescriptor()) {
            case '#': {
                break;
            }
            case '&': {
                DebugType subType = this.parseStabType("", reader);
                type = new DebugReferenceType(subType);
                break;
            }
            case '@': {
                break;
            }
            case '*': {
                DebugType subType = this.parseStabType("", reader);
                type = new DebugPointerType(subType);
                break;
            }
            case 'R': 
            case 'b': 
            case 'c': 
            case 'g': 
            case 'w': {
                char desc = typeInfo.getTypeDescriptor();
                type = this.parseStabBuiltinType(name, desc, reader);
                break;
            }
            case 'A': 
            case 'a': {
                type = this.parseStabArrayType(name, reader);
                break;
            }
            case 'B': {
                break;
            }
            case 'C': {
                break;
            }
            case 'd': {
                break;
            }
            case 'D': {
                break;
            }
            case 'e': {
                type = this.parseStabEnumType(name, reader);
                break;
            }
            case 'E': {
                break;
            }
            case 'f': {
                DebugType subType = this.parseStabType("", reader);
                type = new DebugFunctionType(subType);
                break;
            }
            case 'F': {
                break;
            }
            case 'G': {
                break;
            }
            case 'i': {
                break;
            }
            case 'k': {
                break;
            }
            case 'K': {
                break;
            }
            case 'M': {
                break;
            }
            case 'n': {
                break;
            }
            case 'N': {
                break;
            }
            case 'o': {
                break;
            }
            case 'p': {
                break;
            }
            case 'P': {
                break;
            }
            case 'r': {
                type = this.parseStabRangeType(name, typeInfo.getTypeNumber(), reader);
                break;
            }
            case 's': {
                type = this.parseStabStructType(name, typeInfo.getTypeNumber(), false, reader);
                break;
            }
            case 'u': {
                type = this.parseStabStructType(name, typeInfo.getTypeNumber(), true, reader);
                break;
            }
            case 'S': {
                break;
            }
            case 'v': {
                break;
            }
            case 'x': {
                type = this.parseStabCrossRefType(name, reader);
                break;
            }
            case 'Y': {
                break;
            }
            case 'z': {
                break;
            }
            default: {
                type = typeInfo.isTypeDefinition() ? this.parseStabType(name, typeInfo, reader) : (oldType != null && oldType.getTypeNumber().equals(typeInfo.getTypeNumber()) ? this.voidType : this.getDebugType(typeInfo.getTypeNumber()));
            }
        }
        if (type != null && typeInfo.isTypeDefinition()) {
            this.mapTypes.put(typeInfo.getTypeNumber(), type);
        }
        if (type == null) {
            type = new DebugUnknownType(name);
        }
        return type;
    }

    DebugType parseStabCrossRefType(String name, Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = reader.read();
        if (c == 115) {
            sb.append("struct ");
        } else if (c == 117) {
            sb.append("union ");
        } else if (c == 101) {
            sb.append("enum ");
        } else {
            sb.append((char)c);
        }
        while ((c = reader.read()) != -1) {
            if (c == 58) break;
            sb.append((char)c);
        }
        return new DebugCrossRefType(null, name, sb.toString());
    }

    private DebugType parseStabBuiltinType(String name, char desc, Reader reader) throws IOException {
        DebugBaseType builtinType = null;
        switch (desc) {
            case 'b': {
                int c;
                int signed = reader.read();
                reader.mark(1);
                int charFlag = reader.read();
                if (charFlag != 99) {
                    reader.reset();
                }
                StringBuilder sb = new StringBuilder();
                while ((c = reader.read()) != -1) {
                    if (c == 59) break;
                    sb.append((char)c);
                }
                sb.setLength(0);
                while ((c = reader.read()) != -1) {
                    if (c == 59) break;
                    sb.append((char)c);
                }
                sb.setLength(0);
                int nbits = 0;
                while ((c = reader.read()) != -1) {
                    if (c == 59) break;
                    sb.append((char)c);
                }
                try {
                    String token = sb.toString();
                    nbits = Integer.parseInt(token);
                }
                catch (NumberFormatException numberFormatException) {}
                builtinType = new DebugBaseType(name, nbits / 8, signed == 117);
                break;
            }
            case 'w': {
                builtinType = new DebugBaseType(name, 8, false);
                break;
            }
            case 'R': {
                int c;
                StringBuilder sb = new StringBuilder();
                while ((c = reader.read()) != -1) {
                    if (c == 59) break;
                    sb.append((char)c);
                }
                sb.setLength(0);
                int bytes = 0;
                while ((c = reader.read()) != -1) {
                    if (c == 59) break;
                    sb.append((char)c);
                }
                try {
                    String token = sb.toString();
                    bytes = Integer.parseInt(token);
                }
                catch (NumberFormatException numberFormatException) {}
                builtinType = new DebugBaseType(name, bytes, false);
                break;
            }
            case 'c': 
            case 'g': {
                this.parseStabType(name, reader);
                int c = reader.read();
                StringBuilder sb = new StringBuilder();
                int nbits = 0;
                while ((c = reader.read()) != -1) {
                    sb.append((char)c);
                }
                try {
                    String token = sb.toString();
                    nbits = Integer.parseInt(token);
                }
                catch (NumberFormatException numberFormatException) {}
                builtinType = new DebugBaseType(name, nbits / 8, false);
            }
        }
        return builtinType;
    }

    DebugType parseStabArrayType(String name, Reader reader) throws IOException {
        int c = reader.read();
        if (c == 114) {
            this.parseStabType("", reader);
            c = reader.read();
            if (c != 59) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            while ((c = reader.read()) != -1) {
                if (c == 59) break;
                sb.append((char)c);
            }
            if (c != 59) {
                return null;
            }
            int lower = 0;
            try {
                String token = sb.toString();
                lower = Integer.parseInt(token);
            }
            catch (NumberFormatException numberFormatException) {}
            sb.setLength(0);
            while ((c = reader.read()) != -1) {
                if (c == 59) break;
                sb.append((char)c);
            }
            if (c != 59) {
                return null;
            }
            int upper = 0;
            try {
                String token = sb.toString();
                upper = Integer.parseInt(token);
            }
            catch (NumberFormatException numberFormatException) {}
            if (c != 59) {
                return null;
            }
            DebugType subType = this.parseStabType("", reader);
            return new DebugArrayType(subType, upper - lower + 1);
        }
        return new DebugArrayType(new DebugUnknownType(name), 0);
    }

    DebugType parseStabEnumType(String name, Reader reader) throws IOException {
        int c;
        ArrayList<DebugEnumField> list = new ArrayList<DebugEnumField>();
        String fieldName = null;
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (c == 58) {
                fieldName = sb.toString();
                sb.setLength(0);
                continue;
            }
            if (c == 44) {
                if (fieldName != null && fieldName.length() > 0) {
                    String value = sb.toString();
                    int fieldValue = 0;
                    try {
                        fieldValue = Integer.decode(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    list.add(new DebugEnumField(fieldName, fieldValue));
                }
                fieldName = null;
                sb.setLength(0);
                continue;
            }
            if (c == 59) break;
            sb.append((char)c);
        }
        DebugEnumField[] fields = new DebugEnumField[list.size()];
        list.toArray(fields);
        return new DebugEnumType(name, fields);
    }

    DebugType parseStabStructType(String name, TypeNumber typeNumber, boolean union, Reader reader) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (!Character.isDigit((char)c)) {
                reader.reset();
                break;
            }
            reader.mark(1);
            sb.append((char)c);
        }
        String number = sb.toString();
        int size = 0;
        try {
            size = Integer.decode(number);
        }
        catch (NumberFormatException numberFormatException) {}
        DebugStructType structType = new DebugStructType(name, size, union);
        this.mapTypes.put(typeNumber, structType);
        this.parseStabStructField(structType, reader);
        return structType;
    }

    void parseStabStructField(DebugStructType structType, Reader reader) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (c == 58) break;
            sb.append((char)c);
        }
        if (c != 58) {
            return;
        }
        String name = sb.toString();
        DebugType fieldType = this.parseStabType("", reader);
        c = reader.read();
        if (c != 44) {
            return;
        }
        sb.setLength(0);
        while ((c = reader.read()) != -1 && c != 44) {
            sb.append((char)c);
        }
        if (c != 44) {
            return;
        }
        int offset = 0;
        try {
            offset = Integer.decode(sb.toString());
        }
        catch (NumberFormatException numberFormatException) {}
        sb.setLength(0);
        while ((c = reader.read()) != -1 && c != 59) {
            sb.append((char)c);
        }
        if (c != 59) {
            return;
        }
        int bits = 0;
        try {
            bits = Integer.decode(sb.toString());
        }
        catch (NumberFormatException numberFormatException) {}
        structType.addField(new DebugField(name, fieldType, offset, bits));
        this.parseStabStructField(structType, reader);
    }

    DebugType parseStabRangeType(String name, TypeNumber number, Reader reader) throws IOException {
        DebugBaseType rangeType = null;
        TypeNumber typeNumber = new TypeNumber(reader);
        int c = reader.read();
        if (c != 59) {
            return new DebugUnknownType(name);
        }
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (c == 59) break;
            sb.append((char)c);
        }
        if (c != 59) {
            return new DebugUnknownType(name);
        }
        boolean overflowLowerBound = false;
        String lowerBoundString = sb.toString();
        long lowerBound = 0L;
        try {
            lowerBound = Long.decode(lowerBoundString);
        }
        catch (NumberFormatException numberFormatException) {
            overflowLowerBound = true;
        }
        sb.setLength(0);
        while ((c = reader.read()) != -1) {
            if (c == 59) break;
            sb.append((char)c);
        }
        if (c != 59) {
            return new DebugUnknownType(name);
        }
        boolean overflowUpperBound = false;
        long upperBound = 0L;
        String upperBoundString = sb.toString();
        try {
            upperBound = Long.decode(upperBoundString);
        }
        catch (NumberFormatException numberFormatException) {
            overflowUpperBound = true;
        }
        boolean self = typeNumber.equals(number);
        if (overflowLowerBound || overflowUpperBound) {
            if (lowerBoundString.equals(LLLOW) && upperBoundString.equals(LLHIGH)) {
                rangeType = new DebugBaseType(name, 8, false);
            }
            if (!overflowLowerBound && lowerBound == 0L && upperBoundString.equals(ULLHIGH)) {
                rangeType = new DebugBaseType(name, 8, true);
            }
        } else if (lowerBound == 0L && upperBound == -1L) {
            rangeType = name.equals("long long int") ? new DebugBaseType(name, 8, true) : (name.equals("long long unsigned int") ? new DebugBaseType(name, 8, true) : new DebugBaseType(name, 4, true));
        } else if (upperBound == 0L && lowerBound > 0L) {
            rangeType = new DebugBaseType(name, (int)lowerBound, true);
        } else if (lowerBound == -128L && upperBound == 127L) {
            rangeType = new DebugBaseType(name, 1, false);
        } else if (self && lowerBound == 0L && upperBound == 127L) {
            rangeType = new DebugBaseType(name, 1, false);
        } else if (self && lowerBound == 0L && upperBound == 255L) {
            rangeType = new DebugBaseType(name, 1, true);
        } else if (lowerBound == -32768L && upperBound == 32767L) {
            rangeType = new DebugBaseType(name, 2, false);
        } else if (self && lowerBound == 0L && upperBound == 65535L) {
            rangeType = new DebugBaseType(name, 2, true);
        } else if (lowerBound == Integer.MIN_VALUE && upperBound == Integer.MAX_VALUE) {
            rangeType = new DebugBaseType(name, 4, false);
        }
        return rangeType;
    }

    void parseStabConstant(IDebugEntryRequestor requestor, String name, String field, long value) {
        try {
            this.parseStabConstant(requestor, name, new StringReader(field), value);
        }
        catch (IOException iOException) {}
    }

    void parseStabConstant(IDebugEntryRequestor requestor, String name, Reader reader, long value) throws IOException {
        block20: {
            int c = reader.read();
            if (c != 61) break block20;
            c = reader.read();
            switch (c) {
                case 98: {
                    break;
                }
                case 99: {
                    break;
                }
                case 101: {
                    int val = 0;
                    DebugType type = this.parseStabType("", reader);
                    c = reader.read();
                    if (c == 44) {
                        StringBuilder sb = new StringBuilder();
                        while ((c = reader.read()) != -1) {
                            sb.append((char)c);
                        }
                        try {
                            String s = sb.toString();
                            val = Integer.decode(s);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    requestor.acceptTypeConst(name, type, val);
                    break;
                }
                case 105: {
                    int val = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((c = reader.read()) != -1) {
                        sb.append((char)c);
                    }
                    try {
                        String s = sb.toString();
                        val = Integer.decode(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    requestor.acceptIntegerConst(name, val);
                    break;
                }
                case 114: {
                    double val = 0.0;
                    StringBuilder sb = new StringBuilder();
                    while ((c = reader.read()) != -1) {
                        sb.append((char)c);
                    }
                    try {
                        String s = sb.toString();
                        val = s.equals("-INF") ? Double.NEGATIVE_INFINITY : (s.equals("INF") ? Double.POSITIVE_INFINITY : (s.equals("QNAN") ? Double.NaN : (s.equals("SNAN") ? Double.NaN : Double.parseDouble(s))));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    requestor.acceptFloatConst(name, val);
                    break;
                }
                case 115: {
                    break;
                }
            }
        }
    }

    DebugType getDebugType(TypeNumber tn) {
        return this.mapTypes.get(tn);
    }

    public static void main(String[] args) {
        try {
            DebugSym[] entries;
            DebugSymsRequestor symreq = new DebugSymsRequestor();
            Stabs stabs = new Stabs(args[0]);
            stabs.parse(symreq);
            DebugSym[] debugSymArray = entries = symreq.getEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                DebugSym entry = debugSymArray[n2];
                System.out.println(entry);
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

