/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter.scanner;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.eclipse.cdt.internal.formatter.scanner.ScannerContext;
import org.eclipse.cdt.internal.formatter.scanner.Token;

public class SimpleScanner {
    private static final int EOFCHAR = -1;
    protected static HashMap<String, Integer> fgKeywords = new HashMap();
    protected Token fCurrentToken;
    protected ScannerContext fContext;
    protected StringBuilder fTokenBuffer = new StringBuilder();
    private int fPreprocessorToken = 0;
    private boolean fReuseToken;
    private boolean fSplitPreprocessor;
    private final StringBuilder fUniversalCharBuffer = new StringBuilder();

    static {
        fgKeywords.put("and", 54);
        fgKeywords.put("and_eq", 55);
        fgKeywords.put("asm", 56);
        fgKeywords.put("auto", 57);
        fgKeywords.put("bitand", 58);
        fgKeywords.put("bitor", 59);
        fgKeywords.put("bool", 60);
        fgKeywords.put("break", 61);
        fgKeywords.put("case", 62);
        fgKeywords.put("catch", 63);
        fgKeywords.put("char", 64);
        fgKeywords.put("class", 65);
        fgKeywords.put("compl", 66);
        fgKeywords.put("const", 67);
        fgKeywords.put("const_cast", 69);
        fgKeywords.put("continue", 70);
        fgKeywords.put("default", 71);
        fgKeywords.put("delete", 72);
        fgKeywords.put("do", 73);
        fgKeywords.put("double", 74);
        fgKeywords.put("dynamic_cast", 75);
        fgKeywords.put("else", 76);
        fgKeywords.put("enum", 77);
        fgKeywords.put("explicit", 78);
        fgKeywords.put("export", 79);
        fgKeywords.put("extern", 80);
        fgKeywords.put("false", 81);
        fgKeywords.put("float", 82);
        fgKeywords.put("for", 83);
        fgKeywords.put("friend", 84);
        fgKeywords.put("goto", 85);
        fgKeywords.put("if", 86);
        fgKeywords.put("inline", 87);
        fgKeywords.put("int", 88);
        fgKeywords.put("long", 89);
        fgKeywords.put("mutable", 90);
        fgKeywords.put("namespace", 91);
        fgKeywords.put("new", 92);
        fgKeywords.put("not", 93);
        fgKeywords.put("not_eq", 94);
        fgKeywords.put("operator", 95);
        fgKeywords.put("or", 96);
        fgKeywords.put("or_eq", 97);
        fgKeywords.put("private", 98);
        fgKeywords.put("protected", 99);
        fgKeywords.put("public", 100);
        fgKeywords.put("register", 101);
        fgKeywords.put("reinterpret_cast", 102);
        fgKeywords.put("return", 103);
        fgKeywords.put("short", 104);
        fgKeywords.put("signed", 108);
        fgKeywords.put("sizeof", 105);
        fgKeywords.put("static", 106);
        fgKeywords.put("static_cast", 107);
        fgKeywords.put("struct", 109);
        fgKeywords.put("switch", 110);
        fgKeywords.put("template", 111);
        fgKeywords.put("this", 112);
        fgKeywords.put("throw", 113);
        fgKeywords.put("true", 114);
        fgKeywords.put("try", 115);
        fgKeywords.put("typedef", 116);
        fgKeywords.put("typeid", 117);
        fgKeywords.put("typename", 118);
        fgKeywords.put("union", 119);
        fgKeywords.put("unsigned", 120);
        fgKeywords.put("using", 121);
        fgKeywords.put("virtual", 122);
        fgKeywords.put("void", 123);
        fgKeywords.put("volatile", 124);
        fgKeywords.put("wchar_t", 125);
        fgKeywords.put("while", 126);
        fgKeywords.put("xor", 127);
        fgKeywords.put("xor_eq", 128);
        fgKeywords.put("abstract", 209);
        fgKeywords.put("boolean", 208);
        fgKeywords.put("byte", 214);
        fgKeywords.put("extends", 203);
        fgKeywords.put("final", 205);
        fgKeywords.put("finally", 210);
        fgKeywords.put("implements", 204);
        fgKeywords.put("import", 201);
        fgKeywords.put("interface", 200);
        fgKeywords.put("instanceof", 202);
        fgKeywords.put("native", 216);
        fgKeywords.put("null", 211);
        fgKeywords.put("package", 207);
        fgKeywords.put("super", 206);
        fgKeywords.put("synchronized", 212);
        fgKeywords.put("throws", 213);
        fgKeywords.put("transient", 215);
    }

    public void setReuseToken(boolean val) {
        this.fReuseToken = val;
        if (val) {
            this.fCurrentToken = new Token(0, null);
        }
    }

    public void setSplitPreprocessor(boolean val) {
        this.fSplitPreprocessor = val;
    }

    protected void init(Reader reader, String filename) {
        this.fReuseToken = false;
        this.fSplitPreprocessor = true;
        this.fPreprocessorToken = 0;
        this.fContext = new ScannerContext().initialize(reader);
    }

    public SimpleScanner initialize(Reader reader, String filename) {
        this.init(reader, filename);
        return this;
    }

    public void cleanup() {
        this.fContext = null;
        this.fTokenBuffer = new StringBuilder();
        this.fCurrentToken = null;
    }

    private final void setCurrentToken(Token t) {
        this.fCurrentToken = t;
    }

    private final Token newToken(int t) {
        if (!this.fReuseToken) {
            this.setCurrentToken(new Token(t, this.fTokenBuffer.toString(), this.fContext));
        } else {
            this.fCurrentToken.set(t, this.fTokenBuffer.toString(), this.fContext);
        }
        return this.fCurrentToken;
    }

    private Token newPreprocessorToken() {
        if (this.fPreprocessorToken == 0) {
            this.fPreprocessorToken = this.categorizePreprocessor(this.fTokenBuffer);
        }
        return this.newToken(this.fPreprocessorToken);
    }

    private int categorizePreprocessor(StringBuilder text) {
        boolean skipHash = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (!skipHash) break;
                skipHash = false;
                if (c != '#') break;
            }
            ++i;
        }
        String innerText = text.substring(i);
        if (innerText.startsWith("include")) {
            return 1004;
        }
        if (innerText.startsWith("define")) {
            return 1005;
        }
        if (innerText.startsWith("undef")) {
            return 1005;
        }
        return 1003;
    }

    protected final int getChar() {
        return this.getChar(false);
    }

    private int getChar(boolean insideString) {
        int c = -1;
        if (this.fContext.undoStackSize() != 0) {
            c = this.fContext.popUndo();
        } else {
            try {
                c = this.fContext.read();
            }
            catch (IOException iOException) {
                c = -1;
            }
        }
        this.fTokenBuffer.append((char)c);
        if (!insideString && c == 92) {
            c = this.getChar(false);
            if (c == 13) {
                c = this.getChar(false);
                if (c == 10) {
                    c = this.getChar(false);
                }
            } else if (c == 10) {
                c = this.getChar(false);
            } else if (c == 85 || c == 117) {
                this.fUniversalCharBuffer.setLength(0);
                this.fUniversalCharBuffer.append('\\').append((char)c);
                c = this.getUniversalCharacter();
            } else {
                this.ungetChar(c);
                c = 92;
            }
        }
        return c;
    }

    private int getUniversalCharacter() {
        int unicode = 0;
        while (true) {
            int digit;
            int c = this.getChar(true);
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    digit = c - 48;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    digit = c - 97 + 10;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    digit = c - 65 + 10;
                    break;
                }
                default: {
                    this.internalUngetChar(c);
                    return unicode;
                }
            }
            this.fUniversalCharBuffer.append((char)c);
            unicode <<= 4;
            unicode += digit;
        }
    }

    private void internalUngetChar(int c) {
        this.fTokenBuffer.deleteCharAt(this.fTokenBuffer.length() - 1);
        this.fContext.pushUndo(c);
    }

    protected void ungetChar(int c) {
        if (c < 256 || c == this.fTokenBuffer.charAt(this.fTokenBuffer.length() - 1)) {
            this.internalUngetChar(c);
        } else if (this.fUniversalCharBuffer.length() > 0) {
            char[] chs = this.fUniversalCharBuffer.toString().toCharArray();
            int i = chs.length - 1;
            while (i >= 0) {
                this.internalUngetChar(chs[i]);
                --i;
            }
        } else {
            this.internalUngetChar(c);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Token nextToken() {
        this.fTokenBuffer.setLength(0);
        madeMistake = false;
        c = this.getChar();
        while (c != -1) {
            block123: {
                if (this.fPreprocessorToken != 0 && (token = this.continuePPDirective(c)) != null) {
                    return token;
                }
                if (c == 32 || c == 13 || c == 9 || c == 10) {
                    while ((c = this.getChar()) == 32 || c == 13 || c == 9 || c == 10) {
                    }
                    this.ungetChar(c);
                    return this.newToken(1000);
                }
                if (c == 34) {
                    this.matchStringLiteral();
                    return this.newToken(129);
                }
                if (c == 76 && !madeMistake) {
                    oldChar = c;
                    c = this.getChar();
                    if (c != 34) {
                        this.ungetChar(c);
                        c = oldChar;
                        madeMistake = true;
                        continue;
                    }
                    this.matchStringLiteral();
                    return this.newToken(131);
                }
                if (c == 82 && !madeMistake) {
                    oldChar = c;
                    c = this.getChar();
                    if (c != 34) {
                        this.ungetChar(c);
                        c = oldChar;
                        madeMistake = true;
                        continue;
                    }
                    this.matchRawStringLiteral();
                    return this.newToken(133);
                }
                if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c > 255 && Character.isUnicodeIdentifierStart(c)) {
                    madeMistake = false;
                    c = this.getChar();
                    while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c > 255 && Character.isUnicodeIdentifierPart(c)) {
                        c = this.getChar();
                    }
                    this.ungetChar(c);
                    ident = this.fTokenBuffer.toString();
                    tokenTypeObject = SimpleScanner.fgKeywords.get(ident);
                    tokenType = 1;
                    if (tokenTypeObject != null) {
                        tokenType = tokenTypeObject;
                    }
                    return this.newToken(tokenType);
                }
                if ((c < 48 || c > 57) && c != 46) break block123;
                hex = false;
                floatingPoint = c == 46;
                firstCharZero = c == 48;
                c = this.getChar();
                if (firstCharZero && c == 120) {
                    hex = true;
                    c = this.getChar();
                }
                digits = 0;
                while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                    ++digits;
                    c = this.getChar();
                }
                if (!hex) {
                    if (c == 42) {
                        if (floatingPoint && digits == 0) {
                            return this.newToken(49);
                        }
                    } else if (c == 46) {
                        if (floatingPoint && digits == 0) {
                            c = this.getChar();
                            if (c == 46) {
                                return this.newToken(48);
                            }
                            this.ungetChar(c);
                            this.ungetChar(46);
                            return this.newToken(50);
                        }
                        floatingPoint = true;
                        c = this.getChar();
                        while (c >= 48 && c <= 57) {
                            ++digits;
                            c = this.getChar();
                        }
                    } else if (digits > 0 && (c == 101 || c == 69)) {
                        floatingPoint = true;
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            c = this.getChar();
                        }
                        while (c >= 48 && c <= 57) {
                            c = this.getChar();
                        }
                    }
                }
                if (!floatingPoint) ** GOTO lbl96
                if (digits > 0) {
                    if (c == 108 || c == 76 || c == 102 || c == 70) {
                        c = this.getChar();
                    }
                } else {
                    this.ungetChar(c);
                    return this.newToken(50);
lbl96:
                    // 1 sources

                    if (c == 117 || c == 85) {
                        c = this.getChar();
                        if (c == 108 || c == 76) {
                            c = this.getChar();
                        }
                    } else if (!(c != 108 && c != 76 || (c = this.getChar()) != 117 && c != 85)) {
                        c = this.getChar();
                    }
                }
                this.ungetChar(c);
                result = this.fTokenBuffer.toString();
                tokenType = floatingPoint != false && result.equals(".") != false ? 50 : (floatingPoint != false ? 130 : 2);
                return this.newToken(tokenType);
            }
            if (c == 35) {
                return this.matchPPDirective();
            }
            block0 : switch (c) {
                case 39: {
                    this.matchCharLiteral();
                    return this.newToken(132);
                }
                case 58: {
                    c = this.getChar();
                    if (c == 58) {
                        return this.newToken(3);
                    }
                    this.ungetChar(c);
                    return this.newToken(4);
                }
                case 59: {
                    return this.newToken(5);
                }
                case 44: {
                    return this.newToken(6);
                }
                case 63: {
                    return this.newToken(7);
                }
                case 40: {
                    return this.newToken(8);
                }
                case 41: {
                    return this.newToken(9);
                }
                case 91: {
                    return this.newToken(10);
                }
                case 93: {
                    return this.newToken(11);
                }
                case 123: {
                    return this.newToken(12);
                }
                case 125: {
                    return this.newToken(13);
                }
                case 43: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(14);
                        }
                        case 43: {
                            return this.newToken(15);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(16);
                }
                case 45: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(17);
                        }
                        case 45: {
                            return this.newToken(18);
                        }
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 42: {
                                    return this.newToken(19);
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(20);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(21);
                }
                case 42: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(22);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(23);
                }
                case 37: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(24);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(25);
                }
                case 94: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(26);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(27);
                }
                case 38: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(28);
                        }
                        case 38: {
                            return this.newToken(29);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(30);
                }
                case 124: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(31);
                        }
                        case 124: {
                            return this.newToken(32);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(33);
                }
                case 126: {
                    return this.newToken(34);
                }
                case 33: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(35);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(36);
                }
                case 61: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(37);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(38);
                }
                case 60: {
                    c = this.getChar();
                    switch (c) {
                        case 60: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(47);
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(40);
                        }
                        case 61: {
                            return this.newToken(41);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(42);
                }
                case 62: {
                    c = this.getChar();
                    switch (c) {
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(43);
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(44);
                        }
                        case 61: {
                            return this.newToken(45);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(46);
                }
                case 46: {
                    c = this.getChar();
                    switch (c) {
                        case 46: {
                            c = this.getChar();
                            switch (c) {
                                case 46: {
                                    return this.newToken(48);
                                }
                            }
                            break block0;
                        }
                        case 42: {
                            return this.newToken(49);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(50);
                }
                case 47: {
                    c = this.getChar();
                    switch (c) {
                        case 47: {
                            this.matchSinglelineComment(true);
                            return this.newToken(1001);
                        }
                        case 42: {
                            this.matchMultilineComment();
                            return this.newToken(1002);
                        }
                        case 61: {
                            return this.newToken(51);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(52);
                }
                default: {
                    return this.newToken(1006);
                }
            }
        }
        return null;
    }

    private void matchCharLiteral() {
        int c = this.getChar(true);
        int next = this.getChar(true);
        if (c == 92) {
            if (next >= 48 && next <= 55) {
                while ((next = this.getChar(true)) >= 48 && next <= 55) {
                }
            } else if (next == 120 || next == 88 || next == 117 || next == 85) {
                while ((next = this.getChar(true)) >= 48 && next <= 57 || next >= 97 && next <= 102 || next >= 65 && next <= 70) {
                }
            } else {
                next = this.getChar(true);
            }
        }
        if (next != 39) {
            this.ungetChar(next);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void matchStringLiteral() {
        boolean escaped = false;
        int c = this.getChar(true);
        while (c != -1) {
            if (escaped) {
                escaped = false;
                int nc = this.getChar(true);
                if (c == 13 && nc == 10) {
                    nc = this.getChar(true);
                }
                c = nc;
                continue;
            }
            switch (c) {
                case 92: {
                    escaped = true;
                    break;
                }
                case 34: {
                    return;
                }
                case 10: 
                case 13: {
                    this.ungetChar(c);
                    return;
                }
            }
            c = this.getChar(true);
        }
        return;
    }

    private void matchRawStringLiteral() {
        int c = this.getChar(false);
        StringBuilder delim = new StringBuilder(12);
        while (c != 40) {
            if (c == -1) {
                return;
            }
            delim.append((char)c);
            c = this.getChar(false);
        }
        int delimLen = delim.length();
        c = this.getChar(false);
        block1: while (c != -1) {
            if (c == 41) {
                c = this.getChar(false);
                int idx = 0;
                while (idx < delimLen) {
                    if (c != delim.charAt(idx)) continue block1;
                    ++idx;
                    c = this.getChar(false);
                }
                if (c == 34) break;
            }
            c = this.getChar(false);
        }
    }

    private Token matchPPDirective() {
        if (!this.fSplitPreprocessor) {
            this.getRestOfPreprocessorLine();
            return this.newToken(1003);
        }
        return this.continuePPDirective(this.getChar());
    }

    private Token continuePPDirective(int c) {
        boolean done = false;
        while (!done) {
            switch (c) {
                case 39: {
                    if (this.fTokenBuffer.length() > 1) {
                        if (this.fPreprocessorToken == 0) {
                            this.fPreprocessorToken = this.categorizePreprocessor(this.fTokenBuffer);
                        }
                        this.ungetChar(c);
                        return this.newPreprocessorToken();
                    }
                    this.matchCharLiteral();
                    return this.newToken(132);
                }
                case 34: {
                    if (this.fTokenBuffer.length() > 1) {
                        if (this.fPreprocessorToken == 0) {
                            this.fPreprocessorToken = this.categorizePreprocessor(this.fTokenBuffer);
                        }
                        if (this.fPreprocessorToken == 1004) {
                            this.matchStringLiteral();
                            c = this.getChar();
                            break;
                        }
                        this.ungetChar(c);
                        return this.newPreprocessorToken();
                    }
                    this.matchStringLiteral();
                    return this.newToken(129);
                }
                case 47: {
                    int next = this.getChar();
                    if (next == 47) {
                        Token result = null;
                        if (this.fTokenBuffer.length() > 2) {
                            this.ungetChar(next);
                            this.ungetChar(c);
                            result = this.newPreprocessorToken();
                        } else {
                            this.matchSinglelineComment(false);
                            result = this.newToken(1001);
                        }
                        this.fPreprocessorToken = 0;
                        return result;
                    }
                    if (next == 42) {
                        if (this.fTokenBuffer.length() > 2) {
                            this.ungetChar(next);
                            this.ungetChar(c);
                            return this.newPreprocessorToken();
                        }
                        if (this.matchMultilineComment()) {
                            this.fPreprocessorToken = 0;
                        }
                        return this.newToken(1002);
                    }
                    c = next;
                    break;
                }
                case -1: 
                case 10: 
                case 13: {
                    done = true;
                    break;
                }
                default: {
                    c = this.getChar();
                }
            }
        }
        this.ungetChar(c);
        Token result = null;
        if (this.fTokenBuffer.length() > 0) {
            result = this.newPreprocessorToken();
        }
        this.fPreprocessorToken = 0;
        return result;
    }

    private void getRestOfPreprocessorLine() {
        block6: {
            int c = this.getChar();
            while (true) {
                if (c != 10 && c != 13 && c != 47 && c != 34 && c != -1) {
                    c = this.getChar();
                    continue;
                }
                if (c == 47) {
                    int next = this.getChar();
                    if (next == 47) {
                        this.matchSinglelineComment(false);
                        break block6;
                    }
                    if (next == 42) {
                        if (!this.matchMultilineComment()) {
                            c = this.getChar();
                            continue;
                        }
                        break block6;
                    }
                    c = next;
                    continue;
                }
                if (c != 34) break;
                this.matchStringLiteral();
                c = this.getChar();
            }
            this.ungetChar(c);
        }
    }

    private void matchSinglelineComment(boolean includeNewline) {
        int c = this.getChar();
        while (c != 10 && c != -1) {
            int next = this.getChar();
            if (c == 13 && next == 10 && !includeNewline) {
                this.ungetChar(next);
                break;
            }
            c = next;
        }
        if (c == -1 || !includeNewline) {
            this.ungetChar(c);
        }
    }

    private boolean matchMultilineComment() {
        boolean encounteredNewline = false;
        int state = 0;
        int c = this.getChar();
        while (state != 2 && c != -1) {
            if (c == 10) {
                encounteredNewline = true;
            }
            switch (state) {
                case 0: {
                    if (c != 42) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    if (c == 42) break;
                    state = 0;
                }
            }
            c = this.getChar();
        }
        this.ungetChar(c);
        return encounteredNewline;
    }
}

