/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class PDOMRebuildTask
implements IPDOMIndexerTask {
    protected static final String TRUE = String.valueOf(true);
    protected static final ITranslationUnit[] NO_TUS = new ITranslationUnit[0];
    private final IPDOMIndexer fIndexer;
    private final IndexerProgress fProgress;
    private volatile IPDOMIndexerTask fDelegate;
    private IProgressMonitor fProgressMonitor;

    public PDOMRebuildTask(IPDOMIndexer indexer) {
        this.fIndexer = indexer;
        this.fProgress = this.createProgress();
    }

    private IndexerProgress createProgress() {
        IndexerProgress progress = new IndexerProgress();
        progress.fTimeEstimate = 1000;
        return progress;
    }

    @Override
    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InterruptedException {
        this.fProgressMonitor = monitor;
        try {
            monitor.subTask(NLS.bind((String)Messages.PDOMIndexerTask_collectingFilesTask, (Object)this.fIndexer.getProject().getElementName()));
            ICProject cproject = this.fIndexer.getProject();
            IProject project = cproject.getProject();
            if (project.isOpen() && project.exists()) {
                try {
                    IWritableIndex index = ((IWritableIndexManager)CCorePlugin.getIndexManager()).getWritableIndex(cproject);
                    if (index != null) {
                        this.clearIndex(cproject, index);
                        if (!"org.eclipse.cdt.core.nullindexer".equals(this.fIndexer.getID())) {
                            this.createDelegate(cproject, monitor);
                        }
                    }
                    TodoTaskUpdater.removeTasksFor((IResource)project);
                }
                catch (CoreException e) {
                    CCorePlugin.log(NLS.bind((String)Messages.PDOMRebuildTask_0, (Object)cproject.getElementName()), e);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.fDelegate != null) {
                this.fDelegate.run(monitor);
            }
        }
        finally {
            this.fProgressMonitor = null;
        }
    }

    private void clearIndex(ICProject project, IWritableIndex index) throws CoreException, InterruptedException {
        index.acquireWriteLock(this.fProgressMonitor);
        try {
            index.clear();
            IWritableIndexFragment wf = index.getWritableFragment();
            if (wf instanceof WritablePDOM) {
                PDOMManager.writeProjectPDOMProperties((WritablePDOM)wf, project.getProject());
            }
        }
        finally {
            index.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDelegate(ICProject project, IProgressMonitor monitor) throws CoreException {
        boolean allFiles = TRUE.equals(this.fIndexer.getProperty("indexUnusedHeadersWithDefaultLang")) || TRUE.equals(this.fIndexer.getProperty("indexUnusedHeadersWithAlternateLang"));
        ArrayList<ITranslationUnit> sources = new ArrayList<ITranslationUnit>();
        ArrayList<ITranslationUnit> headers = allFiles ? sources : null;
        TranslationUnitCollector collector = new TranslationUnitCollector(sources, headers, monitor);
        project.accept(collector);
        ITranslationUnit[] tus = sources.toArray(new ITranslationUnit[sources.size()]);
        IPDOMIndexerTask delegate = this.fIndexer.createTask(tus, NO_TUS, NO_TUS);
        if (delegate instanceof PDOMIndexerTask) {
            PDOMIndexerTask pdomIndexerTask = (PDOMIndexerTask)delegate;
            pdomIndexerTask.setUpdateFlags(1);
            pdomIndexerTask.setWriteInfoToLog();
        }
        PDOMRebuildTask pDOMRebuildTask = this;
        synchronized (pDOMRebuildTask) {
            this.fDelegate = delegate;
        }
    }

    @Override
    public synchronized IndexerProgress getProgressInformation() {
        return this.fDelegate != null ? this.fDelegate.getProgressInformation() : this.fProgress;
    }

    @Override
    public synchronized boolean acceptUrgentTask(IPDOMIndexerTask task) {
        return this.fDelegate != null && this.fDelegate.acceptUrgentTask(task);
    }

    @Override
    public void cancel() {
        if (this.fDelegate != null) {
            this.fDelegate.cancel();
        }
    }
}

