/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;

public final class FileExistsCache {
    private static final Content EMPTY_STRING_ARRAY = new Content(new String[0]);
    private static boolean BYPASS_CACHE = Boolean.getBoolean("CDT_INDEXER_BYPASS_FILE_EXISTS_CACHE");
    private Reference<Map<String, Content>> fCache;
    private final Map<String, Boolean> fCacheIsFile = new HashMap<String, Boolean>();
    private final boolean fCaseInSensitive;

    public FileExistsCache(boolean caseInsensitive) {
        this.fCaseInSensitive = caseInsensitive;
        HashMap cache = new HashMap();
        this.fCache = new SoftReference(cache);
    }

    public boolean isFile(String path) {
        Boolean cachedResult = this.fCacheIsFile.get(path);
        if (!BYPASS_CACHE && cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.isFileInternal(path);
        this.fCacheIsFile.put(path, result);
        return result;
    }

    private boolean isFileInternal(String path) {
        int idx;
        Content avail;
        String name;
        String parent;
        File file = null;
        IFileStore parentStore = null;
        IFileStore fileStore = null;
        if (UNCPathConverter.isUNC(path)) {
            try {
                URI uri = UNCPathConverter.getInstance().toURI(path);
                fileStore = EFS.getStore((URI)uri);
                if (BYPASS_CACHE) {
                    return fileStore != null && !fileStore.fetchInfo().isDirectory();
                }
                parentStore = fileStore.getParent();
                if (parentStore == null) {
                    parentStore = fileStore;
                }
                parent = parentStore.toURI().toString();
                name = fileStore.getName();
            }
            catch (CoreException coreException) {
                return false;
            }
        } else {
            file = new File(path);
            if (BYPASS_CACHE) {
                return file.isFile();
            }
            parent = file.getParent();
            if (parent == null) {
                return false;
            }
            name = file.getName();
        }
        if (this.fCaseInSensitive) {
            name = name.toUpperCase();
        }
        if ((avail = this.getExistsCache().get(parent)) == null) {
            Object[] files = null;
            try {
                files = parentStore == null ? new File(parent).list() : parentStore.childNames(0, null);
            }
            catch (CoreException coreException) {}
            if (files == null || files.length == 0) {
                avail = EMPTY_STRING_ARRAY;
            } else {
                if (this.fCaseInSensitive) {
                    int i = 0;
                    while (i < files.length) {
                        files[i] = ((String)files[i]).toUpperCase();
                        ++i;
                    }
                }
                Arrays.sort(files);
                avail = new Content((String[])files);
            }
            this.getExistsCache().put(parent, avail);
        }
        if ((idx = Arrays.binarySearch(avail.fNames, name)) < 0) {
            return false;
        }
        BitSet isFileBitset = avail.fIsFile;
        if (isFileBitset.get(idx *= 2)) {
            return true;
        }
        if (isFileBitset.get(idx + 1)) {
            return false;
        }
        if (file != null && file.isFile() || fileStore != null && !fileStore.fetchInfo().isDirectory()) {
            isFileBitset.set(idx);
            return true;
        }
        isFileBitset.set(idx + 1);
        return false;
    }

    private Map<String, Content> getExistsCache() {
        Map<String, Content> cache = this.fCache.get();
        if (cache == null) {
            cache = new HashMap<String, Content>();
            this.fCache = new SoftReference<Map<String, Content>>(cache);
        }
        return cache;
    }

    private static class Content {
        public String[] fNames;
        public BitSet fIsFile;

        public Content(String[] names) {
            this.fNames = names;
            this.fIsFile = new BitSet(names.length * 2);
        }
    }
}

