/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IInternalPDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMNode
implements IInternalPDOMNode {
    private static final int FACTORY_ID = 0;
    private static final int NODE_TYPE = 2;
    private static final int PARENT = 4;
    protected static final int RECORD_SIZE = 8;
    private final PDOMLinkage fLinkage;
    protected final long record;
    private volatile long cachedParentRecord;

    public static PDOMNode load(PDOM pdom, long record) throws CoreException {
        if (record == 0L) {
            return null;
        }
        Database db = pdom.getDB();
        short factoryId = db.getShort(record + 0L);
        short nodeType = db.getShort(record + 2L);
        if (nodeType == 0) {
            return null;
        }
        PDOMLinkage factory = pdom.getLinkage(factoryId);
        return factory == null ? null : factory.getNode(record, nodeType);
    }

    protected PDOMNode(PDOMLinkage linkage, long record) {
        this.fLinkage = linkage;
        this.record = record;
    }

    protected PDOMNode(PDOMLinkage linkage, PDOMNode parent) throws CoreException {
        this(linkage.getDB(), linkage, parent == null ? 0L : parent.getRecord());
    }

    protected PDOMNode(Database db) throws CoreException {
        this(db, null, 0L);
    }

    protected PDOMNode(Database db, PDOMLinkage linkage, long parentRec) throws CoreException {
        this.fLinkage = linkage;
        this.record = db.malloc(this.getRecordSize());
        short factoryId = (short)(linkage == null ? 0 : linkage.getLinkageID());
        db.putShort(this.record + 0L, factoryId);
        db.putShort(this.record + 2L, (short)this.getNodeType());
        this.cachedParentRecord = parentRec;
        db.putRecPtr(this.record + 4L, parentRec);
    }

    protected Database getDB() {
        return this.fLinkage.getDB();
    }

    public PDOM getPDOM() {
        return this.fLinkage.getPDOM();
    }

    public PDOMLinkage getLinkage() {
        return this.fLinkage;
    }

    protected abstract int getRecordSize();

    public abstract int getNodeType();

    @Override
    public final long getRecord() {
        return this.record;
    }

    public final long getBindingID() {
        return this.record;
    }

    public boolean isChildOf(PDOMNode other) {
        try {
            return other.fLinkage == this.fLinkage && other.record == this.getParentNodeRec();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PDOMNode) {
            PDOMNode other = (PDOMNode)obj;
            return this.getPDOM() == other.getPDOM() && this.record == other.record;
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return System.identityHashCode(this.getPDOM()) + (int)(41L * this.record);
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
    }

    public static int getNodeId(Database db, long record) throws CoreException {
        return PDOMNode.getNodeId(db.getShort(record + 0L), db.getShort(record + 2L));
    }

    public static int getNodeId(int linkageID, int nodeType) {
        return linkageID << 16 | nodeType & 0xFFFF;
    }

    public static int getNodeType(Database db, long record) throws CoreException {
        return db.getShort(record + 2L);
    }

    public long getParentNodeRec() throws CoreException {
        if (this.cachedParentRecord != 0L) {
            return this.cachedParentRecord;
        }
        this.cachedParentRecord = this.getDB().getRecPtr(this.record + 4L);
        return this.cachedParentRecord;
    }

    public PDOMNode getParentNode() throws CoreException {
        long parentrec = this.getParentNodeRec();
        return parentrec != 0L ? PDOMNode.load(this.getPDOM(), parentrec) : null;
    }

    public void addChild(PDOMNode child) throws CoreException {
    }

    protected byte getByte(long offset) {
        try {
            return this.getDB().getByte(offset);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    protected short getShort(long offset) {
        try {
            return this.getDB().getShort(offset);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    protected static boolean getBit(int bitVector, int offset) {
        int mask = 1 << offset;
        return (bitVector & mask) != 0;
    }

    @Override
    public void delete(PDOMLinkage linkage) throws CoreException {
        this.getDB().free(this.record);
    }
}

