/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableExecution;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.index.IIndexBindingConstants;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.MacroContainerFinder;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMGlobalScope;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.TypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class PDOMLinkage
extends PDOMNamedNode
implements IIndexLinkage,
IIndexBindingConstants {
    private static final int ID_OFFSET = 12;
    private static final int NEXT_OFFSET = 16;
    private static final int INDEX_OFFSET = 20;
    private static final int NESTED_BINDINGS_INDEX = 24;
    private static final int MACRO_BTREE = 28;
    protected static final int RECORD_SIZE = 32;
    protected static final long[] FILE_LOCAL_REC_DUMMY = new long[1];
    private BTree fMacroIndex = null;
    private final PDOM fPDOM;
    private final Database fDatabase;

    public PDOMLinkage(PDOM pdom, long record) {
        super(null, record);
        this.fPDOM = pdom;
        this.fDatabase = pdom.getDB();
    }

    protected PDOMLinkage(PDOM pdom, String linkageID, char[] name) throws CoreException {
        super(pdom.getDB(), name);
        Database db = pdom.getDB();
        this.fPDOM = pdom;
        this.fDatabase = db;
        db.putRecPtr(this.record + 12L, db.newString(linkageID).getRecord());
        pdom.insertLinkage(this);
    }

    @Override
    public final PDOM getPDOM() {
        return this.fPDOM;
    }

    @Override
    public final PDOMLinkage getLinkage() {
        return this;
    }

    @Override
    public final Database getDB() {
        return this.fDatabase;
    }

    @Override
    protected int getRecordSize() {
        return 32;
    }

    @Override
    public int getNodeType() {
        return 0;
    }

    public static IString getLinkageID(PDOM pdom, long record) throws CoreException {
        Database db = pdom.getDB();
        long namerec = db.getRecPtr(record + 12L);
        return db.getString(namerec);
    }

    public static long getNextLinkageRecord(PDOM pdom, long record) throws CoreException {
        return pdom.getDB().getRecPtr(record + 16L);
    }

    public void setNext(long nextrec) throws CoreException {
        this.getDB().putRecPtr(this.record + 16L, nextrec);
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.getDB(), this.record + 20L, this.getIndexComparator());
    }

    public BTree getNestedBindingsIndex() throws CoreException {
        return new BTree(this.fDatabase, this.record + 24L, this.getNestedBindingsComparator());
    }

    @Override
    public void accept(final IPDOMVisitor visitor) throws CoreException {
        if (visitor instanceof IBTreeVisitor) {
            this.getIndex().accept((IBTreeVisitor)((Object)visitor));
        } else {
            this.getIndex().accept(new IBTreeVisitor(){

                @Override
                public int compare(long record) throws CoreException {
                    return 0;
                }

                @Override
                public boolean visit(long record) throws CoreException {
                    PDOMNode node = PDOMNode.load(PDOMLinkage.this.fPDOM, record);
                    if (node != null) {
                        if (visitor.visit(node)) {
                            node.accept(visitor);
                        }
                        visitor.leave(node);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void addChild(PDOMNode child) throws CoreException {
        this.getIndex().insert(child.getRecord());
    }

    public final PDOMBinding getBinding(long record) throws CoreException {
        PDOMNode node = PDOMNode.load(this.fPDOM, record);
        if (node instanceof PDOMBinding) {
            return (PDOMBinding)node;
        }
        return null;
    }

    public abstract PDOMNode getNode(long var1, int var3) throws CoreException;

    public abstract IBTreeComparator getIndexComparator();

    public abstract PDOMGlobalScope getGlobalScope();

    public IBTreeComparator getNestedBindingsComparator() {
        return new FindBinding.NestedBindingsBTreeComparator(this);
    }

    protected boolean cannotAdapt(IBinding inputBinding) throws CoreException {
        PDOMBinding pdomBinding;
        if (inputBinding == null || inputBinding instanceof IProblemBinding || inputBinding instanceof IParameter) {
            return true;
        }
        return inputBinding instanceof PDOMBinding && (pdomBinding = (PDOMBinding)inputBinding).getPDOM() != this.getPDOM() && pdomBinding.isFileLocal();
    }

    protected final PDOMBinding attemptFastAdaptBinding(IBinding binding) throws CoreException {
        PDOMBinding pdomBinding = (PDOMBinding)binding.getAdapter(PDOMBinding.class);
        if (pdomBinding != null && pdomBinding.getPDOM() == this.fPDOM) {
            return pdomBinding;
        }
        return (PDOMBinding)this.fPDOM.getCachedResult(binding);
    }

    public final PDOMBinding adaptBinding(IBinding binding) throws CoreException {
        return this.adaptBinding(binding, true);
    }

    public abstract PDOMBinding adaptBinding(IBinding var1, boolean var2) throws CoreException;

    public abstract PDOMBinding addBinding(IASTName var1) throws CoreException;

    protected final long getLocalToFileRec(PDOMNode parent, IBinding binding, PDOMBinding glob) throws CoreException {
        PDOMFile file;
        long rec = 0L;
        if (parent instanceof PDOMBinding) {
            rec = ((PDOMBinding)parent).getLocalToFileRec();
        }
        if (rec == 0L && (file = this.getLocalToFile(binding, glob)) != null) {
            rec = file.getRecord();
        }
        return rec;
    }

    protected PDOMFile getLocalToFile(IBinding binding, PDOMBinding glob) throws CoreException {
        if (this.fPDOM instanceof WritablePDOM) {
            IASTNode node;
            WritablePDOM wpdom = (WritablePDOM)this.fPDOM;
            if (binding instanceof IField) {
                return null;
            }
            boolean checkIfInSourceOnly = false;
            boolean requireDefinition = false;
            if (binding instanceof IVariable) {
                if (!(binding instanceof IField)) {
                    checkIfInSourceOnly = ((IVariable)binding).isStatic();
                }
            } else if (binding instanceof IFunction) {
                IFunction f = (IFunction)binding;
                checkIfInSourceOnly = ASTInternal.isStatic(f, false);
            } else if (binding instanceof ITypedef || binding instanceof ICompositeType || binding instanceof IEnumeration) {
                checkIfInSourceOnly = true;
                requireDefinition = true;
            }
            if (checkIfInSourceOnly && (node = ASTInternal.getDeclaredInSourceFileOnly(this.getPDOM(), binding, requireDefinition, glob)) != null) {
                return wpdom.getFileForASTNode(this.getLinkageID(), node);
            }
        }
        return null;
    }

    public abstract int getBindingType(IBinding var1);

    public int getBindingId(IBinding binding) {
        return PDOMNode.getNodeId(this.getLinkageID(), this.getBindingType(binding));
    }

    public void onCreateName(PDOMFile file, IASTName name, PDOMName pdomName) throws CoreException {
        IASTDeclSpecifier ds;
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof IASTDeclSpecifier && (ds = (IASTDeclSpecifier)parentNode).getStorageClass() == 1 && pdomName.getEnclosingDefinitionRecord() != 0L) {
            pdomName.setIsBaseSpecifier();
        }
    }

    public void onDeleteName(PDOMName name) throws CoreException {
    }

    protected final void insertIntoNestedBindingsIndex(PDOMBinding pdomBinding) throws CoreException {
        if (pdomBinding.getParentNodeRec() != this.record) {
            this.getNestedBindingsIndex().insert(pdomBinding.getRecord());
        }
    }

    public void beforeRemoveBinding(PDOMBinding pdomBinding) throws CoreException {
        if (pdomBinding.getParentNodeRec() != this.record) {
            this.getNestedBindingsIndex().delete(pdomBinding.getRecord());
        }
    }

    public ICPPUsingDirective[] getUsingDirectives(PDOMFile file) throws CoreException {
        return ICPPUsingDirective.EMPTY_ARRAY;
    }

    public BTree getMacroIndex() {
        if (this.fMacroIndex == null) {
            this.fMacroIndex = new BTree(this.getDB(), this.record + 28L, new FindBinding.MacroBTreeComparator(this.fDatabase));
        }
        return this.fMacroIndex;
    }

    public PDOMMacroContainer findMacroContainer(char[] name) throws CoreException {
        return this.findMacroContainer(name, this.fPDOM.createKeyForCache(this.record, name));
    }

    private PDOMMacroContainer findMacroContainer(char[] name, String key) throws CoreException {
        Object result = this.fPDOM.getCachedResult(key);
        if (result instanceof PDOMMacroContainer) {
            return (PDOMMacroContainer)result;
        }
        assert (result == null);
        MacroContainerFinder visitor = new MacroContainerFinder(this, name);
        this.getMacroIndex().accept(visitor);
        PDOMMacroContainer container = visitor.getMacroContainer();
        if (container != null) {
            this.fPDOM.putCachedResult(key, container);
        }
        return container;
    }

    public PDOMMacroContainer getMacroContainer(char[] name) throws CoreException {
        String key = this.fPDOM.createKeyForCache(this.record, name);
        PDOMMacroContainer result = this.findMacroContainer(name, key);
        if (result == null) {
            result = new PDOMMacroContainer(this, name);
            this.getMacroIndex().insert(result.getRecord());
            this.fPDOM.putCachedResult(key, result);
        }
        return result;
    }

    public void removeMacroContainer(PDOMMacroContainer container) throws CoreException {
        String key = this.fPDOM.createKeyForCache(this.record, container.getNameCharArray());
        this.fPDOM.putCachedResult(key, null);
        this.getMacroIndex().delete(container.getRecord());
    }

    public String toString() {
        return this.getLinkageName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDOMBinding[] getBindingsViaCache(char[] name, IProgressMonitor monitor) throws CoreException {
        PDOMBinding[] result;
        CharArrayMap<PDOMBinding[]> map;
        CharArrayMap<PDOMBinding[]> charArrayMap = map = this.getBindingMap();
        synchronized (charArrayMap) {
            result = map.get(name);
            if (result != null) {
                return result;
            }
        }
        BindingCollector visitor = new BindingCollector(this, name, null, false, false, true);
        visitor.setMonitor(monitor);
        this.getIndex().accept(visitor);
        result = visitor.getBindings();
        CharArrayMap<PDOMBinding[]> charArrayMap2 = map;
        synchronized (charArrayMap2) {
            map.put(name, result);
        }
        return result;
    }

    private CharArrayMap<PDOMBinding[]> getBindingMap() {
        CharArrayMap map;
        Long key = this.getRecord();
        PDOM pdom = this.getPDOM();
        Reference cached = (Reference)pdom.getCachedResult(key);
        CharArrayMap charArrayMap = map = cached == null ? null : (CharArrayMap)cached.get();
        if (map == null) {
            map = new CharArrayMap();
            pdom.putCachedResult(key, new SoftReference(map));
        }
        return map;
    }

    public abstract PDOMBinding addTypeBinding(IBinding var1) throws CoreException;

    public abstract IType unmarshalType(ITypeMarshalBuffer var1) throws CoreException;

    public abstract IBinding unmarshalBinding(ITypeMarshalBuffer var1) throws CoreException;

    public abstract ISerializableEvaluation unmarshalEvaluation(ITypeMarshalBuffer var1) throws CoreException;

    public abstract ISerializableExecution unmarshalExecution(ITypeMarshalBuffer var1) throws CoreException;

    public void storeType(long offset, IType type) throws CoreException {
        Database db = this.getDB();
        this.deleteType(db, offset);
        this.storeType(db, offset, type);
    }

    private void storeType(Database db, long offset, IType type) throws CoreException {
        if (type != null) {
            TypeMarshalBuffer bc = new TypeMarshalBuffer(this);
            bc.marshalType(type);
            this.storeBuffer(db, offset, bc, 6);
        }
    }

    private void storeBuffer(Database db, long offset, TypeMarshalBuffer buf, int maxInlineSize) throws CoreException {
        int len = buf.getPosition();
        if (len > 0) {
            if (len <= maxInlineSize) {
                db.putBytes(offset, buf.getBuffer(), len);
            } else {
                db.putByte(offset, (byte)31);
                long chainOffset = offset + 1L;
                buf.putInt(len);
                int lenSize = buf.getPosition() - len;
                int bufferPos = 0;
                while (bufferPos < len) {
                    int chunkLength = bufferPos == 0 ? len + lenSize : len - bufferPos;
                    boolean chainingRequired = false;
                    if (chunkLength > 4094) {
                        chunkLength = 4094;
                        chainingRequired = true;
                    }
                    long ptr = db.malloc(chunkLength);
                    db.putRecPtr(chainOffset, ptr);
                    if (bufferPos == 0) {
                        db.putBytes(ptr, buf.getBuffer(), len, lenSize);
                        ptr += (long)lenSize;
                        chunkLength -= lenSize;
                    }
                    if (chainingRequired) {
                        chainOffset = ptr;
                        ptr += 4L;
                        chunkLength -= 4;
                    }
                    db.putBytes(ptr, buf.getBuffer(), bufferPos, chunkLength);
                    bufferPos += chunkLength;
                }
                buf.setPosition(len);
            }
        }
    }

    private byte[] loadLinkedSerializedData(Database db, long offset) throws CoreException {
        long ptr = db.getRecPtr(offset);
        int pos = 0;
        byte b = db.getByte(ptr + (long)pos++);
        int len = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = db.getByte(ptr + (long)pos++);
            len |= (b & 0x7F) << shift;
            shift += 7;
        }
        byte[] data = new byte[len];
        int bufferPos = 0;
        while (bufferPos < len) {
            int chunkLength = len + pos - bufferPos;
            long chunkPtr = ptr + (long)pos;
            if (chunkLength > 4094) {
                chunkLength = 4094;
                ptr = db.getRecPtr(chunkPtr);
                chunkPtr += 4L;
                chunkLength -= 4;
            }
            db.getBytes(chunkPtr, data, bufferPos, chunkLength -= pos);
            bufferPos += chunkLength;
            pos = 0;
        }
        return data;
    }

    private void deleteSerializedData(Database db, long offset, int maxInlineSize) throws CoreException {
        byte firstByte = db.getByte(offset);
        if (firstByte == 31) {
            long chunkPtr;
            long ptr = chunkPtr = db.getRecPtr(offset + 1L);
            byte b = db.getByte(ptr++);
            int len = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                b = db.getByte(ptr++);
                len |= (b & 0x7F) << shift;
                shift += 7;
            }
            len = (int)((long)len + (ptr - chunkPtr));
            while (len > 0) {
                int chunkLength = len;
                if (chunkLength > 4094) {
                    chunkLength = 4094;
                    ptr = db.getRecPtr(ptr);
                    chunkLength -= 4;
                }
                db.free(chunkPtr);
                chunkPtr = ptr;
                len -= chunkLength;
            }
        }
        db.clearBytes(offset, maxInlineSize);
    }

    private void deleteType(Database db, long offset) throws CoreException {
        this.deleteSerializedData(db, offset, 6);
    }

    public IType loadType(long offset) throws CoreException {
        Database db = this.getDB();
        byte firstByte = db.getByte(offset);
        byte[] data = null;
        switch (firstByte) {
            case 31: {
                data = this.loadLinkedSerializedData(db, offset + 1L);
                break;
            }
            case 29: {
                return TypeMarshalBuffer.UNSTORABLE_TYPE_PROBLEM;
            }
            case 0: {
                return null;
            }
            default: {
                data = new byte[6];
                db.getBytes(offset, data);
            }
        }
        return new TypeMarshalBuffer(this, data).unmarshalType();
    }

    public void storeBinding(long offset, IBinding binding) throws CoreException {
        Database db = this.getDB();
        this.deleteBinding(db, offset);
        this.storeBinding(db, offset, binding);
    }

    private void storeBinding(Database db, long offset, IBinding binding) throws CoreException {
        if (binding != null) {
            TypeMarshalBuffer bc = new TypeMarshalBuffer(this);
            bc.marshalBinding(binding);
            this.storeBuffer(db, offset, bc, 6);
        }
    }

    private void deleteBinding(Database db, long offset) throws CoreException {
        this.deleteSerializedData(db, offset, 6);
    }

    public IBinding loadBinding(long offset) throws CoreException {
        Database db = this.getDB();
        byte firstByte = db.getByte(offset);
        byte[] data = null;
        switch (firstByte) {
            case 31: {
                data = this.loadLinkedSerializedData(db, offset + 1L);
                break;
            }
            case 29: {
                return new ProblemBinding(null, 10005);
            }
            case 0: {
                return null;
            }
            default: {
                data = new byte[6];
                db.getBytes(offset, data);
            }
        }
        return new TypeMarshalBuffer(this, data).unmarshalBinding();
    }

    public void storeTemplateArgument(long offset, ICPPTemplateArgument arg) throws CoreException {
        Database db = this.getDB();
        this.deleteArgument(db, offset);
        this.storeArgument(db, offset, arg);
    }

    private void storeArgument(Database db, long offset, ICPPTemplateArgument arg) throws CoreException {
        if (arg != null) {
            TypeMarshalBuffer bc = new TypeMarshalBuffer(this);
            bc.marshalTemplateArgument(arg);
            this.storeBuffer(db, offset, bc, 6);
        }
    }

    private void deleteArgument(Database db, long offset) throws CoreException {
        this.deleteSerializedData(db, offset, 6);
    }

    public ICPPTemplateArgument loadTemplateArgument(long offset) throws CoreException {
        Database db = this.getDB();
        byte firstByte = db.getByte(offset);
        byte[] data = null;
        switch (firstByte) {
            case 31: {
                data = this.loadLinkedSerializedData(db, offset + 1L);
                break;
            }
            case 0: 
            case 29: {
                return null;
            }
            default: {
                data = new byte[6];
                db.getBytes(offset, data);
            }
        }
        return new TypeMarshalBuffer(this, data).unmarshalTemplateArgument();
    }

    public void storeValue(long offset, IValue value) throws CoreException {
        Database db = this.getDB();
        this.deleteValue(db, offset);
        this.storeValue(db, offset, value);
    }

    private void storeValue(Database db, long offset, IValue value) throws CoreException {
        if (value != null) {
            TypeMarshalBuffer bc = new TypeMarshalBuffer(this);
            bc.marshalValue(value);
            this.storeBuffer(db, offset, bc, 5);
        }
    }

    private void deleteValue(Database db, long offset) throws CoreException {
        this.deleteSerializedData(db, offset, 5);
    }

    public IValue loadValue(long offset) throws CoreException {
        TypeMarshalBuffer buffer = this.loadBuffer(offset, 5);
        if (buffer == null) {
            return null;
        }
        return buffer.unmarshalValue();
    }

    public void storeEvaluation(long offset, ISerializableEvaluation eval) throws CoreException {
        Database db = this.getDB();
        this.deleteEvaluation(db, offset);
        this.storeEvaluation(db, offset, eval);
    }

    private void storeEvaluation(Database db, long offset, ISerializableEvaluation eval) throws CoreException {
        if (eval != null) {
            TypeMarshalBuffer bc = new TypeMarshalBuffer(this);
            bc.marshalEvaluation(eval, true);
            this.storeBuffer(db, offset, bc, 6);
        }
    }

    private void deleteEvaluation(Database db, long offset) throws CoreException {
        this.deleteSerializedData(db, offset, 6);
    }

    public ISerializableEvaluation loadEvaluation(long offset) throws CoreException {
        TypeMarshalBuffer buffer = this.loadBuffer(offset, 6);
        if (buffer == null) {
            return null;
        }
        return buffer.unmarshalEvaluation();
    }

    public void storeExecution(long offset, ISerializableExecution exec) throws CoreException {
        Database db = this.getDB();
        this.deleteExecution(db, offset);
        this.storeExecution(db, offset, exec);
    }

    private void storeExecution(Database db, long offset, ISerializableExecution exec) throws CoreException {
        if (exec != null) {
            TypeMarshalBuffer bc = new TypeMarshalBuffer(this);
            bc.marshalExecution(exec, true);
            this.storeBuffer(db, offset, bc, 6);
        }
    }

    private void deleteExecution(Database db, long offset) throws CoreException {
        this.deleteSerializedData(db, offset, 6);
    }

    public ISerializableExecution loadExecution(long offset) throws CoreException {
        TypeMarshalBuffer buffer = this.loadBuffer(offset, 6);
        if (buffer == null) {
            return null;
        }
        return buffer.unmarshalExecution();
    }

    private TypeMarshalBuffer loadBuffer(long offset, int size) throws CoreException {
        byte[] data;
        Database db = this.getDB();
        byte firstByte = db.getByte(offset);
        switch (firstByte) {
            case 31: {
                data = this.loadLinkedSerializedData(db, offset + 1L);
                break;
            }
            case 0: {
                return null;
            }
            default: {
                data = new byte[size];
                db.getBytes(offset, data);
            }
        }
        return new TypeMarshalBuffer(this, data);
    }

    public IIndexScope[] getInlineNamespaces() {
        return IIndexScope.EMPTY_INDEX_SCOPE_ARRAY;
    }
}

