/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class PDOMSetupJob
extends Job {
    private static final String SETTINGS_FOLDER_NAME = ".settings";
    private PDOMManager fManager;

    PDOMSetupJob(PDOMManager manager) {
        super(Messages.PDOMManager_StartJob_name);
        this.fManager = manager;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ICProject cproject;
        while ((cproject = this.fManager.getNextProject()) != null) {
            IProject project = cproject.getProject();
            monitor.setTaskName(project.getName());
            if (!project.isOpen()) {
                if (!this.fManager.fTraceIndexerSetup) continue;
                System.out.println("Indexer: Project is not open: " + project.getName());
                continue;
            }
            if (this.fManager.postponeSetup(cproject)) {
                if (!this.fManager.fTraceIndexerSetup) continue;
                System.out.println("Indexer: Setup is postponed: " + project.getName());
                continue;
            }
            this.syncronizeProjectSettings(project, (IProgressMonitor)progress.newChild(1));
            if (this.fManager.getIndexer(cproject) == null) {
                try {
                    this.fManager.createIndexer(cproject, (IProgressMonitor)progress.newChild(99));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return Status.CANCEL_STATUS;
                }
            }
            if (!this.fManager.fTraceIndexerSetup) continue;
            System.out.println("Indexer: No action, indexer already exists: " + project.getName());
        }
        return Status.OK_STATUS;
    }

    private void syncronizeProjectSettings(IProject project, IProgressMonitor monitor) {
        try {
            IFolder settings = project.getFolder(SETTINGS_FOLDER_NAME);
            settings.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        monitor.done();
    }

    public boolean belongsTo(Object family) {
        return family == this.fManager;
    }
}

