/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexMacroContainer;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOMFileSet;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBProperties;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMIterator;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.MacroContainerCollector;
import org.eclipse.cdt.internal.core.pdom.dom.MacroContainerPatternCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.tag.PDOMTagIndex;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class PDOM
extends PlatformObject
implements IPDOM {
    private static final int CANCELLATION_CHECK_INTERVAL = 500;
    private static final int BLOCKED_WRITE_LOCK_OUTPUT_INTERVAL = 30000;
    private static final int LONG_WRITE_LOCK_REPORT_THRESHOLD = 1000;
    private static final int LONG_READ_LOCK_WAIT_REPORT_THRESHOLD = 1000;
    static boolean sDEBUG_LOCKS = false;
    public static final String FRAGMENT_PROPERTY_VALUE_FORMAT_ID = "org.eclipse.cdt.internal.core.pdom.PDOM";
    private static final int MIN_SUPPORTED_VERSION = PDOM.version(206, 0);
    private static final int MAX_SUPPORTED_VERSION = PDOM.version(206, Short.MAX_VALUE);
    private static final int DEFAULT_VERSION = PDOM.version(206, 0);
    public static final int LINKAGES = 2048;
    public static final int FILE_INDEX = 2052;
    public static final int INDEX_OF_DEFECTIVE_FILES = 2056;
    public static final int INDEX_OF_FILES_WITH_UNRESOLVED_INCLUDES = 2060;
    public static final int PROPERTIES = 2064;
    public static final int TAG_INDEX = 2068;
    public static final int END = 2072;
    private static final IBTreeComparator offsetComparator = new IBTreeComparator(){

        @Override
        public int compare(long record1, long record2) throws CoreException {
            return record1 < record2 ? -1 : (record1 == record2 ? 0 : 1);
        }
    };
    protected Database db;
    private BTree fileIndex;
    private PDOMTagIndex tagIndex;
    private BTree indexOfDefectiveFiles;
    private BTree indexOfFiledWithUnresolvedIncludes;
    private final Map<Integer, PDOMLinkage> fLinkageIDCache = new HashMap<Integer, PDOMLinkage>();
    private File fPath;
    private final IIndexLocationConverter locationConverter;
    private final Map<String, IPDOMLinkageFactory> fPDOMLinkageFactoryCache;
    private final HashMap<Object, Object> fResultCache = new HashMap();
    private List<IListener> listeners;
    protected ChangeEvent fEvent = new ChangeEvent();
    private final Object mutex = new Object();
    private int lockCount;
    private int waitingReaders;
    private long lastWriteAccess = 0L;
    private long lastReadAccess = 0L;
    private long timeWriteLockAcquired;
    private ThreadLocal<IBinding> inProgress = new ThreadLocal();
    private Map<Thread, DebugLockInfo> fLockDebugging;

    private static int version(int major, int minor) {
        return (major << 16) + minor;
    }

    public static int getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    public static boolean isSupportedVersion(int vers) {
        return vers >= MIN_SUPPORTED_VERSION && vers <= MAX_SUPPORTED_VERSION;
    }

    public static int getMinSupportedVersion() {
        return MIN_SUPPORTED_VERSION;
    }

    public static int getMaxSupportedVersion() {
        return MAX_SUPPORTED_VERSION;
    }

    public static String versionString(int version) {
        int major = version >> 16;
        int minor = version & 0xFFFF;
        return "" + major + '.' + minor;
    }

    public PDOM(File dbPath, IIndexLocationConverter locationConverter, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        this(dbPath, locationConverter, ChunkCache.getSharedInstance(), linkageFactoryMappings);
    }

    public PDOM(File dbPath, IIndexLocationConverter locationConverter, ChunkCache cache, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        this.fPDOMLinkageFactoryCache = linkageFactoryMappings;
        this.loadDatabase(dbPath, cache);
        this.locationConverter = locationConverter;
        if (sDEBUG_LOCKS) {
            this.fLockDebugging = new HashMap<Thread, DebugLockInfo>();
            System.out.println("Debugging PDOM Locks");
        }
    }

    protected boolean isPermanentlyReadOnly() {
        return true;
    }

    private void loadDatabase(File dbPath, ChunkCache cache) throws CoreException {
        this.fPath = dbPath;
        boolean lockDB = this.db == null || this.lockCount != 0;
        this.clearCaches();
        this.db = new Database(this.fPath, cache, PDOM.getDefaultVersion(), this.isPermanentlyReadOnly());
        this.db.setLocked(lockDB);
        if (this.isSupportedVersion()) {
            this.readLinkages();
        }
        this.db.setLocked(this.lockCount != 0);
    }

    public IIndexLocationConverter getLocationConverter() {
        return this.locationConverter;
    }

    public boolean isSupportedVersion() throws CoreException {
        int version = this.db.getVersion();
        return version >= MIN_SUPPORTED_VERSION && version <= MAX_SUPPORTED_VERSION;
    }

    private void readLinkages() throws CoreException {
        long record = this.getFirstLinkageRecord();
        while (record != 0L) {
            String linkageID = PDOMLinkage.getLinkageID(this, record).getString();
            IPDOMLinkageFactory factory = this.fPDOMLinkageFactoryCache.get(linkageID);
            if (factory != null) {
                PDOMLinkage linkage = factory.getLinkage(this, record);
                this.fLinkageIDCache.put(linkage.getLinkageID(), linkage);
            }
            record = PDOMLinkage.getNextLinkageRecord(this, record);
        }
    }

    protected PDOMLinkage createLinkage(int linkageID) throws CoreException {
        String linkageName;
        IPDOMLinkageFactory factory;
        PDOMLinkage pdomLinkage = this.fLinkageIDCache.get(linkageID);
        if (pdomLinkage == null && (factory = this.fPDOMLinkageFactoryCache.get(linkageName = Linkage.getLinkageName(linkageID))) != null) {
            return factory.createLinkage(this);
        }
        return pdomLinkage;
    }

    public PDOMLinkage getLinkage(int linkageID) throws CoreException {
        return this.fLinkageIDCache.get(linkageID);
    }

    private Collection<PDOMLinkage> getLinkageList() {
        return this.fLinkageIDCache.values();
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        for (PDOMLinkage linkage : this.getLinkageList()) {
            linkage.accept(visitor);
        }
    }

    @Override
    public void addListener(IListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<IListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireChange(ChangeEvent event) {
        if (this.listeners == null || event.isTrivial()) {
            return;
        }
        Iterator<IListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().handleChange(this, event);
        }
    }

    public Database getDB() {
        return this.db;
    }

    public BTree getFileIndex() throws CoreException {
        if (this.fileIndex == null) {
            this.fileIndex = new BTree(this.getDB(), 2052L, new PDOMFile.Comparator(this.getDB()));
        }
        return this.fileIndex;
    }

    public PDOMTagIndex getTagIndex() throws CoreException {
        if (this.tagIndex == null) {
            this.tagIndex = new PDOMTagIndex(this.db, 2068L);
        }
        return this.tagIndex;
    }

    public BTree getIndexOfDefectiveFiles() throws CoreException {
        if (this.indexOfDefectiveFiles == null) {
            this.indexOfDefectiveFiles = new BTree(this.getDB(), 2056L, offsetComparator);
        }
        return this.indexOfDefectiveFiles;
    }

    public BTree getIndexOfFilesWithUnresolvedIncludes() throws CoreException {
        if (this.indexOfFiledWithUnresolvedIncludes == null) {
            this.indexOfFiledWithUnresolvedIncludes = new BTree(this.getDB(), 2060L, offsetComparator);
        }
        return this.indexOfFiledWithUnresolvedIncludes;
    }

    @Override
    @Deprecated
    public PDOMFile getFile(int linkageID, IIndexFileLocation location) throws CoreException {
        PDOMLinkage linkage = this.getLinkage(linkageID);
        if (linkage == null) {
            return null;
        }
        return PDOMFile.findFile(linkage, this.getFileIndex(), location, this.locationConverter);
    }

    @Override
    public PDOMFile getFile(int linkageID, IIndexFileLocation location, ISignificantMacros macroDictionary) throws CoreException {
        PDOMLinkage linkage = this.getLinkage(linkageID);
        if (linkage == null) {
            return null;
        }
        return PDOMFile.findFile(linkage, this.getFileIndex(), location, this.locationConverter, macroDictionary);
    }

    public PDOMFile getFile(PDOMLinkage linkage, IIndexFileLocation location, ISignificantMacros macroDictionary) throws CoreException {
        return PDOMFile.findFile(linkage, this.getFileIndex(), location, this.locationConverter, macroDictionary);
    }

    @Override
    public IIndexFragmentFile[] getFiles(int linkageID, IIndexFileLocation location) throws CoreException {
        PDOMLinkage linkage = this.getLinkage(linkageID);
        if (linkage == null) {
            return IIndexFragmentFile.EMPTY_ARRAY;
        }
        return PDOMFile.findFiles(linkage, this.getFileIndex(), location, this.locationConverter);
    }

    @Override
    public IIndexFragmentFile[] getFiles(IIndexFileLocation location) throws CoreException {
        return PDOMFile.findFiles(this, this.getFileIndex(), location, this.locationConverter);
    }

    @Override
    public IIndexFragmentFile[] getAllFiles() throws CoreException {
        return this.getFiles(this.getFileIndex());
    }

    @Override
    public IIndexFragmentFile[] getDefectiveFiles() throws CoreException {
        return this.getFiles(this.getIndexOfDefectiveFiles());
    }

    @Override
    public IIndexFragmentFile[] getFilesWithUnresolvedIncludes() throws CoreException {
        return this.getFiles(this.getIndexOfFilesWithUnresolvedIncludes());
    }

    private IIndexFragmentFile[] getFiles(BTree index) throws CoreException {
        final ArrayList files = new ArrayList();
        index.accept(new IBTreeVisitor(){

            @Override
            public int compare(long record) throws CoreException {
                return 0;
            }

            @Override
            public boolean visit(long record) throws CoreException {
                PDOMFile file = PDOMFile.recreateFile(PDOM.this, record);
                files.add(file);
                return true;
            }
        });
        return files.toArray(new IIndexFragmentFile[files.size()]);
    }

    protected IIndexFragmentFile addFile(int linkageID, IIndexFileLocation location, ISignificantMacros sigMacros) throws CoreException {
        PDOMLinkage linkage = this.createLinkage(linkageID);
        PDOMFile file = this.getFile(linkage, location, sigMacros);
        if (file == null) {
            PDOMFile pdomFile = new PDOMFile(linkage, location, linkageID, sigMacros);
            this.getFileIndex().insert(pdomFile.getRecord());
            file = pdomFile;
            this.fEvent.setHasNewFiles();
        }
        return file;
    }

    protected void clearFileIndex() throws CoreException {
        this.db.putRecPtr(2052L, 0L);
        this.fileIndex = null;
    }

    protected void clear() throws CoreException {
        assert (this.lockCount < 0);
        int vers = PDOM.getDefaultVersion();
        this.db.clear(vers);
        this.clearCaches();
        this.fEvent.setCleared();
    }

    void reloadFromFile(File file) throws CoreException {
        assert (this.lockCount < 0);
        File oldFile = this.fPath;
        this.clearCaches();
        try {
            this.db.close();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        this.loadDatabase(file, this.db.getChunkCache());
        this.db.setExclusiveLock();
        oldFile.delete();
        this.fEvent.fReloaded = true;
    }

    public boolean isEmpty() throws CoreException {
        return this.getFirstLinkageRecord() == 0L;
    }

    @Override
    public IIndexFragmentBinding findBinding(IASTName name) throws CoreException {
        PDOMLinkage linkage;
        IBinding binding = name.resolveBinding();
        if (binding != null) {
            PDOMLinkage linkage2 = this.adaptLinkage(name.getLinkage());
            if (linkage2 != null) {
                return this.findBindingInLinkage(linkage2, binding, true);
            }
        } else if (name.getPropertyInParent() == IASTPreprocessorStatement.MACRO_NAME && (linkage = this.adaptLinkage(name.getLinkage())) != null) {
            return linkage.findMacroContainer(name.getSimpleID());
        }
        return null;
    }

    public IIndexBinding[] findBindings(Pattern pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(new Pattern[]{pattern}, isFullyQualified, filter, monitor);
    }

    @Override
    public IIndexFragmentBinding[] findBindings(Pattern[] patterns, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        Boolean caseSensitive;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((caseSensitive = this.getCaseSensitive(patterns)) != null) {
            char[] prefix;
            char[][] simpleNames = this.extractSimpleNames(patterns);
            if (simpleNames != null) {
                if (simpleNames.length == 1) {
                    return this.findBindings(simpleNames[0], isFullyQualified, caseSensitive, filter, monitor);
                }
                if (isFullyQualified) {
                    return this.findBindings(simpleNames, (boolean)caseSensitive, filter, monitor);
                }
            }
            if ((prefix = this.extractPrefix(patterns)) != null) {
                return this.findBindingsForPrefix(prefix, isFullyQualified, caseSensitive, filter, monitor);
            }
        }
        BindingFinder finder = new BindingFinder(patterns, isFullyQualified, filter, monitor);
        for (PDOMLinkage linkage : this.getLinkageList()) {
            if (!filter.acceptLinkage(linkage)) continue;
            try {
                linkage.accept(finder);
            }
            catch (CoreException e) {
                if (e.getStatus() != Status.OK_STATUS) {
                    throw e;
                }
                return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
            }
        }
        return finder.getBindings();
    }

    private Boolean getCaseSensitive(Pattern[] patterns) {
        Boolean caseSensitive = null;
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            switch (p.flags()) {
                case 0: {
                    if (caseSensitive == Boolean.FALSE) {
                        return null;
                    }
                    caseSensitive = Boolean.TRUE;
                    break;
                }
                case 2: {
                    if (caseSensitive == Boolean.TRUE) {
                        return null;
                    }
                    caseSensitive = Boolean.FALSE;
                    break;
                }
                default: {
                    return null;
                }
            }
            ++n2;
        }
        return caseSensitive;
    }

    private char[][] extractSimpleNames(Pattern[] pattern) {
        char[][] result = new char[pattern.length][];
        int i = 0;
        Pattern[] patternArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            char[] input;
            Pattern p = patternArray[n2];
            char[] cArray = input = p.pattern().toCharArray();
            int n3 = input.length;
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray[n4];
                if (!Character.isLetterOrDigit(c) && c != '_') {
                    return null;
                }
                ++n4;
            }
            result[i++] = input;
            ++n2;
        }
        return result;
    }

    private char[] extractPrefix(Pattern[] pattern) {
        if (pattern.length != 1) {
            return null;
        }
        String p = pattern[0].pattern();
        if (p.endsWith(".*")) {
            char[] input;
            char[] cArray = input = p.substring(0, p.length() - 2).toCharArray();
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetterOrDigit(c) && c != '_') {
                    return null;
                }
                ++n2;
            }
            return input;
        }
        return null;
    }

    @Override
    public IIndexFragmentBinding[] findMacroContainers(Pattern pattern, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        Pattern[] patterns;
        Boolean caseSensitive;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((caseSensitive = this.getCaseSensitive(patterns = new Pattern[]{pattern})) != null) {
            char[][] simpleNames = this.extractSimpleNames(patterns);
            if (simpleNames != null && simpleNames.length == 1) {
                return this.findMacroContainers(simpleNames[0], false, caseSensitive, filter, monitor);
            }
            char[] prefix = this.extractPrefix(patterns);
            if (prefix != null) {
                return this.findMacroContainers(prefix, true, caseSensitive, filter, monitor);
            }
        }
        ArrayList<PDOMMacroContainer> result = new ArrayList<PDOMMacroContainer>();
        for (PDOMLinkage linkage : this.getLinkageList()) {
            if (!filter.acceptLinkage(linkage)) continue;
            try {
                MacroContainerPatternCollector finder = new MacroContainerPatternCollector(linkage, pattern, monitor);
                linkage.getMacroIndex().accept(finder);
                result.addAll(Arrays.asList(finder.getMacroContainers()));
            }
            catch (CoreException e) {
                if (e.getStatus() != Status.OK_STATUS) {
                    throw e;
                }
                return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
            }
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    @Override
    public IIndexFragmentBinding[] findBindings(char[][] names, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(names, true, filter, monitor);
    }

    public IIndexFragmentBinding[] findBindings(char[][] names, boolean caseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (names.length == 0) {
            return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
        }
        if (names.length == 1) {
            return this.findBindings(names[0], true, caseSensitive, filter, monitor);
        }
        IIndexFragmentBinding[] candidates = this.findBindings(names[names.length - 1], false, caseSensitive, filter, monitor);
        int j = 0;
        int i = 0;
        while (i < candidates.length) {
            IIndexFragmentBinding cand = candidates[i];
            if (this.matches(cand, names, caseSensitive)) {
                candidates[j++] = cand;
            }
            ++i;
        }
        return ArrayUtil.trimAt(IIndexFragmentBinding.class, candidates, j - 1);
    }

    private boolean matches(IIndexFragmentBinding cand, char[][] names, boolean caseSensitive) {
        int i = names.length;
        while (--i >= 0) {
            if (cand == null) {
                return false;
            }
            char[] name = cand.getNameCharArray();
            if (!CharArrayUtils.equals(name, 0, name.length, names[i], !caseSensitive)) {
                if (cand instanceof IEnumeration) {
                    if (cand instanceof ICPPEnumeration && ((ICPPEnumeration)((Object)cand)).isScoped()) {
                        return false;
                    }
                    ++i;
                } else if (cand instanceof ICPPNamespace && name.length == 0) {
                    ++i;
                } else {
                    return false;
                }
            }
            cand = cand.getOwner();
        }
        return cand == null;
    }

    private long getFirstLinkageRecord() throws CoreException {
        return this.db.getRecPtr(2048L);
    }

    @Override
    public IIndexLinkage[] getLinkages() {
        Collection<PDOMLinkage> values = this.getLinkageList();
        return values.toArray(new IIndexLinkage[values.size()]);
    }

    @Override
    public PDOMLinkage[] getLinkageImpls() {
        Collection<PDOMLinkage> values = this.getLinkageList();
        return values.toArray(new PDOMLinkage[values.size()]);
    }

    public void insertLinkage(PDOMLinkage linkage) throws CoreException {
        linkage.setNext(this.db.getRecPtr(2048L));
        this.db.putRecPtr(2048L, linkage.getRecord());
        this.fLinkageIDCache.put(linkage.getLinkageID(), linkage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireReadLock() throws InterruptedException {
        long t = sDEBUG_LOCKS ? System.nanoTime() : 0L;
        Object object = this.mutex;
        synchronized (object) {
            ++this.waitingReaders;
            try {
                while (this.lockCount < 0) {
                    this.mutex.wait();
                }
            }
            finally {
                --this.waitingReaders;
            }
            ++this.lockCount;
            this.db.setLocked(true);
            if (sDEBUG_LOCKS) {
                t = (System.nanoTime() - t) / 1000000L;
                if (t >= 1000L) {
                    System.out.println("Acquired index read lock after " + t + " ms wait.");
                }
                PDOM.incReadLock(this.fLockDebugging);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseReadLock() {
        Object object = this.mutex;
        synchronized (object) {
            assert (this.lockCount > 0) : "No lock to release";
            if (sDEBUG_LOCKS) {
                PDOM.decReadLock(this.fLockDebugging);
            }
            this.lastReadAccess = System.currentTimeMillis();
            if (this.lockCount > 0) {
                --this.lockCount;
            }
            this.mutex.notifyAll();
            this.db.setLocked(this.lockCount != 0);
        }
        this.clearResultCache();
    }

    public void acquireWriteLock(IProgressMonitor monitor) throws InterruptedException {
        this.acquireWriteLock(0, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteLock(int giveupReadLocks, IProgressMonitor monitor) throws InterruptedException {
        assert (!this.isPermanentlyReadOnly());
        Object object = this.mutex;
        synchronized (object) {
            if (sDEBUG_LOCKS) {
                this.incWriteLock(giveupReadLocks);
            }
            if (giveupReadLocks > 0) {
                assert (this.lockCount >= giveupReadLocks) : "Not enough locks to release";
                if (this.lockCount < giveupReadLocks) {
                    giveupReadLocks = this.lockCount;
                }
            } else {
                giveupReadLocks = 0;
            }
            long start = sDEBUG_LOCKS ? System.currentTimeMillis() : 0L;
            int count = 0;
            while (this.lockCount > giveupReadLocks || this.waitingReaders > 0) {
                this.mutex.wait(500L);
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (monitor != null && ++count == 2) {
                    monitor.subTask(Messages.PDOM_waitingForWriteLock);
                }
                if (!sDEBUG_LOCKS) continue;
                start = this.reportBlockedWriteLock(start, giveupReadLocks);
            }
            this.lockCount = -1;
            if (sDEBUG_LOCKS) {
                this.timeWriteLockAcquired = System.currentTimeMillis();
            }
            this.db.setExclusiveLock();
        }
        if (monitor != null) {
            monitor.subTask("");
        }
    }

    public final void releaseWriteLock() {
        this.releaseWriteLock(0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock(int establishReadLocks, boolean flush) {
        if (establishReadLocks == 0) {
            this.clearResultCache();
        }
        try {
            this.db.giveUpExclusiveLock(flush);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        assert (this.lockCount == -1);
        if (!this.fEvent.isTrivial()) {
            this.lastWriteAccess = System.currentTimeMillis();
        }
        ChangeEvent event = this.fEvent;
        this.fEvent = new ChangeEvent();
        Object object = this.mutex;
        synchronized (object) {
            if (sDEBUG_LOCKS) {
                long timeHeld = this.lastWriteAccess - this.timeWriteLockAcquired;
                if (timeHeld >= 1000L) {
                    System.out.println("Index write lock held for " + timeHeld + " ms");
                }
                this.decWriteLock(establishReadLocks);
            }
            if (this.lockCount < 0) {
                this.lockCount = establishReadLocks;
            }
            this.mutex.notifyAll();
            this.db.setLocked(this.lockCount != 0);
        }
        this.fireChange(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasWaitingReaders() {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitingReaders > 0;
        }
    }

    @Override
    public long getLastWriteAccess() {
        return this.lastWriteAccess;
    }

    public long getLastReadAccess() {
        return this.lastReadAccess;
    }

    protected PDOMLinkage adaptLinkage(ILinkage linkage) throws CoreException {
        return this.fLinkageIDCache.get(linkage.getLinkageID());
    }

    @Override
    public IIndexFragmentBinding adaptBinding(IBinding binding) throws CoreException {
        if (this.inProgress.get() == binding) {
            return null;
        }
        this.inProgress.set(binding);
        try {
            IIndexFragmentBinding iIndexFragmentBinding = this.adaptBinding(binding, true);
            return iIndexFragmentBinding;
        }
        finally {
            this.inProgress.set(null);
        }
    }

    private IIndexFragmentBinding adaptBinding(IBinding binding, boolean includeLocal) throws CoreException {
        if (binding == null) {
            return null;
        }
        PDOMNode pdomNode = (PDOMNode)binding.getAdapter(PDOMNode.class);
        if (pdomNode instanceof IIndexFragmentBinding && pdomNode.getPDOM() == this) {
            return (IIndexFragmentBinding)((Object)pdomNode);
        }
        PDOMLinkage linkage = this.adaptLinkage(binding.getLinkage());
        if (linkage != null) {
            return this.findBindingInLinkage(linkage, binding, includeLocal);
        }
        if (binding instanceof IMacroBinding) {
            for (PDOMLinkage linkage2 : this.fLinkageIDCache.values()) {
                IIndexFragmentBinding pdomBinding = this.findBindingInLinkage(linkage2, binding, includeLocal);
                if (pdomBinding == null) continue;
                return pdomBinding;
            }
        }
        return null;
    }

    private IIndexFragmentBinding findBindingInLinkage(PDOMLinkage linkage, IBinding binding, boolean includeLocal) throws CoreException {
        if (binding instanceof IMacroBinding || binding instanceof IIndexMacroContainer) {
            return linkage.findMacroContainer(binding.getNameCharArray());
        }
        return linkage.adaptBinding(binding, includeLocal);
    }

    public IIndexFragmentBinding findBinding(IIndexFragmentName indexName) throws CoreException {
        if (indexName instanceof PDOMName) {
            PDOMName pdomName = (PDOMName)indexName;
            return pdomName.getBinding();
        }
        return null;
    }

    @Override
    public IIndexFragmentName[] findNames(IBinding binding, int options) throws CoreException {
        ArrayList<IIndexFragmentName> names;
        block5: {
            IIndexFragmentBinding myBinding;
            block4: {
                PDOMBinding[] xlangBindings;
                names = new ArrayList<IIndexFragmentName>();
                myBinding = this.adaptBinding(binding);
                if (!(myBinding instanceof PDOMBinding)) break block4;
                PDOMBinding pdomBinding = (PDOMBinding)myBinding;
                this.findNamesForMyBinding(pdomBinding, options, names);
                if ((options & 8) == 0) break block5;
                PDOMBinding[] pDOMBindingArray = xlangBindings = this.getCrossLanguageBindings(binding);
                int n = xlangBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    PDOMBinding xlangBinding = pDOMBindingArray[n2];
                    this.findNamesForMyBinding(xlangBinding, options, names);
                    ++n2;
                }
                break block5;
            }
            if (myBinding instanceof PDOMMacroContainer) {
                PDOMMacroContainer macroContainer = (PDOMMacroContainer)myBinding;
                this.findNamesForMyBinding(macroContainer, options, names);
                if ((options & 8) != 0) {
                    PDOMMacroContainer[] xlangBindings;
                    PDOMMacroContainer[] pDOMMacroContainerArray = xlangBindings = this.getCrossLanguageBindings(macroContainer);
                    int n = xlangBindings.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PDOMMacroContainer xlangBinding = pDOMMacroContainerArray[n3];
                        this.findNamesForMyBinding(xlangBinding, options, names);
                        ++n3;
                    }
                }
            }
        }
        return names.toArray(new IIndexFragmentName[names.size()]);
    }

    private void findNamesForMyBinding(PDOMBinding pdomBinding, int options, ArrayList<IIndexFragmentName> names) throws CoreException {
        PDOMName name;
        if ((options & 1) != 0) {
            name = pdomBinding.getFirstDeclaration();
            while (name != null) {
                if (this.isCommitted(name)) {
                    names.add(name);
                }
                name = name.getNextInBinding();
            }
        }
        if ((options & 2) != 0) {
            name = pdomBinding.getFirstDefinition();
            while (name != null) {
                if (this.isCommitted(name)) {
                    names.add(name);
                }
                name = name.getNextInBinding();
            }
        }
        if ((options & 4) != 0) {
            name = pdomBinding.getFirstReference();
            while (name != null) {
                if (this.isCommitted(name)) {
                    names.add(name);
                }
                name = name.getNextInBinding();
            }
            IPDOMIterator<PDOMName> iterator = pdomBinding.getExternalReferences();
            while (iterator.hasNext()) {
                name = iterator.next();
                if (!this.isCommitted(name)) continue;
                names.add(name);
            }
        }
    }

    private void findNamesForMyBinding(PDOMMacroContainer container, int options, ArrayList<IIndexFragmentName> names) throws CoreException {
        if ((options & 2) != 0) {
            PDOMMacro macro = container.getFirstDefinition();
            while (macro != null) {
                IIndexFragmentName name = macro.getDefinition();
                if (name != null && this.isCommitted(macro)) {
                    names.add(name);
                }
                macro = macro.getNextInContainer();
            }
        }
        if ((options & 4) != 0) {
            PDOMMacroReferenceName name = container.getFirstReference();
            while (name != null) {
                if (this.isCommitted(name)) {
                    names.add(name);
                }
                name = name.getNextInContainer();
            }
        }
    }

    protected boolean isCommitted(PDOMName name) throws CoreException {
        return true;
    }

    protected boolean isCommitted(PDOMMacro name) throws CoreException {
        return true;
    }

    protected boolean isCommitted(PDOMMacroReferenceName name) throws CoreException {
        return true;
    }

    @Override
    public IIndexFragmentInclude[] findIncludedBy(IIndexFragmentFile file) throws CoreException {
        PDOMFile pdomFile = this.adaptFile(file);
        if (pdomFile != null) {
            ArrayList<PDOMInclude> result = new ArrayList<PDOMInclude>();
            PDOMInclude i = pdomFile.getFirstIncludedBy();
            while (i != null) {
                if (i.getIncludedBy().getTimestamp() > 0L) {
                    result.add(i);
                }
                i = i.getNextInIncludedBy();
            }
            return result.toArray(new PDOMInclude[result.size()]);
        }
        return new PDOMInclude[0];
    }

    private PDOMFile adaptFile(IIndexFragmentFile file) throws CoreException {
        if (file.getIndexFragment() == this && file instanceof PDOMFile) {
            return (PDOMFile)file;
        }
        return this.getFile(file.getLinkageID(), file.getLocation(), file.getSignificantMacros());
    }

    public File getPath() {
        return this.fPath;
    }

    @Override
    public IIndexFragmentBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindingsForPrefix(prefix, filescope, false, filter, monitor);
    }

    public IIndexFragmentBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, boolean caseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindingsForPrefixOrContentAssist(prefix, filescope, false, caseSensitive, filter, monitor);
    }

    @Override
    public IIndexFragmentBinding[] findBindingsForContentAssist(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindingsForPrefixOrContentAssist(prefix, filescope, true, false, filter, monitor);
    }

    private IIndexFragmentBinding[] findBindingsForPrefixOrContentAssist(char[] prefix, boolean filescope, boolean isContentAssist, boolean caseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList<PDOMBinding> result = new ArrayList<PDOMBinding>();
        for (PDOMLinkage linkage : this.getLinkageList()) {
            PDOMBinding[] bindings;
            if (!filter.acceptLinkage(linkage)) continue;
            BindingCollector visitor = new BindingCollector(linkage, prefix, filter, !isContentAssist, isContentAssist, caseSensitive);
            visitor.setMonitor(monitor);
            try {
                linkage.accept(visitor);
                if (!filescope) {
                    visitor.setSkipGlobalEnumerators(true);
                    linkage.getNestedBindingsIndex().accept(visitor);
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
            PDOMBinding[] pDOMBindingArray = bindings = visitor.getBindings();
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                PDOMBinding binding = pDOMBindingArray[n2];
                result.add(binding);
                ++n2;
            }
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    @Override
    public IIndexFragmentBinding[] findBindings(char[] name, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(name, filescope, true, filter, monitor);
    }

    public IIndexFragmentBinding[] findBindings(char[] name, boolean filescope, boolean isCaseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList<PDOMBinding> result = new ArrayList<PDOMBinding>();
        try {
            for (PDOMLinkage linkage : this.getLinkageList()) {
                PDOMBinding[] bindings;
                int n;
                if (!filter.acceptLinkage(linkage)) continue;
                if (isCaseSensitive) {
                    PDOMBinding[] bindings2;
                    PDOMBinding[] pDOMBindingArray = bindings2 = linkage.getBindingsViaCache(name, monitor);
                    n = bindings2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PDOMBinding binding = pDOMBindingArray[n2];
                        if (filter.acceptBinding(binding)) {
                            result.add(binding);
                        }
                        ++n2;
                    }
                }
                if (isCaseSensitive && filescope) continue;
                BindingCollector visitor = new BindingCollector(linkage, name, filter, false, false, isCaseSensitive);
                visitor.setMonitor(monitor);
                if (!isCaseSensitive) {
                    linkage.accept(visitor);
                }
                if (!filescope) {
                    visitor.setSkipGlobalEnumerators(true);
                    linkage.getNestedBindingsIndex().accept(visitor);
                }
                PDOMBinding[] pDOMBindingArray = bindings = visitor.getBindings();
                int n3 = bindings.length;
                n = 0;
                while (n < n3) {
                    PDOMBinding binding = pDOMBindingArray[n];
                    result.add(binding);
                    ++n;
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    public IIndexFragmentBinding[] findMacroContainers(char[] prefix, boolean isPrefix, boolean isCaseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList<PDOMMacroContainer> result = new ArrayList<PDOMMacroContainer>();
        try {
            for (PDOMLinkage linkage : this.getLinkageList()) {
                if (!filter.acceptLinkage(linkage)) continue;
                MacroContainerCollector visitor = new MacroContainerCollector(linkage, prefix, isPrefix, false, isCaseSensitive);
                visitor.setMonitor(monitor);
                linkage.getMacroIndex().accept(visitor);
                result.addAll(visitor.getMacroList());
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    @Override
    public IIndexMacro[] findMacros(char[] prefix, boolean isPrefix, boolean isCaseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList<IIndexMacro> result = new ArrayList<IIndexMacro>();
        try {
            for (PDOMLinkage linkage : this.getLinkageList()) {
                if (!filter.acceptLinkage(linkage)) continue;
                MacroContainerCollector visitor = new MacroContainerCollector(linkage, prefix, isPrefix, false, isCaseSensitive);
                visitor.setMonitor(monitor);
                linkage.getMacroIndex().accept(visitor);
                for (PDOMMacroContainer mcont : visitor.getMacroList()) {
                    result.addAll(Arrays.asList(mcont.getDefinitions()));
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
        return result.toArray(new IIndexMacro[result.size()]);
    }

    @Override
    public String getProperty(String propertyName) throws CoreException {
        if ("org.eclipse.cdt.internal.core.index.fragment.format.id".equals(propertyName)) {
            return FRAGMENT_PROPERTY_VALUE_FORMAT_ID;
        }
        int version = this.db.getVersion();
        if ("org.eclipse.cdt.internal.core.index.fragment.format.version".equals(propertyName)) {
            return PDOM.versionString(version);
        }
        if (PDOM.isSupportedVersion(version)) {
            return new DBProperties(this.db, 2064L).getProperty(propertyName);
        }
        if ("org.eclipse.cdt.internal.core.index.fragment.id".equals(propertyName)) {
            return "Unknown";
        }
        return null;
    }

    public void close() throws CoreException {
        this.db.close();
        this.clearCaches();
    }

    private void clearCaches() {
        this.fileIndex = null;
        this.tagIndex = null;
        this.indexOfDefectiveFiles = null;
        this.indexOfFiledWithUnresolvedIncludes = null;
        this.fLinkageIDCache.clear();
        this.clearResultCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearResultCache() {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.clear();
        }
    }

    @Override
    public long getCacheHits() {
        return this.db.getCacheHits();
    }

    @Override
    public long getCacheMisses() {
        return this.db.getCacheMisses();
    }

    @Override
    public void resetCacheCounters() {
        this.db.resetCacheCounters();
    }

    protected void flush() throws CoreException {
        this.db.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCachedResult(Object key) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            return this.fResultCache.get(key);
        }
    }

    public void putCachedResult(Object key, Object result) {
        this.putCachedResult(key, result, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putCachedResult(Object key, Object result, boolean replace) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            Object old = this.fResultCache.put(key, result);
            if (old != null && !replace) {
                this.fResultCache.put(key, old);
                return old;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedResult(Object key) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.remove(key);
        }
    }

    public String createKeyForCache(long record, char[] name) {
        return new StringBuilder(name.length + 2).append((char)(record >> 16)).append((char)record).append(name).toString();
    }

    public boolean hasLastingDefinition(PDOMBinding binding) throws CoreException {
        return binding.hasDefinition();
    }

    private PDOMBinding[] getCrossLanguageBindings(IBinding binding) throws CoreException {
        switch (binding.getLinkage().getLinkageID()) {
            case 2: {
                return this.getCPPBindingForC(binding);
            }
            case 1: {
                return this.getCBindingForCPP(binding);
            }
        }
        return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
    }

    private PDOMMacroContainer[] getCrossLanguageBindings(PDOMMacroContainer binding) throws CoreException {
        int inputLinkage = binding.getLinkage().getLinkageID();
        if (inputLinkage == 2 || inputLinkage == 1) {
            char[] name = binding.getNameCharArray();
            for (PDOMLinkage linkage : this.getLinkageList()) {
                PDOMMacroContainer container;
                int linkageID = linkage.getLinkageID();
                if (linkageID == inputLinkage || linkageID != 2 && linkageID != 1 || (container = linkage.findMacroContainer(name)) == null) continue;
                return new PDOMMacroContainer[]{container};
            }
        }
        return new PDOMMacroContainer[0];
    }

    private PDOMBinding[] getCBindingForCPP(IBinding binding) throws CoreException {
        PDOMBinding[] pDOMBindingArray;
        PDOMBinding result = null;
        PDOMLinkage c = this.getLinkage(2);
        if (c == null) {
            return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
        }
        if (binding instanceof ICPPFunction) {
            ICPPFunction func = (ICPPFunction)binding;
            if (func.isExternC()) {
                result = FindBinding.findBinding(c.getIndex(), c, func.getNameCharArray(), new int[]{7}, 0L);
            }
        } else {
            int key;
            if (binding instanceof ICPPField) {
                ICPPField field = (ICPPField)binding;
                ICompositeType parent = field.getCompositeTypeOwner();
                PDOMBinding[] cOwners = this.getCBindingForCPP(parent);
                ArrayList<PDOMBinding> results = new ArrayList<PDOMBinding>();
                PDOMBinding[] pDOMBindingArray2 = cOwners;
                int n = cOwners.length;
                int n2 = 0;
                while (n2 < n) {
                    PDOMBinding cOwner = pDOMBindingArray2[n2];
                    result = FindBinding.findBinding(cOwner, c, field.getNameCharArray(), new int[]{9}, 0L);
                    if (result != null) {
                        results.add(result);
                    }
                    ++n2;
                }
                return results.isEmpty() ? PDOMBinding.EMPTY_PDOMBINDING_ARRAY : results.toArray(new PDOMBinding[results.size()]);
            }
            if (binding instanceof ICPPVariable) {
                ICPPVariable var = (ICPPVariable)binding;
                if (var.isExternC()) {
                    result = FindBinding.findBinding(c.getIndex(), c, var.getNameCharArray(), new int[]{6}, 0L);
                }
            } else if (binding instanceof IEnumeration) {
                result = FindBinding.findBinding(c.getIndex(), c, binding.getNameCharArray(), new int[]{10}, 0L);
            } else if (binding instanceof IEnumerator) {
                result = FindBinding.findBinding(c.getIndex(), c, binding.getNameCharArray(), new int[]{3}, 0L);
            } else if (binding instanceof ITypedef) {
                result = FindBinding.findBinding(c.getIndex(), c, binding.getNameCharArray(), new int[]{12}, 0L);
            } else if (binding instanceof ICompositeType && ((key = ((ICompositeType)binding).getKey()) == 1 || key == 2) && (result = FindBinding.findBinding(c.getIndex(), c, binding.getNameCharArray(), new int[]{8}, 0L)) instanceof ICompositeType && ((ICompositeType)((Object)result)).getKey() != key) {
                result = null;
            }
        }
        if (result == null) {
            pDOMBindingArray = PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
        } else {
            PDOMBinding[] pDOMBindingArray3 = new PDOMBinding[1];
            pDOMBindingArray = pDOMBindingArray3;
            pDOMBindingArray3[0] = result;
        }
        return pDOMBindingArray;
    }

    private PDOMBinding[] getCPPBindingForC(IBinding binding) throws CoreException {
        PDOMLinkage cpp = this.getLinkage(1);
        if (cpp == null) {
            return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
        }
        PDOMBinding[] cppOwners = null;
        IndexFilter filter = null;
        if (binding instanceof IFunction) {
            filter = new IndexFilter(){

                @Override
                public boolean acceptBinding(IBinding binding) {
                    if (binding instanceof ICPPFunction) {
                        return ((ICPPFunction)binding).isExternC();
                    }
                    return false;
                }
            };
        } else if (binding instanceof IField) {
            ICompositeType compOwner = ((IField)binding).getCompositeTypeOwner();
            cppOwners = this.getCPPBindingForC(compOwner);
            if (cppOwners.length > 0) {
                filter = IndexFilter.ALL;
            }
        } else if (binding instanceof IVariable) {
            if (!(binding instanceof IField) && !(binding instanceof IParameter)) {
                filter = new IndexFilter(){

                    @Override
                    public boolean acceptBinding(IBinding binding) {
                        if (binding instanceof ICPPVariable) {
                            return ((ICPPVariable)binding).isExternC();
                        }
                        return false;
                    }
                };
            }
        } else if (binding instanceof IEnumeration) {
            filter = new IndexFilter(){

                @Override
                public boolean acceptBinding(IBinding binding) {
                    return binding instanceof IEnumeration;
                }
            };
        } else if (binding instanceof ITypedef) {
            filter = new IndexFilter(){

                @Override
                public boolean acceptBinding(IBinding binding) {
                    return binding instanceof ITypedef;
                }
            };
        } else if (binding instanceof IEnumerator) {
            filter = new IndexFilter(){

                @Override
                public boolean acceptBinding(IBinding binding) {
                    return binding instanceof IEnumerator;
                }
            };
        } else if (binding instanceof ICompositeType) {
            final int key = ((ICompositeType)binding).getKey();
            filter = new IndexFilter(){

                @Override
                public boolean acceptBinding(IBinding binding) {
                    if (binding instanceof ICompositeType) {
                        return ((ICompositeType)binding).getKey() == key;
                    }
                    return false;
                }
            };
        }
        if (filter != null) {
            BindingCollector collector = new BindingCollector(cpp, binding.getNameCharArray(), filter, false, false, true);
            if (cppOwners != null) {
                PDOMBinding[] pDOMBindingArray = cppOwners;
                int n = cppOwners.length;
                int n2 = 0;
                while (n2 < n) {
                    PDOMBinding owner = pDOMBindingArray[n2];
                    owner.accept(collector);
                    ++n2;
                }
            } else {
                cpp.accept(collector);
            }
            return collector.getBindings();
        }
        return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
    }

    @Override
    public IIndexFragmentFileSet createFileSet() {
        return new PDOMFileSet();
    }

    private static DebugLockInfo getLockInfo(Map<Thread, DebugLockInfo> lockDebugging) {
        assert (sDEBUG_LOCKS);
        Thread key = Thread.currentThread();
        DebugLockInfo result = lockDebugging.get(key);
        if (result == null) {
            result = new DebugLockInfo();
            lockDebugging.put(key, result);
        }
        return result;
    }

    static void incReadLock(Map<Thread, DebugLockInfo> lockDebugging) {
        DebugLockInfo info = PDOM.getLockInfo(lockDebugging);
        ++info.fReadLocks;
        if (info.addTrace() > 10) {
            PDOM.outputReadLocks(lockDebugging);
        }
    }

    static void decReadLock(Map<Thread, DebugLockInfo> lockDebugging) throws AssertionError {
        DebugLockInfo info = PDOM.getLockInfo(lockDebugging);
        if (info.fReadLocks <= 0) {
            PDOM.outputReadLocks(lockDebugging);
            throw new AssertionError((Object)"Superfluous releaseReadLock");
        }
        if (info.fWriteLocks != 0) {
            PDOM.outputReadLocks(lockDebugging);
            throw new AssertionError((Object)"Releasing readlock while holding write lock");
        }
        if (--info.fReadLocks == 0) {
            lockDebugging.remove(Thread.currentThread());
        } else {
            info.addTrace();
        }
    }

    private void incWriteLock(int giveupReadLocks) throws AssertionError {
        DebugLockInfo info = PDOM.getLockInfo(this.fLockDebugging);
        if (info.fReadLocks != giveupReadLocks) {
            PDOM.outputReadLocks(this.fLockDebugging);
            throw new AssertionError((Object)("write lock with " + giveupReadLocks + " readlocks, expected " + info.fReadLocks));
        }
        if (info.fWriteLocks != 0) {
            throw new AssertionError((Object)"Duplicate write lock");
        }
        ++info.fWriteLocks;
    }

    private void decWriteLock(int establishReadLocks) throws AssertionError {
        DebugLockInfo info = PDOM.getLockInfo(this.fLockDebugging);
        if (info.fReadLocks != establishReadLocks) {
            throw new AssertionError((Object)("release write lock with " + establishReadLocks + " readlocks, expected " + info.fReadLocks));
        }
        if (info.fWriteLocks != 1) {
            throw new AssertionError((Object)"Wrong release write lock");
        }
        info.fWriteLocks = 0;
        if (info.fReadLocks == 0) {
            this.fLockDebugging.remove(Thread.currentThread());
        }
    }

    private long reportBlockedWriteLock(long start, int giveupReadLocks) {
        long now = System.currentTimeMillis();
        if (now >= start + 30000L) {
            System.out.println();
            System.out.println("Blocked writeLock");
            System.out.println("  lockcount= " + this.lockCount + ", giveupReadLocks=" + giveupReadLocks + ", waitingReaders=" + this.waitingReaders);
            PDOM.outputReadLocks(this.fLockDebugging);
            start = now;
        }
        return start;
    }

    private static void outputReadLocks(Map<Thread, DebugLockInfo> lockDebugging) {
        System.out.println("---------------------  Lock Debugging -------------------------");
        for (Thread th : lockDebugging.keySet()) {
            DebugLockInfo info = lockDebugging.get(th);
            info.write(th.getName());
        }
        System.out.println("---------------------------------------------------------------");
    }

    public void adjustThreadForReadLock(Map<Thread, DebugLockInfo> lockDebugging) {
        for (Thread th : lockDebugging.keySet()) {
            DebugLockInfo val = lockDebugging.get(th);
            if (val.fReadLocks <= 0) continue;
            DebugLockInfo myval = this.fLockDebugging.get(th);
            if (myval == null) {
                myval = new DebugLockInfo();
                this.fLockDebugging.put(th, myval);
            }
            myval.inc(val);
            int i = 0;
            while (i < val.fReadLocks) {
                PDOM.decReadLock(this.fLockDebugging);
                ++i;
            }
        }
    }

    @Override
    public IIndexScope[] getInlineNamespaces() throws CoreException {
        PDOMLinkage linkage = this.getLinkage(1);
        if (linkage == null) {
            return IIndexScope.EMPTY_INDEX_SCOPE_ARRAY;
        }
        return linkage.getInlineNamespaces();
    }

    @Override
    public boolean isFullyInitialized() {
        return true;
    }

    private static class BindingFinder
    implements IPDOMVisitor {
        private final Pattern[] pattern;
        private final IProgressMonitor monitor;
        private final ArrayList<PDOMNamedNode> currentPath = new ArrayList();
        private final ArrayList<BitSet> matchStack = new ArrayList();
        private final List<PDOMNamedNode> bindings = new ArrayList<PDOMNamedNode>();
        private final boolean isFullyQualified;
        private BitSet matchesUpToLevel;
        private final IndexFilter filter;

        public BindingFinder(Pattern[] pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) {
            this.pattern = pattern;
            this.monitor = monitor;
            this.isFullyQualified = isFullyQualified;
            this.filter = filter;
            this.matchesUpToLevel = new BitSet();
            this.matchesUpToLevel.set(0);
            this.matchStack.add(this.matchesUpToLevel);
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            if (this.monitor.isCanceled()) {
                throw new CoreException(Status.OK_STATUS);
            }
            if (node instanceof PDOMNamedNode) {
                PDOMNamedNode nnode = (PDOMNamedNode)node;
                String name = new String(nnode.getNameCharArray());
                int lastIdx = this.pattern.length - 1;
                if (this.matchesUpToLevel.get(lastIdx) && this.pattern[lastIdx].matcher(name).matches() && nnode instanceof IBinding && this.filter.acceptBinding((IBinding)((Object)nnode))) {
                    this.bindings.add(nnode);
                }
                if (nnode.mayHaveChildren()) {
                    if (this.pattern.length == 1 && nnode instanceof ICPPEnumeration && !((ICPPEnumeration)((Object)nnode)).isScoped()) {
                        return false;
                    }
                    boolean visitNextLevel = false;
                    BitSet updatedMatchesUpToLevel = new BitSet();
                    if (!this.isFullyQualified) {
                        updatedMatchesUpToLevel.set(0);
                        visitNextLevel = true;
                    }
                    int i = 0;
                    while (i < lastIdx) {
                        if (this.matchesUpToLevel.get(i) && this.pattern[i].matcher(name).matches()) {
                            updatedMatchesUpToLevel.set(i + 1);
                            visitNextLevel = true;
                        }
                        ++i;
                    }
                    if (visitNextLevel) {
                        this.matchStack.add(this.matchesUpToLevel);
                        this.matchesUpToLevel = updatedMatchesUpToLevel;
                        this.currentPath.add(nnode);
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
            int idx = this.currentPath.size() - 1;
            if (idx >= 0 && this.currentPath.get(idx) == node) {
                this.currentPath.remove(idx);
                this.matchesUpToLevel = this.matchStack.remove(this.matchStack.size() - 1);
            }
        }

        public IIndexFragmentBinding[] getBindings() {
            return this.bindings.toArray(new IIndexFragmentBinding[this.bindings.size()]);
        }
    }

    public static class ChangeEvent {
        public Set<IIndexFileLocation> fClearedFiles = new HashSet<IIndexFileLocation>();
        public Set<IIndexFileLocation> fFilesWritten = new HashSet<IIndexFileLocation>();
        private boolean fCleared;
        private boolean fReloaded;
        private boolean fNewFiles;

        private void setCleared() {
            this.fCleared = true;
            this.fReloaded = false;
            this.fNewFiles = false;
            this.fClearedFiles.clear();
            this.fFilesWritten.clear();
        }

        public boolean isCleared() {
            return this.fCleared;
        }

        public void setReloaded() {
            this.fReloaded = true;
        }

        public boolean isReloaded() {
            return this.fReloaded;
        }

        public void setHasNewFiles() {
            this.fNewFiles = true;
        }

        public boolean hasNewFiles() {
            return this.fNewFiles;
        }

        public boolean isTrivial() {
            return !this.fCleared && !this.fReloaded && !this.fNewFiles && this.fClearedFiles.isEmpty() && this.fFilesWritten.isEmpty();
        }
    }

    static class DebugLockInfo {
        int fReadLocks;
        int fWriteLocks;
        List<StackTraceElement[]> fTraces = new ArrayList<StackTraceElement[]>();

        DebugLockInfo() {
        }

        public int addTrace() {
            this.fTraces.add(Thread.currentThread().getStackTrace());
            return this.fTraces.size();
        }

        public void write(String threadName) {
            System.out.println("Thread: '" + threadName + "': " + this.fReadLocks + " readlocks, " + this.fWriteLocks + " writelocks");
            for (StackTraceElement[] trace : this.fTraces) {
                System.out.println("  Stacktrace:");
                StackTraceElement[] stackTraceElementArray = trace;
                int n = trace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement ste = stackTraceElementArray[n2];
                    System.out.println("    " + ste);
                    ++n2;
                }
            }
        }

        public void inc(DebugLockInfo val) {
            this.fReadLocks += val.fReadLocks;
            this.fWriteLocks += val.fWriteLocks;
            this.fTraces.addAll(val.fTraces);
        }
    }

    public static interface IListener {
        public void handleChange(PDOM var1, ChangeEvent var2);
    }
}

