/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.internal.core.parser.CodeReaderLRUCache;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.FileCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.resources.PathCanonicalizationStrategy;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InternalParserUtil
extends ParserFactory {
    public static final String SYSTEM_DEFAULT_ENCODING = System.getProperty("file.encoding");

    public static String normalizePath(String path, IFile file) {
        IPath loc = file.getLocation();
        if (loc != null) {
            path = loc.toOSString();
        }
        return path;
    }

    @Deprecated
    public static CodeReader createExternalFileReader(String externalLocation, CodeReaderLRUCache cache) throws IOException {
        File includeFile = new File(externalLocation);
        if (includeFile.isFile()) {
            CodeReader result;
            String path = PathCanonicalizationStrategy.getCanonicalPath(includeFile);
            if (cache != null && (result = cache.get(path)) != null) {
                return result;
            }
            return new CodeReader(path);
        }
        return null;
    }

    @Deprecated
    public static CodeReader createWorkspaceFileReader(String path, IFile file, CodeReaderLRUCache cache) throws CoreException, IOException {
        CodeReader codeReader;
        InputStream in;
        CodeReader result;
        path = InternalParserUtil.normalizePath(path, file);
        if (cache != null && (result = cache.get(path)) != null) {
            return result;
        }
        try {
            in = file.getContents(true);
        }
        catch (CoreException e) {
            switch (e.getStatus().getCode()) {
                case 269: 
                case 270: 
                case 271: 
                case 369: {
                    return null;
                }
            }
            throw e;
        }
        try {
            codeReader = new CodeReader(path, file.getCharset(), in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return codeReader;
    }

    @Deprecated
    public static CodeReader createCodeReader(IIndexFileLocation ifl, CodeReaderLRUCache cache) throws CoreException, IOException {
        IResource res;
        String fullPath = ifl.getFullPath();
        if (fullPath != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath))) instanceof IFile) {
            return InternalParserUtil.createWorkspaceFileReader(ifl.getURI().getPath(), (IFile)res, cache);
        }
        return InternalParserUtil.createExternalFileReader(ifl.getURI().getPath(), cache);
    }

    public static InternalFileContent createFileContent(IIndexFileLocation ifl) {
        IResource res;
        String fullPath = ifl.getFullPath();
        if (fullPath != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath))) instanceof IFile) {
            return InternalParserUtil.createWorkspaceFileContent((IFile)res);
        }
        String scheme = ifl.getURI().getScheme();
        if (!scheme.equals("file")) {
            return InternalParserUtil.createExternalFileContent(UNCPathConverter.toPath(ifl.getURI()).toString(), SYSTEM_DEFAULT_ENCODING);
        }
        return InternalParserUtil.createExternalFileContent(ifl.getURI().getPath(), SYSTEM_DEFAULT_ENCODING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InternalFileContent createWorkspaceFileContent(IFile file) {
        String path = file.getLocationURI().getPath();
        path = InternalParserUtil.normalizePath(path, file);
        try {
            InternalFileContent internalFileContent;
            long fileReadTime = System.currentTimeMillis();
            IFileStore store = EFS.getStore((URI)file.getLocationURI());
            IFileInfo fileInfo = store.fetchInfo();
            if (!fileInfo.exists()) {
                return null;
            }
            InputStream input = file.getContents(true);
            if (!(input instanceof FileInputStream)) return null;
            try {
                internalFileContent = InternalParserUtil.createFileContent(path, null, file.getCharset(), input, fileInfo.getLastModified(), fileInfo.getLength(), fileReadTime);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
                return internalFileContent;
            }
            catch (IOException iOException) {}
            return internalFileContent;
        }
        catch (CoreException e) {
            switch (e.getStatus().getCode()) {
                case 269: 
                case 270: 
                case 271: 
                case 368: 
                case 369: {
                    return null;
                }
            }
            CCorePlugin.log(e);
        }
        return null;
    }

    public static InternalFileContent createExternalFileContent(String externalLocation, String encoding) {
        long fileReadTime = System.currentTimeMillis();
        File includeFile = null;
        String path = null;
        String localPath = null;
        if (!UNCPathConverter.isUNC(externalLocation)) {
            includeFile = new File(externalLocation);
            path = PathCanonicalizationStrategy.getCanonicalPath(includeFile);
        } else {
            try {
                IFileStore store = EFS.getStore((URI)UNCPathConverter.getInstance().toURI(externalLocation));
                includeFile = store.toLocalFile(4096, null);
                path = externalLocation;
                localPath = includeFile.getAbsolutePath();
            }
            catch (CoreException coreException) {}
        }
        if (includeFile != null && includeFile.isFile()) {
            InternalFileContent internalFileContent;
            FileInputStream in;
            long timestamp = includeFile.lastModified();
            long fileSize = includeFile.length();
            try {
                in = new FileInputStream(includeFile);
            }
            catch (IOException e) {
                CCorePlugin.log(e);
                return null;
            }
            try {
                internalFileContent = InternalParserUtil.createFileContent(path, localPath, encoding, in, timestamp, fileSize, fileReadTime);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return internalFileContent;
        }
        return null;
    }

    private static InternalFileContent createFileContent(String path, String localPath, String charset, InputStream in, long fileTimestamp, long fileSize, long fileReadTime) {
        AbstractCharArray chars;
        block4: {
            if (localPath == null) {
                localPath = path;
            }
            try {
                chars = FileCharArray.create(localPath, charset, in);
                if (chars != null) break block4;
                return null;
            }
            catch (IOException e) {
                CCorePlugin.log(e);
                return null;
            }
        }
        return new InternalFileContent(path, chars, fileTimestamp, fileSize, fileReadTime);
    }
}

