/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathEntry
implements IPathEntry {
    protected int entryKind;
    protected boolean isExported;
    protected IPath path;

    public PathEntry(int entryKind, IPath path, boolean isExported) {
        this.path = path == null ? Path.EMPTY : path;
        this.entryKind = entryKind;
        this.isExported = isExported;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public int getEntryKind() {
        return this.entryKind;
    }

    @Override
    public boolean isExported() {
        return this.isExported;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.entryKind;
        result = 31 * result + (this.isExported ? 1231 : 1237);
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPathEntry) {
            IPathEntry otherEntry = (IPathEntry)obj;
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            return this.isExported == otherEntry.isExported();
        }
        return super.equals(obj);
    }

    public static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 8;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("inc")) {
            return 16;
        }
        if (kindStr.equalsIgnoreCase("incfile")) {
            return 256;
        }
        if (kindStr.equalsIgnoreCase("mac")) {
            return 64;
        }
        if (kindStr.equalsIgnoreCase("macfile")) {
            return 512;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 32;
        }
        if (kindStr.equalsIgnoreCase("out")) {
            return 128;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 4: {
                return "prj";
            }
            case 8: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 16: {
                return "inc";
            }
            case 256: {
                return "incfile";
            }
            case 64: {
                return "mac";
            }
            case 512: {
                return "macfile";
            }
            case 32: {
                return "con";
            }
            case 128: {
                return "out";
            }
        }
        return "unknown";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.path != null && !this.path.isEmpty()) {
            buffer.append(this.path.toString()).append(' ');
        }
        buffer.append('[');
        buffer.append(this.getKindString());
        buffer.append(']');
        return buffer.toString();
    }

    String getKindString() {
        switch (this.getEntryKind()) {
            case 1: {
                return "Library path";
            }
            case 4: {
                return "Project path";
            }
            case 8: {
                return "Source path";
            }
            case 128: {
                return "Output path";
            }
            case 16: {
                return "Include path";
            }
            case 256: {
                return "Include-file path";
            }
            case 64: {
                return "Symbol definition";
            }
            case 512: {
                return "Symbol-file definition";
            }
            case 32: {
                return "Contributed paths";
            }
        }
        return "Unknown";
    }
}

