/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.internal.core.dom.parser.ISerializableExecution;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.core.runtime.CoreException;

public class ExecIf
implements ICPPExecution {
    private final ICPPEvaluation conditionExprEval;
    private final ExecSimpleDeclaration conditionDeclExec;
    private final ICPPExecution thenClauseExec;
    private final ICPPExecution elseClauseExec;

    public ExecIf(ICPPEvaluation conditionExprEval, ExecSimpleDeclaration conditionDeclExec, ICPPExecution thenClauseExec, ICPPExecution elseClauseExec) {
        this.conditionExprEval = conditionExprEval;
        this.conditionDeclExec = conditionDeclExec;
        this.thenClauseExec = thenClauseExec;
        this.elseClauseExec = elseClauseExec;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        boolean conditionSatisfied = false;
        if (this.conditionExprEval != null) {
            conditionSatisfied = EvalUtil.conditionExprSatisfied(this.conditionExprEval, record, context);
        } else if (this.conditionDeclExec != null) {
            conditionSatisfied = EvalUtil.conditionDeclSatisfied(this.conditionDeclExec, record, context);
        }
        if (conditionSatisfied) {
            return EvalUtil.executeStatement(this.thenClauseExec, record, context);
        }
        if (this.elseClauseExec != null) {
            return EvalUtil.executeStatement(this.elseClauseExec, record, context);
        }
        return null;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPExecution newElseClauseExec;
        ICPPEvaluation newConditionExprEval = this.conditionExprEval != null ? this.conditionExprEval.instantiate(context, maxDepth) : null;
        ExecSimpleDeclaration newConditionDeclExec = this.conditionDeclExec != null ? (ExecSimpleDeclaration)this.conditionDeclExec.instantiate(context, maxDepth) : null;
        ICPPExecution newThenClauseExec = this.thenClauseExec.instantiate(context, maxDepth);
        ICPPExecution iCPPExecution = newElseClauseExec = this.elseClauseExec != null ? this.elseClauseExec.instantiate(context, maxDepth) : null;
        if (newConditionExprEval == this.conditionExprEval && newConditionDeclExec == this.conditionDeclExec && newThenClauseExec == this.thenClauseExec && newElseClauseExec == this.elseClauseExec) {
            return this;
        }
        return new ExecIf(newConditionExprEval, newConditionDeclExec, newThenClauseExec, newElseClauseExec);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)11);
        buffer.marshalEvaluation(this.conditionExprEval, includeValue);
        buffer.marshalExecution(this.conditionDeclExec, includeValue);
        buffer.marshalExecution(this.thenClauseExec, includeValue);
        buffer.marshalExecution(this.elseClauseExec, includeValue);
    }

    public static ISerializableExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation conditionExprEval = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ExecSimpleDeclaration conditionDeclExec = (ExecSimpleDeclaration)buffer.unmarshalExecution();
        ICPPExecution thenClauseExec = (ICPPExecution)buffer.unmarshalExecution();
        ICPPExecution elseClauseExec = (ICPPExecution)buffer.unmarshalExecution();
        return new ExecIf(conditionExprEval, conditionDeclExec, thenClauseExec, elseClauseExec);
    }
}

