/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplateInstance;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPAliasTemplateInstance
extends PlatformObject
implements ICPPAliasTemplateInstance,
ITypeContainer {
    private final char[] name;
    private final ICPPAliasTemplate aliasTemplate;
    private IType aliasedType;

    public CPPAliasTemplateInstance(char[] name, ICPPAliasTemplate aliasTemplate, IType aliasedType) {
        this.name = name;
        this.aliasTemplate = aliasTemplate;
        this.aliasedType = aliasedType;
    }

    @Override
    public ICPPAliasTemplate getTemplateDefinition() {
        return this.aliasTemplate;
    }

    @Override
    public boolean isSameType(IType other) {
        if (other == this.aliasedType) {
            return true;
        }
        if (this.aliasedType != null) {
            return this.aliasedType.isSameType(other);
        }
        return false;
    }

    @Override
    public IType getType() {
        return this.aliasedType;
    }

    @Override
    public void setType(IType type) {
        this.aliasedType = type;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        if (this.name != null) {
            return this.name;
        }
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        if (this.aliasTemplate != null) {
            return this.aliasTemplate.getOwner();
        }
        return null;
    }

    @Override
    public IScope getScope() throws DOMException {
        if (this.aliasTemplate != null) {
            return this.aliasTemplate.getScope();
        }
        return null;
    }

    public String toString() {
        return String.valueOf(ASTTypeUtil.getQualifiedName(this)) + " -> " + ASTTypeUtil.getType(this.aliasedType, true);
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        return this.aliasTemplate.isGloballyQualified();
    }
}

