/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;

public class CPPASTTypeIdInitializerExpression
extends ASTNode
implements IASTTypeIdInitializerExpression,
ICPPASTExpression {
    private IASTTypeId fTypeId;
    private IASTInitializer fInitializer;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTTypeIdInitializerExpression() {
    }

    public CPPASTTypeIdInitializerExpression(IASTTypeId t, IASTInitializer i) {
        this.setTypeId(t);
        this.setInitializer(i);
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.fTypeId;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fTypeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.fInitializer;
    }

    @Override
    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        this.fInitializer = initializer;
        if (initializer != null) {
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fTypeId != null && !this.fTypeId.accept(action)) {
            return false;
        }
        if (this.fInitializer != null && !this.fInitializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTTypeIdInitializerExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public final boolean isLValue() {
        return false;
    }

    @Override
    public IASTTypeIdInitializerExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public IASTTypeIdInitializerExpression copy(IASTNode.CopyStyle style) {
        CPPASTTypeIdInitializerExpression copy = new CPPASTTypeIdInitializerExpression(this.fTypeId == null ? null : this.fTypeId.copy(style), this.fInitializer == null ? null : this.fInitializer.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        IASTInitializer initializer = this.getInitializer();
        if (!(initializer instanceof ICPPASTInitializerClause)) {
            return EvalFixed.INCOMPLETE;
        }
        IType type = CPPVisitor.createType(this.getTypeId());
        if (type == null || type instanceof IProblemType) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalTypeId(type, this, false, ((ICPPASTInitializerClause)((Object)initializer)).getEvaluation());
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }
}

