/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.CStringValue;
import org.eclipse.cdt.internal.core.dom.parser.FloatingPointValue;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;

public class CPPASTLiteralExpression
extends ASTNode
implements ICPPASTLiteralExpression {
    private static final EvalFixed EVAL_TRUE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(true));
    private static final EvalFixed EVAL_FALSE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(false));
    private static final EvalFixed EVAL_NULL_PTR = new EvalFixed(CPPBasicType.NULL_PTR, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(0L));
    public static final CPPASTLiteralExpression INT_ZERO = new CPPASTLiteralExpression(0, new char[]{'0'});
    private int fKind;
    private char[] fValue = CharArrayUtils.EMPTY;
    private int fStringLiteralSize = -1;
    private char[] fSuffix = CharArrayUtils.EMPTY;
    private boolean fIsCompilerSuffix = true;
    private ICPPEvaluation fEvaluation;
    private IBinding fUserDefinedLiteralOperator;
    private IASTImplicitName[] fImplicitNames;

    public CPPASTLiteralExpression() {
    }

    public CPPASTLiteralExpression(int kind, char[] value) {
        this.fKind = kind;
        this.fValue = value;
    }

    public CPPASTLiteralExpression(int kind, char[] value, char[] suffix, boolean isCompilerSuffix) {
        this(kind, value);
        this.setSuffix(suffix);
    }

    @Override
    public CPPASTLiteralExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTLiteralExpression copy(IASTNode.CopyStyle style) {
        CPPASTLiteralExpression copy = new CPPASTLiteralExpression(this.fKind, this.fValue == null ? null : (char[])this.fValue.clone(), this.fSuffix == null ? null : (char[])this.fSuffix.clone(), this.fIsCompilerSuffix);
        copy.setOffsetAndLength(this);
        return this.copy(copy, style);
    }

    @Override
    public int getKind() {
        return this.fKind;
    }

    @Override
    public void setKind(int value) {
        this.assertNotFrozen();
        this.fKind = value;
    }

    @Override
    public char[] getValue() {
        return this.fValue;
    }

    @Override
    public void setValue(char[] value) {
        this.assertNotFrozen();
        this.fValue = value;
    }

    public char[] getSuffix() {
        return this.fSuffix;
    }

    public void setSuffix(char[] suffix) {
        this.fSuffix = suffix;
    }

    public void calculateSuffix() {
        this.calculateSuffix(CharArrayUtils.EMPTY);
    }

    public void calculateSuffix(char[] compilerSuffixes) {
        try {
            block1 : switch (this.fKind) {
                case 0: 
                case 1: {
                    int udOffset;
                    int n = udOffset = this.fValue[0] == '.' ? this.afterDecimalPoint(0) : this.integerLiteral();
                    if (udOffset > 0) {
                        this.setSuffix(CharArrayUtils.subarray(this.fValue, udOffset, -1));
                        int i = 0;
                        while (i < this.fSuffix.length) {
                            switch (this.fSuffix[i]) {
                                case 'F': 
                                case 'L': 
                                case 'U': 
                                case 'f': 
                                case 'l': 
                                case 'u': {
                                    break;
                                }
                                default: {
                                    int j = 0;
                                    while (j < compilerSuffixes.length) {
                                        if (this.fSuffix[i] == compilerSuffixes[j]) {
                                            // empty if block
                                        }
                                        ++j;
                                    }
                                    this.fIsCompilerSuffix = false;
                                    this.setValue(CharArrayUtils.subarray(this.fValue, 0, udOffset));
                                    break block1;
                                }
                            }
                            ++i;
                        }
                    }
                    break;
                }
                case 3: {
                    int offset = CharArrayUtils.lastIndexOf('\"', this.fValue, CharArrayUtils.indexOf('\"', this.fValue) + 1);
                    if (offset > 0) {
                        this.setSuffix(CharArrayUtils.subarray(this.fValue, offset + 1, -1));
                        if (this.fSuffix.length > 0) {
                            this.fIsCompilerSuffix = false;
                        }
                    }
                    break;
                }
                case 2: {
                    int offset = CharArrayUtils.lastIndexOf('\'', this.fValue, CharArrayUtils.indexOf('\'', this.fValue) + 1);
                    if (offset <= 0) break;
                    this.setSuffix(CharArrayUtils.subarray(this.fValue, offset + 1, -1));
                    if (this.fSuffix.length <= 0) break;
                    this.fIsCompilerSuffix = false;
                }
                default: {
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    @Override
    public String toString() {
        return new String(this.fValue);
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        return IASTImplicitDestructorName.EMPTY_NAME_ARRAY;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    private int computeStringLiteralSize() {
        int start = 0;
        int end = this.fValue.length - 1 - this.getSuffix().length;
        boolean isRaw = false;
        if (this.fValue[0] == 'L' || this.fValue[0] == 'u' || this.fValue[0] == 'U') {
            ++start;
        }
        if (this.fValue[start] == 'R') {
            ++start;
            isRaw = true;
        }
        if (this.fValue[start] != '\"' || this.fValue[end] != '\"') {
            return 0;
        }
        ++start;
        --end;
        if (isRaw) {
            while (this.fValue[start] != '(' && start <= end) {
                ++start;
                --end;
            }
            if (this.fValue[start] != '(' || this.fValue[end] != ')') {
                return 0;
            }
            return end - start + 1 + 1;
        }
        int length = 0;
        boolean escaping = false;
        while (start <= end) {
            if (escaping) {
                escaping = false;
                ++length;
            } else if (this.fValue[start] == '\\') {
                escaping = true;
            } else {
                ++length;
            }
            ++start;
        }
        return length + 1;
    }

    private IValue getStringLiteralSize() {
        if (this.fStringLiteralSize == -1) {
            this.fStringLiteralSize = this.computeStringLiteralSize();
        }
        return IntegralValue.create(this.fStringLiteralSize);
    }

    private IType getStringType() {
        if (this.fSuffix.length > 0) {
            return this.getUserDefinedLiteralOperatorType();
        }
        IType type = new CPPBasicType(this.getBasicCharKind(), 0, this);
        type = new CPPQualifierType(type, true, false);
        return new CPPArrayType(type, this.getStringLiteralSize());
    }

    private IType getCharType() {
        return this.fSuffix.length > 0 ? this.getUserDefinedLiteralOperatorType() : new CPPBasicType(this.getBasicCharKind(), 0, this);
    }

    private IBinding getUserDefinedLiteralOperator() {
        if (!this.fIsCompilerSuffix && this.fUserDefinedLiteralOperator == null) {
            try {
                this.fUserDefinedLiteralOperator = CPPSemantics.findUserDefinedLiteralOperator(this);
            }
            catch (DOMException dOMException) {}
            if (this.fUserDefinedLiteralOperator == null) {
                this.fUserDefinedLiteralOperator = new ProblemBinding(this, 1, this.fSuffix);
            }
        }
        return this.fUserDefinedLiteralOperator;
    }

    private IType getUserDefinedLiteralOperatorType() {
        IType ret = new ProblemType(10001);
        IBinding func = this.getUserDefinedLiteralOperator();
        if (func != null && func instanceof ICPPFunction) {
            ret = ((ICPPFunction)func).getType().getReturnType();
        }
        return ret;
    }

    public char[] getOperatorName() {
        return CharArrayUtils.concat("operator \"\"".toCharArray(), this.fSuffix);
    }

    public IBasicType.Kind getBasicCharKind() {
        switch (this.fValue[0]) {
            case 'L': {
                return IBasicType.Kind.eWChar;
            }
            case 'u': {
                return IBasicType.Kind.eChar16;
            }
            case 'U': {
                return IBasicType.Kind.eChar32;
            }
        }
        return IBasicType.Kind.eChar;
    }

    private IType classifyTypeOfFloatLiteral() {
        char[] lit = this.fSuffix;
        int len = lit.length;
        IBasicType.Kind kind = IBasicType.Kind.eDouble;
        int flags = 0;
        if (len > 0) {
            if (this.fIsCompilerSuffix) {
                switch (lit[len - 1]) {
                    case 'F': 
                    case 'f': {
                        kind = IBasicType.Kind.eFloat;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        flags |= 1;
                    }
                }
            } else {
                return this.getUserDefinedLiteralOperatorType();
            }
        }
        return new CPPBasicType(kind, flags, this);
    }

    private IType classifyTypeOfIntLiteral() {
        int makelong = 0;
        boolean unsigned = false;
        char[] lit = this.fSuffix;
        int flags = 0;
        if (this.fIsCompilerSuffix) {
            int i = lit.length - 1;
            while (i >= 0) {
                char c = lit[i];
                if (!(c > 'f' && c <= 'z' || c > 'F' && c <= 'Z')) break;
                switch (c) {
                    case 'U': 
                    case 'u': {
                        unsigned = true;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        ++makelong;
                    }
                }
                --i;
            }
            if (unsigned) {
                flags |= 8;
            }
            if (makelong > 1) {
                flags |= 0x40;
            } else if (makelong == 1) {
                flags |= 1;
            }
        } else if (lit.length > 0) {
            return this.getUserDefinedLiteralOperatorType();
        }
        return new CPPBasicType(IBasicType.Kind.eInt, flags, this);
    }

    private int integerLiteral() {
        char c;
        int i = 0;
        if ((c = this.fValue[i++]) == '0' && i < this.fValue.length) {
            c = this.fValue[i];
            switch (c | 0x20) {
                case 120: {
                    return this.probablyHex(i);
                }
                case 98: {
                    return this.probablyBinary(i);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    while (this.isOctal(c) && i < this.fValue.length) {
                        c = this.fValue[++i];
                    }
                    break;
                }
                case 46: {
                    return this.afterDecimalPoint(i);
                }
            }
            if (c == '8' || c == '9') {
                c = this.fValue[i];
                while (Character.isDigit(c) && i < this.fValue.length) {
                    c = this.fValue[++i];
                }
            }
            return this.handleDecimalOrExponent(c, i);
        }
        if (Character.isDigit(c)) {
            c = this.fValue[i];
            while (Character.isDigit(c) && i < this.fValue.length) {
                c = this.fValue[++i];
            }
            return this.handleDecimalOrExponent(c, i);
        }
        assert (false);
        return i;
    }

    private int handleDecimalOrExponent(char c, int i) {
        if (c == '.') {
            return this.afterDecimalPoint(i);
        }
        if ((c | 0x20) == 101) {
            return this.exponentPart(i);
        }
        return i;
    }

    private int afterDecimalPoint(int i) {
        char c = this.fValue[++i];
        while (Character.isDigit(c) && i < this.fValue.length) {
            c = this.fValue[++i];
        }
        if ((c | 0x20) == 101) {
            return this.exponentPart(i);
        }
        return i;
    }

    private int exponentPart(int i) {
        char c;
        if ((c = this.fValue[++i]) == '+' || c == '-') {
            c = this.fValue[++i];
        }
        while (Character.isDigit(c) && i < this.fValue.length) {
            c = this.fValue[++i];
        }
        return i--;
    }

    private int probablyBinary(int i) {
        char c;
        if ((c = this.fValue[++i]) == '1' || c == '0') {
            while (c == '1' || c == '0' && i < this.fValue.length) {
                c = this.fValue[i++];
            }
            if (Character.isDigit(c)) {
                return -1;
            }
            if (c == '.') {
                c = this.fValue[++i];
                while (Character.isDigit(c) && i < this.fValue.length) {
                    c = this.fValue[i++];
                }
            }
        } else {
            return i - 1;
        }
        return i;
    }

    private int probablyHex(int i) {
        char c;
        if (this.isHexDigit(c = this.fValue[++i])) {
            while (this.isHexDigit(c) && i < this.fValue.length) {
                c = this.fValue[++i];
            }
            if (c == '.') {
                return this.hexFloatAfterDecimal(i);
            }
            if ((c | 0x20) == 112) {
                return this.hexFloatExponent(i);
            }
        } else {
            return i - 1;
        }
        return i;
    }

    private int hexFloatAfterDecimal(int i) {
        char c;
        if (this.isHexDigit(c = this.fValue[++i])) {
            while (this.isHexDigit(c) && i < this.fValue.length) {
                c = this.fValue[++i];
            }
            if ((c | 0x20) == 112) {
                return this.hexFloatExponent(i);
            }
            return -1;
        }
        return -1;
    }

    private int hexFloatExponent(int i) {
        char c;
        if ((c = this.fValue[++i]) == '-' || c == '+') {
            c = this.fValue[++i];
        }
        if (Character.isDigit(c)) {
            while (Character.isDigit(c) && i < this.fValue.length) {
                c = this.fValue[++i];
            }
        } else {
            return i - 1;
        }
        return i;
    }

    private boolean isHexDigit(char c) {
        return (c = (char)(c | 0x20)) <= 'f' && c >= 'a' || c <= '9' && c >= '0';
    }

    private boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    @Override
    @Deprecated
    public void setValue(String value) {
        this.assertNotFrozen();
        this.fValue = value.toCharArray();
    }

    @Deprecated
    public CPPASTLiteralExpression(int kind, String value) {
        this(kind, value.toCharArray());
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.createEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation createLiteralEvaluation() {
        switch (this.fKind) {
            case 4: {
                IScope scope = CPPVisitor.getContainingScope(this);
                IType type = CPPVisitor.getImpliedObjectType(scope);
                if (type == null) {
                    return EvalFixed.INCOMPLETE;
                }
                return new EvalFixed(new CPPPointerType(type), IASTExpression.ValueCategory.PRVALUE, IntegralValue.THIS);
            }
            case 5: {
                return EVAL_TRUE;
            }
            case 6: {
                return EVAL_FALSE;
            }
            case 2: {
                return new EvalFixed(this.getCharType(), IASTExpression.ValueCategory.PRVALUE, this.createCharValue());
            }
            case 1: {
                return new EvalFixed(this.classifyTypeOfFloatLiteral(), IASTExpression.ValueCategory.PRVALUE, FloatingPointValue.create(this.getValue()));
            }
            case 0: {
                return new EvalFixed(this.classifyTypeOfIntLiteral(), IASTExpression.ValueCategory.PRVALUE, this.createIntValue());
            }
            case 3: {
                return new EvalFixed(this.getStringType(), IASTExpression.ValueCategory.LVALUE, CStringValue.create(this.getValue()));
            }
            case 7: {
                return EVAL_NULL_PTR;
            }
        }
        return EvalFixed.INCOMPLETE;
    }

    private ICPPEvaluation createEvaluation() {
        ICPPEvaluation literalEval = this.createLiteralEvaluation();
        IBinding udlOperator = this.getUserDefinedLiteralOperator();
        if (udlOperator != null && literalEval != EvalFixed.INCOMPLETE && udlOperator instanceof ICPPFunction) {
            ICPPFunction udlOpFunction = (ICPPFunction)udlOperator;
            EvalBinding op = new EvalBinding((IBinding)udlOpFunction, (IType)udlOpFunction.getType(), this);
            ICPPEvaluation[] args = null;
            ICPPParameter[] params = udlOpFunction.getParameters();
            int paramCount = params.length;
            if (paramCount == 0) {
                args = new ICPPEvaluation[]{op};
            } else if (paramCount == 1) {
                if (params[0].getType() instanceof IPointerType) {
                    char[] numValue = this.getValue();
                    int numLen = numValue.length;
                    char[] strValue = new char[numLen + 2];
                    strValue[0] = 34;
                    strValue[numLen + 1] = 34;
                    System.arraycopy(numValue, 0, strValue, 1, numLen);
                    IType type = new CPPBasicType(IBasicType.Kind.eChar, 0, this);
                    type = new CPPQualifierType(type, true, false);
                    type = new CPPArrayType(type, IntegralValue.create(numLen + 1));
                    EvalFixed strEval = new EvalFixed(type, IASTExpression.ValueCategory.LVALUE, CStringValue.create(strValue));
                    args = new ICPPEvaluation[]{op, strEval};
                } else {
                    args = new ICPPEvaluation[]{op, literalEval};
                }
            } else if (paramCount == 2) {
                IntegralValue sizeValue = IntegralValue.create(this.computeStringLiteralSize() - 1);
                EvalFixed literalSizeEval = new EvalFixed(CPPBasicType.INT, IASTExpression.ValueCategory.PRVALUE, sizeValue);
                args = new ICPPEvaluation[]{op, literalEval, literalSizeEval};
            }
            return new EvalFunctionCall(args, null, this);
        }
        if (!(this.getSuffix().length <= 0 || this.getKind() != 3 && this.fIsCompilerSuffix)) {
            return EvalFixed.INCOMPLETE;
        }
        return literalEval;
    }

    private IValue createCharValue() {
        try {
            char[] image = this.getValue();
            if (image.length > 1 && image[0] == 'L') {
                return IntegralValue.create(ExpressionEvaluator.getChar(image, 2));
            }
            return IntegralValue.create(ExpressionEvaluator.getChar(image, 1));
        }
        catch (ExpressionEvaluator.EvalException evalException) {
            return IntegralValue.UNKNOWN;
        }
    }

    private IValue createIntValue() {
        try {
            return IntegralValue.create(ExpressionEvaluator.getNumber(this.getValue()));
        }
        catch (ExpressionEvaluator.EvalException evalException) {
            return IntegralValue.UNKNOWN;
        }
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getKind() == 3 ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            if (this.fIsCompilerSuffix) {
                this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(this.fSuffix, (IASTNode)this);
                operatorName.setOperator(true);
                operatorName.setBinding(this.getUserDefinedLiteralOperator());
                operatorName.setOffsetAndLength(this.getOffset() + this.fValue.length, this.fSuffix.length);
                this.fImplicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.fImplicitNames;
    }
}

