/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.CoreException;

public class CQualifierType
implements ICQualifierType,
ITypeContainer,
ISerializableType {
    private boolean isConst;
    private boolean isVolatile;
    private boolean isRestrict;
    private IType type;

    public CQualifierType(ICASTDeclSpecifier declSpec) {
        this.type = CVisitor.createBaseType(declSpec);
        this.isConst = declSpec.isConst();
        this.isVolatile = declSpec.isVolatile();
        this.isRestrict = declSpec.isRestrict();
    }

    public CQualifierType(IType type, boolean isConst, boolean isVolatile, boolean isRestrict) {
        this.type = type;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.isRestrict = isRestrict;
    }

    @Override
    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICQualifierType) {
            ICQualifierType qt = (ICQualifierType)obj;
            if (this.isConst() != qt.isConst()) {
                return false;
            }
            if (this.isRestrict() != qt.isRestrict()) {
                return false;
            }
            if (this.isVolatile() != qt.isVolatile()) {
                return false;
            }
            if (this.type == null) {
                return false;
            }
            return this.type.isSameType(qt.getType());
        }
        return false;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isRestrict() {
        return this.isRestrict;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public void setType(IType t) {
        this.type = t;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 4;
        if (this.isConst()) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.isVolatile()) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        if (this.isRestrict()) {
            firstBytes = (short)(firstBytes | 0x80);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CQualifierType(nested, (firstBytes & 0x20) != 0, (firstBytes & 0x40) != 0, (firstBytes & 0x80) != 0);
    }
}

