/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.core.runtime.CoreException;

public class IntegralValue
implements IValue {
    public static final int MAX_RECURSION_DEPTH = 25;
    public static final IntegralValue THIS = new IntegralValue("this".toCharArray());
    public static final IntegralValue UNKNOWN = new IntegralValue("<unknown>".toCharArray()){

        @Override
        public void setSubValue(int position, ICPPEvaluation newValue) {
            throw new UnsupportedOperationException();
        }
    };
    public static final IntegralValue ERROR = new IntegralValue("<error>".toCharArray());
    public static final IntegralValue NOT_INITIALIZED = new IntegralValue("<__>".toCharArray());
    private static final char UNIQUE_CHAR = '_';
    private static final IntegralValue[] TYPICAL = new IntegralValue[]{new IntegralValue(new char[]{'0'}), new IntegralValue(new char[]{'1'}), new IntegralValue(new char[]{'2'}), new IntegralValue(new char[]{'3'}), new IntegralValue(new char[]{'4'}), new IntegralValue(new char[]{'5'}), new IntegralValue(new char[]{'6'})};
    private static int sUnique = 0;
    private final char[] fFixedValue;

    private IntegralValue(char[] fixedValue) {
        this.fFixedValue = fixedValue;
    }

    @Override
    public Long numericalValue() {
        return (Long)this.numberValue();
    }

    @Override
    public final Number numberValue() {
        return IntegralValue.parseLong(this.fFixedValue);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return null;
    }

    @Override
    public final char[] getSignature() {
        return this.fFixedValue;
    }

    @Override
    @Deprecated
    public char[] getInternalExpression() {
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    @Deprecated
    public IBinding[] getUnknownBindings() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buf) throws CoreException {
        if (UNKNOWN == this) {
            buf.putShort((short)33);
        } else if (THIS == this) {
            buf.putShort((short)513);
        } else {
            Number num = this.numberValue();
            if (num != null) {
                long lv = num.longValue();
                if (lv >= 0L) {
                    buf.putShort((short)65);
                    buf.putLong(lv);
                } else {
                    buf.putShort((short)129);
                    buf.putLong(-lv);
                }
            } else {
                buf.putShort((short)257);
                buf.putCharArray(this.fFixedValue);
            }
        }
    }

    public static IValue unmarshal(short firstBytes, ITypeMarshalBuffer buf) throws CoreException {
        if (firstBytes == 0) {
            return UNKNOWN;
        }
        if ((firstBytes & 0x20) != 0) {
            return UNKNOWN;
        }
        if ((firstBytes & 0x40) != 0) {
            return IntegralValue.create(buf.getLong());
        }
        if ((firstBytes & 0x80) != 0) {
            return IntegralValue.create(-buf.getLong());
        }
        if ((firstBytes & 0x100) != 0) {
            return new IntegralValue(buf.getCharArray());
        }
        if ((firstBytes & 0x200) != 0) {
            return THIS;
        }
        return UNKNOWN;
    }

    public int hashCode() {
        return CharArrayUtils.hash(this.getSignature());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntegralValue)) {
            return false;
        }
        IntegralValue rhs = (IntegralValue)obj;
        return CharArrayUtils.equals(this.getSignature(), rhs.getSignature());
    }

    public String toString() {
        return new String(this.getSignature());
    }

    public static IntegralValue create(long value) {
        if (value >= 0L && value < (long)TYPICAL.length) {
            return TYPICAL[(int)value];
        }
        return new IntegralValue(IntegralValue.toCharArray(value));
    }

    public static IntegralValue create(boolean value) {
        return IntegralValue.create(value ? 1 : 0);
    }

    public static IValue incrementedValue(IValue value, int increment) {
        if (value == UNKNOWN) {
            return UNKNOWN;
        }
        Number val = value.numberValue();
        if (val != null) {
            return IntegralValue.create(val.longValue() + (long)increment);
        }
        ICPPEvaluation arg1 = value.getEvaluation();
        EvalFixed arg2 = new EvalFixed(CPPBasicType.INT, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(increment));
        return DependentValue.create(new EvalBinary(4, arg1, (ICPPEvaluation)arg2, arg1.getTemplateDefinition()));
    }

    public static int isTemplateParameter(IValue tval) {
        ICPPEvaluation eval = tval.getEvaluation();
        if (eval instanceof EvalBinding) {
            return ((EvalBinding)eval).getTemplateParameterID();
        }
        return -1;
    }

    public static boolean referencesTemplateParameter(IValue tval) {
        ICPPEvaluation eval = tval.getEvaluation();
        if (eval == null) {
            return false;
        }
        return eval.referencesTemplateParameter();
    }

    public static boolean isDependentValue(IValue nonTypeValue) {
        if (nonTypeValue == null) {
            return false;
        }
        ICPPEvaluation eval = nonTypeValue.getEvaluation();
        return eval != null && eval.isValueDependent();
    }

    public static IValue unique() {
        StringBuilder buf = new StringBuilder(10);
        buf.append('_');
        buf.append(++sUnique);
        return new IntegralValue(CharArrayUtils.extractChars(buf));
    }

    /*
     * Unable to fully structure code
     */
    private static Long parseLong(char[] value) {
        len = value.length;
        negative = false;
        result = 0L;
        i = 0;
        if (len > 0 && value[0] == '-') {
            negative = true;
            ++i;
        }
        if (i != len) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            if (result > 0xCCCCCCCCCCCCCCCL) {
                return null;
            }
            digit = value[i] - 48;
            if (digit < 0 || digit > 9) {
                return null;
            }
            result = result * 10L + (long)digit;
            ++i;
lbl17:
            // 2 sources

            ** while (i < len)
        }
lbl18:
        // 1 sources

        return negative != false ? -result : result;
    }

    private static char[] toCharArray(long value) {
        StringBuilder buf = new StringBuilder();
        buf.append(value);
        return CharArrayUtils.extractChars(buf);
    }

    @Override
    public final int numberOfSubValues() {
        return 1;
    }

    @Override
    public final ICPPEvaluation getSubValue(int index) {
        return EvalFixed.INCOMPLETE;
    }

    @Override
    public final ICPPEvaluation[] getAllSubValues() {
        return new ICPPEvaluation[]{this.getEvaluation()};
    }

    @Override
    public void setSubValue(int position, ICPPEvaluation newValue) {
        throw new IllegalStateException("Trying to set incomplete value");
    }

    @Override
    public IValue clone() {
        return new IntegralValue(Arrays.copyOf(this.fFixedValue, this.fFixedValue.length));
    }

    /* synthetic */ IntegralValue(char[] cArray, IntegralValue integralValue) {
        this(cArray);
    }
}

