/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import org.eclipse.cdt.core.settings.model.ACPathEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class CLibraryFileEntry
extends ACPathEntry
implements ICLibraryFileEntry {
    private final IPath fSourceAttachmentPath;
    private final IPath fSourceAttachmentRootPath;
    private final IPath fSourceAttachmentPrefixMapping;

    public CLibraryFileEntry(String name, int flags) {
        this(name, flags, null, null, null);
    }

    public CLibraryFileEntry(IPath location, int flags) {
        this(location, flags, null, null, null);
    }

    public CLibraryFileEntry(IFile rc, int flags) {
        this(rc, flags, null, null, null);
    }

    public CLibraryFileEntry(String name, int flags, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        super(name, flags);
        this.fSourceAttachmentPath = sourceAttachmentPath;
        this.fSourceAttachmentRootPath = sourceAttachmentRootPath != null ? sourceAttachmentRootPath : Path.EMPTY;
        this.fSourceAttachmentPrefixMapping = sourceAttachmentPrefixMapping != null ? sourceAttachmentPrefixMapping : Path.EMPTY;
    }

    public CLibraryFileEntry(IPath location, int flags, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        super(location, flags);
        this.fSourceAttachmentPath = sourceAttachmentPath;
        this.fSourceAttachmentRootPath = sourceAttachmentRootPath != null ? sourceAttachmentRootPath : Path.EMPTY;
        this.fSourceAttachmentPrefixMapping = sourceAttachmentPrefixMapping != null ? sourceAttachmentPrefixMapping : Path.EMPTY;
    }

    public CLibraryFileEntry(IFile rc, int flags, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        super((IResource)rc, flags);
        this.fSourceAttachmentPath = sourceAttachmentPath;
        this.fSourceAttachmentRootPath = sourceAttachmentRootPath != null ? sourceAttachmentRootPath : Path.EMPTY;
        this.fSourceAttachmentPrefixMapping = sourceAttachmentPrefixMapping != null ? sourceAttachmentPrefixMapping : Path.EMPTY;
    }

    @Override
    public final int getKind() {
        return 32;
    }

    @Override
    public final boolean isFile() {
        return true;
    }

    @Override
    public IPath getSourceAttachmentPath() {
        return this.fSourceAttachmentPath;
    }

    @Override
    public IPath getSourceAttachmentPrefixMapping() {
        return this.fSourceAttachmentPrefixMapping;
    }

    @Override
    public IPath getSourceAttachmentRootPath() {
        return this.fSourceAttachmentRootPath;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fSourceAttachmentPath == null ? 0 : this.fSourceAttachmentPath.hashCode());
        result = 31 * result + (this.fSourceAttachmentPrefixMapping == null ? 0 : this.fSourceAttachmentPrefixMapping.hashCode());
        result = 31 * result + (this.fSourceAttachmentRootPath == null ? 0 : this.fSourceAttachmentRootPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.sourceAttachmentSettingsEqual((CLibraryFileEntry)other);
    }

    @Override
    public boolean equalsByContents(ICSettingEntry entry) {
        if (entry == this) {
            return true;
        }
        if (!super.equalsByContents(entry)) {
            return false;
        }
        return this.sourceAttachmentSettingsEqual((CLibraryFileEntry)entry);
    }

    private boolean sourceAttachmentSettingsEqual(CLibraryFileEntry otherEntry) {
        if (!CDataUtil.objectsEqual(this.fSourceAttachmentPath, otherEntry.fSourceAttachmentPath)) {
            return false;
        }
        if (!CDataUtil.objectsEqual(this.fSourceAttachmentRootPath, otherEntry.fSourceAttachmentRootPath)) {
            return false;
        }
        return CDataUtil.objectsEqual(this.fSourceAttachmentPrefixMapping, otherEntry.fSourceAttachmentPrefixMapping);
    }

    @Override
    protected String contentsToString() {
        String result = super.contentsToString();
        if (this.fSourceAttachmentPath != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(result);
            buf.append(" ; srcPath=").append(this.fSourceAttachmentPath);
            buf.append("; srcRoot=").append(this.fSourceAttachmentRootPath);
            buf.append("; srcMapping=").append(this.fSourceAttachmentPrefixMapping);
            result = buf.toString();
        }
        return result;
    }
}

