/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.jobs;

import java.util.ArrayList;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public abstract class CommonJob {
    private static Manager commonJobManager = new Manager();
    private String name;
    private Thread thread = null;
    private ISchedulingRule schedulingRule = null;
    private volatile int flags = 0;
    private static final int M_SYSTEM = 256;
    private static final int M_USER = 512;

    public CommonJob(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private final IStatus runInThread(IProgressMonitor monitor) {
        IStatus result = null;
        try {
            this.thread = Thread.currentThread();
            result = monitor.isCanceled() ? Status.CANCEL_STATUS : this.runInCommonThread(monitor);
        }
        finally {
            if (result == null) {
                result = new Status(4, "org.eclipse.core.jobs", JobMessages.jobs_error);
            }
        }
        return result;
    }

    public final void schedule() {
        this.schedule(0L);
    }

    public final void schedule(long delay) {
        commonJobManager.execute(this, delay);
    }

    public boolean isSystem() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isUser() {
        return (this.flags & 0x200) != 0;
    }

    public void setUser(boolean value) {
        this.flags = value ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
    }

    public void setSystem(boolean value) {
        this.flags = value ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
    }

    public final ISchedulingRule getRule() {
        return this.schedulingRule;
    }

    public final void setRule(ISchedulingRule rule) {
        this.schedulingRule = rule;
    }

    public final Thread getThread() {
        return this.thread;
    }

    public abstract IStatus runInCommonThread(IProgressMonitor var1);

    private static class ExecuteContext {
        CommonJob commonJob;
        long schedulingTime;

        public ExecuteContext(CommonJob job, long schedulingTime) {
            this.commonJob = job;
            this.schedulingTime = schedulingTime;
        }

        public IStatus run(IProgressMonitor monitor) {
            return this.commonJob.runInThread(monitor);
        }
    }

    private static class Manager {
        Job job;
        Job executionJob;
        ArrayList scheduledContextList = new ArrayList();
        ExecuteContext executionContext = null;

        public Manager() {
            this.job = new Job(JobMessages.jobs_commonJob){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    ArrayList<ExecuteContext> pendingContexes = new ArrayList<ExecuteContext>();
                    long earliestPendingContextSchedulingTime = Long.MAX_VALUE;
                    boolean done = false;
                    while (!done) {
                        ExecuteContext context = null;
                        ArrayList arrayList = Manager.this.scheduledContextList;
                        synchronized (arrayList) {
                            if (Manager.this.scheduledContextList.isEmpty()) {
                                done = true;
                            } else {
                                context = (ExecuteContext)Manager.this.scheduledContextList.remove(0);
                            }
                        }
                        if (context == null) continue;
                        long currentTime = System.currentTimeMillis();
                        if (context.schedulingTime < currentTime) {
                            try {
                                Manager.this.executionJob.join();
                            }
                            catch (InterruptedException interruptedException) {}
                            Manager.this.executionContext = context;
                            Manager.this.executionJob.setName(context.commonJob.getName());
                            Manager.this.executionJob.setSystem(context.commonJob.isSystem());
                            Manager.this.executionJob.setUser(context.commonJob.isUser());
                            Manager.this.executionJob.setRule(context.commonJob.getRule());
                            Manager.this.executionJob.schedule();
                            this.setName(context.commonJob.getName());
                            continue;
                        }
                        pendingContexes.add(context);
                        earliestPendingContextSchedulingTime = Math.min(context.schedulingTime, earliestPendingContextSchedulingTime);
                    }
                    if (!pendingContexes.isEmpty()) {
                        ArrayList arrayList = Manager.this.scheduledContextList;
                        synchronized (arrayList) {
                            Manager.this.scheduledContextList.addAll(pendingContexes);
                            this.schedule(Math.max(0L, earliestPendingContextSchedulingTime - System.currentTimeMillis()));
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.job.setUser(false);
            this.job.setSystem(true);
            this.executionJob = new Job(JobMessages.jobs_commonJobDelegate){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IStatus iStatus = Manager.this.executionContext.run(monitor);
                        return iStatus;
                    }
                    finally {
                        Manager.this.executionContext = null;
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(CommonJob commonJob, long delay) {
            ArrayList arrayList = this.scheduledContextList;
            synchronized (arrayList) {
                this.scheduledContextList.add(new ExecuteContext(commonJob, System.currentTimeMillis() + delay));
            }
            this.job.schedule(delay);
        }
    }
}

