/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _WEIGHSCALE_H_
#define _WEIGHSCALE_H_

/*******************************************************************************
 * Definitions
 ******************************************************************************/

#if defined(USB_DEVICE_CONFIG_EHCI) && (USB_DEVICE_CONFIG_EHCI > 0)
#define CONTROLLER_ID kUSB_ControllerEhci0
#endif
#if defined(USB_DEVICE_CONFIG_KHCI) && (USB_DEVICE_CONFIG_KHCI > 0)
#define CONTROLLER_ID kUSB_ControllerKhci0
#endif
/*! @brief USB interrupt priority */
#define USB_DEVICE_INTERRUPT_PRIORITY (3U)
/*! @brief Association request length */
#define ASSOCIATION_REQUEST_LENGTH (54U)
/*! @brief Configuration event report length */
#define EVENT_REPORT_CONFIGURATION_LENGTH (166U)
/*! @brief DIM get response length */
#define EVENT_RESPONSE_GET_LENGTH (114U)
/*! @brief DIM data transfer length */
#define EVENT_REPORT_DATA_LENGTH (94U)
/*! @brief Weight scale application event */
#define APP_EVENT_SEND_ASSOCIATION_REQUEST (0x00U)
#define APP_EVENT_SEND_DEVICE_CONFIGURATION (0x01U)
#define APP_EVENT_SEND_MDS_OBJECT (0x02U)
#define APP_EVENT_SEND_MEASUREMENT_DATA (0x03U)
#define APP_EVENT_UNDEFINED (uint8_t) - 1

/* structure for the measurements that are changing */
typedef struct _weightscale_measurement_struct
{
    uint16_t weight[2U];        /*!< body weight */
    uint16_t bodyMassIndex[2U]; /*!< body mass index */
} weightscale_measurement_struct_t;
#endif /* _WEIGHSCALE_H_ */
