/*****************************************************************************  
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************/
// JavaScript Document
 //general variables
var index;
var j;
var value =0;
var aux;
var b_back_status = 0;
var Reg0 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x00); // ISRhi
var Reg1 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x01); //ISRlo
var Reg2 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x02); // IVR
var Reg3 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x04); //VCR
var Reg4 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x05); //VSR
var Reg5 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x08); //LXR
var Reg6 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x09); //LXCR
var Reg7 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x10); //WDR 
var Reg8 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x11); //WDSR 
var Reg9 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x12); //WCR 
var Reg10 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x13); //TCR 
var Reg11 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x14); //WSR 
var Reg12 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x15); //RSR 
var Reg13 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x16); //MCR 
var Reg14 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x18); //LINR 
var Reg15 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x20); //PTBC1 
var Reg16 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x21); //PTBC2 
var Reg17 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x22); //PTB 
var Reg18 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x28); //B_HSCR 
var Reg19 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x29); //B_HSSR 
var Reg20 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x30); //B_LSCR 
var Reg21 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x31); //B_LSSR
var Reg97 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x32); //B_LSCEN ******
var Reg22 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x38); //HSR 
var Reg23 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x3C); //CSR 
var Reg24 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x40); //SCIBDhi 
var Reg25 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x41); //SCIBDlo 
var Reg26 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x42); //SCIC1 
var Reg27 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x43); //SCIC2 
var Reg28 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x44); //SCIS1 
var Reg29 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x45); //SCIS2 
var Reg30 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x46); //SCIC3 
var Reg31 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x47); //SCID 
var Reg55 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x60); //PWMCTL 
var Reg56 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x61); //PWMPRCLK 
var Reg57 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x62); //PWMSCLA 
var Reg58 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x63); //PWMSCLB 
var Reg59 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x64); //PWMCNT0 
var Reg60 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x65); //PWMCNT1
var Reg61 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x66); //PWMPER0
var Reg62 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x67); //PWMPER1
var Reg63 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x68); //PWMDTY0
var Reg64 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x69); //PWMDTY1
var Reg65 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x80); //ACR
var Reg66 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x81); //ASR
var Reg67 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x82); //ACCRhi
var Reg68 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x83); //ACCRlo
var Reg69 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x84); //ACCSRhi
var Reg70 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x85); //ACCSRlo
var Reg71 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x86); //ADR0hi
var Reg72 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x87); //ADR0lo
var Reg73 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x88); //ADR1hi
var Reg74 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x89); //ADR1lo
var Reg75 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8A); //ADR2hi
var Reg76 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8B); //ADR2lo
var Reg77 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8C); //ADR3hi
var Reg78 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8D); //ADR3lo
var Reg79 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8E); //ADR4hi
var Reg80 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8F); //ADR4lo
var Reg81 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x90); //ADR5hi
var Reg82 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x91); //ADR5lo
var Reg83 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x92); //ADR6hi
var Reg84 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x93); //ADR6lo
var Reg85 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x94); //ADR7hi
var Reg86 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x95); //ADR7lo
var Reg87 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x96); //ADR8hi
var Reg88 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x97); //ADR8lo
var Reg89 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x98); //ADR9hi
var Reg90 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x99); //ADR9lo
var Reg91 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9A); //ADR10hi
var Reg92 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9B); //ADR10lo
var Reg93 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9C); //ADR11hi
var Reg94 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9D); //ADR11lo
var Reg95 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xA4); //ADR15hi
var Reg96 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xA5); //ADR15lo
var Reg32 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC0); //TIOS
var Reg33 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC1); //CFORC
var Reg34 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC2); //OC3M
var Reg35 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC3); //OC3D
var Reg36 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC4); //TCNThi
var Reg37 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC5); //TCNTlo
var Reg38 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC6); //TSCR1
var Reg39 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC7); //TTOV
var Reg40 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC8); //TCTL1 
var Reg41 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC9); //TCTL2 
var Reg42 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCA); //TIE 
var Reg43 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCB); //TSCR2 
var Reg44 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCC); //TFLG1 
var Reg45 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCD); //TFLG2 
var Reg46 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCE); //TC0hi
var Reg47 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCF); //TC0lo 
var Reg48 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD0); //TC1hi
var Reg49 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD1); //TC1lo
var Reg50 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD2); //TC2hi
var Reg51 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD3); //TC2lo
var Reg52 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD4); //TC3hi
var Reg53 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD5); //TC3lo
var Reg54 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD6); //TIMTST
var AllRegisters = new Array(Reg0,Reg1,Reg2,Reg3,Reg4,Reg5,Reg6,Reg7,Reg8,Reg9,Reg10,Reg11,Reg12,Reg13,Reg14,Reg15,Reg16,Reg17,Reg18,Reg19,Reg20,Reg21,Reg22,Reg23,Reg24,Reg25,Reg26,Reg27,Reg28,Reg29,Reg30,Reg31,Reg32,Reg33,Reg34,Reg35,Reg36,Reg37,Reg38,Reg39,Reg40,Reg41,Reg42,Reg43,Reg44,Reg45,Reg46,Reg47,Reg48,Reg49,Reg50,Reg51,Reg52,Reg53,Reg54,Reg55,Reg56,Reg57,Reg58,Reg59,Reg60,Reg61,Reg62,Reg63,Reg64,Reg65,Reg66,Reg67,Reg68,Reg69,Reg70,Reg71,Reg72,Reg73,Reg74,Reg75,Reg76,Reg77,Reg78,Reg79,Reg80,Reg81,Reg82,Reg83,Reg84,Reg85,Reg86,Reg87,Reg88,Reg89,Reg90,Reg91,Reg92,Reg93,Reg94,Reg95,Reg96,Reg97);
// variables supported User_friendly control panel3
duty = 0;
frequency = 0;
duty_ch0 = 0;
frequency_ch0 = 0;
duty_ch1 = 0;
frequency_ch1 = 0;
//------------------------------------------------------------------------------
function tabs(view,hideA,hideB,hideC,hideD,hideE,index)

{
    view.style.visibility = "visible";
    view.style.display = "block";
    hideA.style.visibility = "hidden";
    hideB.style.visibility = "hidden";
    hideC.style.visibility = "hidden";
    hideD.style.visibility = "hidden";
    hideE.style.visibility = "hidden";
    hideA.style.display = "none";
    hideB.style.display = "none";
    hideC.style.display = "none";
    hideD.style.display = "none";
    hideE.style.display = "none";
    for (i=1;i<=6;i++)
    { 
      aux = document.getElementById("visible_"+i);     
      aux.style.visibility = "hidden";     
      if (index == i)
      {
        aux.style.visibility = "visible";
      } 
    }
}
//------------------------------------------------------------------------------
function btclick(bitname,register,bit)
{
 if (register[bit] == 1) register[bit] = 0;
    else register[bit] = 1;
 if (register[bit] == 1)
    document.getElementById("bit_"+bitname).className = "BT_1";
 else
    document.getElementById("bit_"+bitname).className = "BT_0";
 AllRegisters[register] = register;
 
}
//------------------------------------------------------------------------------

function array_to_integer(data_in_array)  // converts to binary format 0bxxxxxxxx
{ 
  var temp=" ";//="0b";
  var temp1;
  for (i=7; i>=0; i--)
  {
    temp = temp + data_in_array[i]
  }
  temp1 = parseInt(temp,2);
  return(temp1)
}
//------------------------------------------------------------------------------

function read_all()
{

   var bit=0;
   var temp =" ";
   //loading data from the target to the PC
   for (index=0; index <= AllRegisters.length - 1; index++)
   {
      read(AllRegisters[index]);
   }

   //vizualization of all registers from the PC memory
   for (index=0; index <= AllRegisters.length - 1; index++)  
   {
    for (bit=0;bit<=7; bit++)
    {
    temp = "bit_Reg"+index+bit; 

    if (AllRegisters[index][bit] == 0)
      {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_0";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_0";
      }  
    else
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_1";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_1";
    }
    }
   }

}
//------------------------------------------------------------------------------

function read(register)
{
var temp;
var temp1;
var size;
var i;
var aux_array = new Array(0, 0, 0, 0, 0, 0, 0, 0);
// here the code for loading data from the target to the PC variable
    temp1 = 0x200+register[8];
    //alert(temp1);
    write_fmaster_variable("fm_register.fm_address", temp1);
    write_fmaster_variable("fm_register.fm_read_write", 0);
    write_fmaster_variable("fm_register.fm_status", 1); //request pending
    temp1 = 1;
    while (temp1 == 1)  //waiting until the value is updated by MCU
    {
      read_variable("fm_register.fm_status");
      temp1 = value;
    }
    read_variable("fm_register.fm_data");
    temp1 = value;
    temp = temp1.toString(2); //we need binary representation
    size = temp.length;
    for (i=0;i<(8-size);i++)  //fill left zeroes
    {
      temp="0"+temp;
    }
    for (i=0;i<8;i++)
    {
      aux_array[7-i] = temp.substring(i,i+1);
    }
    for (i=0;i<8;i++)
    {
      register[i] = aux_array[i];
    }   
}
//------------------------------------------------------------------------------

// visualization
function readclick(register,registername)
{
//  alert(register);
  read(register);
  for (i=0;i<=7;i++)
  {
  temp = "bit_"+registername+i;
  if (register[i] == 0)
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_0";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_0";
    }
  else
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_1";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_1";
    }
  } //end of "for" 
}
//------------------------------------------------------------------------------
function writeclick(register,registername)
{
    var temp;
    temp = 0x200+register[8];
    write_fmaster_variable("fm_register.fm_read_write", 1);
    write_fmaster_variable("fm_register.fm_address", temp);
    //write_fmaster_variable("fm_register.fm_data", array_to_integer(register));
    write_fmaster_variable("fm_register.fm_data", array_to_integer(register));
    write_fmaster_variable("fm_register.fm_status", 1); //request pending
    readclick(register,registername); // because other bits can be changed by writing to the register 
     
    
}
//------------------------------------------------------------------------------

/*<!--**************************************************************************
* Function:       B_back_onMouseDown
* Description:    Click on the Back button. 
* Returns:        None
* Note:           Animate push down button.
***************************************************************************-->*/ 
function B_back_onMouseDown()
{
  document.images['B_back'].src='src/back2.jpg';
  b_back_status = 1;

}
/*<!--**************************************************************************
* Function:       B_back_onMouseUp
* Description:    Pull up Back button . 
* Returns:        None
* Note:           If is mouse pull down on the Back button then open port and 
*                 clear all SPI registers, delete cookie file and leave control 
*                 page.
***************************************************************************-->*/ 
function B_back_onMouseUp()
{

  document.images['B_back'].src='src/back1.jpg';
  b_back_status = 0;
/*
  if(b_back_status == 1)
  {
  if(B_LIN_status){alert("Please close port before leaving control page!");}
  else
  {
   if(lin.OpenPort(port.value, 9600))
   {
    Reset_SPI_Array();
    B_SEND14_onclick();
    B_SEND13_onclick();
    B_SEND12_onclick();
	  B_SEND10_onclick();
	  B_SEND8_onclick();
	  B_SEND6_onclick();
	  B_SEND4_onclick();
	  B_SEND2_onclick();
	  B_SEND0_onclick();
	    
	  ClosePort();
   }   
   CreateCookie('Levantar',"",-1);
   window.history.back();
  }
  }*/
}
//****************************************************************************************
//****************************************************************************************

//****************************************************************************************
//          ** **   Functions supporting the UserFriendly control panel **  **
//****************************************************************************************

//****************************************************************************************
//****************************************************************************************

function PWM_selection_onclick(channel)
{
  
}
//----------------------------------------------------------------------------

function PWM_enable0_onclick(status)
{
  if (status == 0)
  { //disable module
      Reg55[7] = 0;
      writeclick(Reg55);
      alert();  
  }
}

//----------------------------------------------------------------------------

function On_Pwm_Duty_change()		
{
	duty = sld_pwm_duty.Value * (frequency / 100); 	

}
//----------------------------------------------------------------------------
function On_Pwm_Freq_change()			
{
	if (range == 1)
	{
	 frequency = 3000000 / sld_pwm_freq.Value;
	}
	if (range == 2)
	{
	 frequency = 1250000 / sld_pwm_freq.Value;
	}
	if (range == 3)
	{
	 frequency = 247664 / sld_pwm_freq.Value;
	}
	if (range == 5)
	{
   frequency = 99111 / sld_pwm_freq.Value;
	}
	if (range == 6)
	{
	 frequency = 20000 / sld_pwm_freq.Value;
	}
	if (range == 7)
	{
 	 frequency = 7704.4 / (sld_pwm_freq.Value);
	}
	On_Pwm_Duty_change();
}


//******************************************************************************
//                   ****** FreeMaster functions ******
//******************************************************************************

function write_fmaster_variable(varname, value)
{
    var succ = FreeMaster.WriteVariable(varname, value);
}
//----------------------------------------------------------------------------

function read_variable(varname)
{
    var succ = read_fmaster_variable(varname);
    if(succ)
   {
        value = FreeMaster.LastVariable_vValue;
   }
}
//----------------------------------------------------------------------------
function read_fmaster_variable(varname)
{
    var succ = FreeMaster.ReadVariable("!" + varname);
    return succ;
}