#include "1.2_AN_Diagch1.def";
*********************************************************************************
*                                               Copyright (c) Freescale 2014    *
* File Name: Pierre_test_4inj.dfi                                               *
* Current Revision: 1.0                                                         *
* Purpose: MC33816 example - 1 Bank diagnostic                                  *
* Description:  MC33816 Channel 1 main function provide peak and hold current   *
*               profile for Uc0Ch1 and use idle and automatic diagnostics       *
*                                                                               *
* REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                              *
* ---  ------    --------    ---------------------                              *
* 1.0  b16868    2014/03/25     - initial coding                                *
*                                                                               *
*********************************************************************************

*********************************************************************************
* Freescale reserves  the right to make  changes without  further notice to any *
* product herein to improve  reliability, function,  or design.  Freescale does *
* not  assume  any  liability  arising  out of  the application  or use  of any *
* product, circuit,  or software described herein;  neither does  it convey any *
* license under its patent rights nor the rights of others.  Freescale products *
* are not designed, intended,  or authorized for use as  components  in systems *
* intended for  surgical implant into the body,  or other applications intended *
* to support life,  or for any other  application  in which the failure  of the *
* Freescale product could create a situation where  personal injury or death may*
* occur.  Should Buyer purchase or use Freescale products for any such intended *
* or unauthorized  application,  Buyer shall indemnify and  hold  Freescale and *
* its officers, employees, subsidiaries, affiliates,  and distributors harmless *
* against all claims costs, damages, and expenses, and reasonable attorney  fees*
* arising  out of,  directly or indirectly,  any claim  of personal  injury  or *
* death  associated  with  such unintended  or unauthorized use,  even if  such *
* claim  alleges  that  Freescale   was  negligent   regarding   the  design  or*
* manufacture  of the part.  Freescale and the  Freescale logo  are registered  *
* trademarks of Freescale Ltd.                                                  *
*********************************************************************************



* ### Channel 1 - uCore0 controls the injectors 1 ###



* Constant definition
#define HSBoost_B1 hs2;
#define HSBAT_B1 hs1;
#define LS1_B1 ls1;
#define LS2_B1 ls2;

*################## STATUS REGISTER ##############
* This bit must be set to 1 if the Iboost current is never reached during the boost phase
#define BoostErrorBit b5;
* This bit must be set to 1 the sequencer is currently executing the Automatic interrupt routine
#define AutoIrqBit b6;
* This bit must be set to 1 the sequencer is currently executing the Idle Diag interrupt routine
#define IdleIrqBit b7;
* This bit must be set to 1 if start pin stays high longer than 10ms
#define HoldErrorBit b4;


*################## FLAGS ##############
* This flag is sent to the DCDC sequencer. It must be active for the whole period the boost voltage is used
* When the boost voltage is used, the DCDC must be deactivated
* flag = 0 => boost voltage is used, DCDC must be deactivated
* flag = 1 => boost voltage not used, DCDC can be active
#define BstFlag b0;


*################## CONTROL REGISTER ##############
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define AutoDiagResetBit b6;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define IdleDiagResetBit b7;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define BoostResetBit b5;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define HoldResetBit b4;



*################## ALU registers  ################
#define IRQ_stat_Reg r0;




  
*********************************************************************************************************            
*                                        AUTOMATIC INTERUPT                                             *            
********************************************************************************************************* 
irq_auto:       stos off off off;                       * Disable drivers
                endiaga diagoff;                        * Disable automatic diagnostic
                stirq low;                              * Set the low IRQB pin
                stf high BstFlag;                       * Set flag0 high DCDC active
                stsrb high AutoIrqBit;                  * Set status register bit 6 when automatic diagnosis interrupt trig

auto_waitEnable:jcrr auto_waitEnable AutoDiagResetBit low;  * the sequencer is stuck here until the bit of the control register is set to '1' b6
                ldjr1 restore;                          * Load restore to jr1 to do a jump far               
                jmpf jr1;                               * Jump to restore
                
                

*********************************************************************************************************            
*                                         SOFTWARE INTERUPT                                             *            
********************************************************************************************************* 
irq1_sw:        stos off off off;                       * Disable drivers
                endiaga diagoff;                        * Disable automatic diagnostic
                stirq low;                              * Set low the IRQB pin
                stf high BstFlag;                       * Set flag0 high to release the DC-DC converter idle mode
                
                * Check which Sw interrupt occured BoostErr 0 or Idle Diag Fail 1
                cp irq IRQ_stat_Reg;                    * copy the irq status registers to a temp ALU reg
                                                        * This register contains also the sw irq ID
                ldirh 0Ch rst;                          * load MSB in ir reg: 0x0C00 in immediate register, to use as mask for irq status                                        
                and IRQ_stat_Reg;                       * extract the sw id from irq status register (bits 11-10)
                jarr Boost_waitEN all0;                 * if the sw id is 0 => Iboost never reached => go to Boost_waitEN
                                                        * Else => error detected in idle diag=> go to next line => seq stuck until micro write 1 in control register b8                                                        

                                                        
                ldirh 08h rst;                          * load MSB in ir reg: 0x0800 in immediate register, to use as mask for irq status  
                and IRQ_stat_Reg;                       * extract the sw id from irq status register (bits 11-10)
                jarr sw_waitEnable all0;                  * if the sw id is 0 => Means IRQ = b01 => Idle diagnostics fails
                                                        * Else => Hold error => go to next line => idle diag fail                                                      

                                                        
Hold_waitEN:    stsrb high HoldErrorBit;                * Start pin stays higher longer than 10ms
                jcrr Hold_waitEN HoldResetBit low;      * Wait here until control bit register is write to 1   
                jmpr restore;
                
sw_waitEnable:  stsrb high IdleIrqBit;                  * IDle diag fail we set status b8 high to let user know which error occured
                jcrr sw_waitEnable IdleDiagResetBit low;* Wait here until control bit register is write to 1 
                jmpr restore;
                
                
Boost_waitEN:   stsrb high BoostErrorBit;               * Iboost never reached, let user know by setting status register bit b5               
                jcrr Boost_waitEN BoostResetBit low;    * Wait here until control bit register is write to 1

                   
                
restore:        stirq high;                             * Set high IRQB pin
                rstreg all;                             * Reset a) control registers
                                                        *       b) status regsiter
                                                        *       c) err_seq register (status of automatic diagnosis  
                                                        *       d) re-enables irq generation from automatic diagnosis
                iret restart rst;                       * Clear interrupt queue and restart from init phase


                
                
*********************************************************************************************************            
*                                         INIT PHASE
********************************************************************************************************* 
init0:      stirq high;                             * Set high IRQB pin
            stgn gain8.68 sssc;                 * Set gain amplifier for current feedback 1
            ldjr1 eoinj0;                        * Turn OFF all actuators
            ldjr2 idle0;                        * Tturn OFF all actuators
            cwef jr1 _start row1;               * If any start goes low go to eoi
   
            
*********************************************************************************************************            
*                                         IDLE PHASE                                                    *            
********************************************************************************************************* 
idle0:      joslr inje1 start1;                 * Start inejctor 1 if start1 goes high
            joslr inje2 start2;                 * Start injector 2 if start2 goes high
            jmpf jr1;
            
            
            
*********************************************************************************************************            
*                                         SHORTCUT DEFINITION                                           *            
********************************************************************************************************* 
inje1:      dfsct HSBAT_B1 LS1_B1 HSBoost_B1;      * Shortcut1 = HSVBAT, Shortcut2= LS, Shortcut3= HSBOOST
            dfcsct dac1;                          * use current feedback1
            jmpr idle_diag0;                      * Jump to idle_diag0 (useless here)


inje2:      dfsct HSBAT_B1 LS2_B1 HSBoost_B1;      * Shortcut1 = HSVBAT, Shortcut2= LS, Shortcut3= HSBOOST
            dfcsct dac1;                          * use current feedback1
            jmpr idle_diag0;                      * Jump to idle_diag0 (useless here) 
            

*********************************************************************************************************            
*                                    PRE-ACTUATION DIAG PHASE                                           *            
********************************************************************************************************* 
idle_diag0:     bias all on;                            * Enable all biasing structures, kept ON even during actuation
                jocr idle_diag_fail0 _sc1v;             * Error detected if Vds of shortcut1 (HS) is low
                jocr idle_diag_fail0 _sc2v;             * Error detected if Vds of shortcut2 (LS) is low
                jocr idle_diag_fail0 _sc3v;             * Error detected if Vds of shortcut3 (Boost) is low
                jocr idle_diag_fail0 _sc1s;             * Error detected if Vsrc of shortcut1 (HS) is low
                jocr idle_diag_fail0 _sc3s;             * Error detected if Vsrc of shortcut3 (Boost) is low TO CHECK WHY VSRC NTO WORKING ???
                jmpr boost0;                            * Jump to actuation phase if no failure detected in idle phase
               
                
idle_diag_fail0:reqi 1;                            * Go to software subroutine is fault detected in idle phase HSBat error
                



*********************************************************************************************************            
*                                                 BOOST PHASE                                           *            
********************************************************************************************************* 
            

boost0:     ldcd rst _ofs keep keep injMaxTBoost c3;       * Start Boost Counter
            load Iboost dac_sssc _ofs;                    * Load Boost current threshold

            cwer peak0 cur1 row2;                          * Define Wait Table Iboost is reached and jump to peak phase
            cwer boost_err0 tc3 row5;                      * Define Wait Table if actuation longer than injMaxGuard go to eoinj (added from AN4849)
            
            stf low BstFlag;                              * Turn OFF the boost during this phase
            stos on on on;                                * Vbat high side On, Vboost HS On et LS1/2 ON, need to turn ON HS1 also to avoid diag failure    
            endiags on on on on;                        * ONLY ENABLED VDS VBAT AND VDS VBOOST FOR CQI
    
            wait row125;                                   * Wait start goes low or Iboost reached or InjMaxTBoost reached
            
            
boost_err0: reqi 0;                                        * Go to software subroutine is fault detected in Boost phase, did not reach Iboost on time (added from AN4849)

*********************************************************************************************************            
*                                                 PEAK PHASE                                            *            
********************************************************************************************************* 


peak0:      ldcd rst _ofs keep keep Tpeak_tot c1;           * Start Tpeak tot counter
            stf high BstFlag;                               * Turn Boost back on
            load Ipeak dac_sssc _ofs;                       * Load the peak current threshold in the current DAC            
            cwer bypass0 tc1 row2;                          * Jump to bypass phase when tc1 reaches end of count            
            cwer peak_on0 tc2 row3;                         * Jump to peak_on when tc2 reaches end of count         
            cwer peak_off0 ocur row4;                       * Jump to peak_off when current is over threshold
            
peak_on0:   stos on on off;                                 * Vbat On LS On, if needed Boost HS can stay ON during this phase
            wait row124;
            
peak_off0:  ldcd rst ofs keep keep Tpeak_off c2;            * Load in the counter 2 the length of the peak_off phase
            stos off on off;                                * turn OFF HSvbat keep LS ON
            wait row123;                                        
            
            
            


*********************************************************************************************************            
*                                                 BYPASS PHASE                                          *            
********************************************************************************************************* 

bypass0:    ldcd rst ofs keep keep Tbypass c3;            * Load in the counter 3 the length of the off_phase phase
            stos off off off;                              * turn OFF all HS LS1/2
            cwer hold0 tc3 row4;                             * Jump to hold when tc3 reaches end of count
            wait row14;
            
            
*********************************************************************************************************            
*                                                 HOLD PHASE                                            *            
********************************************************************************************************* 

hold0:      ldcd rst _ofs keep keep Thold_tot c1;        * load thold tot inside c1
            load Ihold dac_sssc _ofs;                   * load hold current inside DAC
            cwer hold_error0 tc1 row2;                    * after thold tot go to end of injection
            cwer hold_on0 tc2 row3;                       * after thold off turn on hs
            cwer hold_off0 cur1 row4;                     * when curren tis reached turn off hs
            
hold_on0:   stos on on off;                               * HSvbat ON, LS ON
            wait row124;
            
hold_off0:  ldcd rst _ofs keep keep Thold_off c2;        * load thold off inside c2 
            stos off on off;                               * LS ON
            wait row123;
            
            
 
hold_error0: reqi 2;                                        * If Start high is longer than Thold_tot go to sw interrupt
     
*********************************************************************************************************            
*                                     END OF INJECTION PHASE                                            *            
********************************************************************************************************* 

eoinj0:     stos off off off;
            endiags off off off off;                      * disable auto diag
            stf high BstFlag;                             * turn ON DCDC
            jmpf jr2;                                     * jump to idle
            
            
*###########################################################################
*##########################################################################


*********************************************************************************

* ### Channel 1 - uCore1 controls injectors 3 and 4 without diagnostics ###

* ### Variables declaration  ###

* Note: The data that defines the profiles are shared between the two microcores.

* ### Initialization phase ###
init1:      stgn gain8.68 sssc;                     * Set the gain of the opamp of the current measure block 2
            ldjr1 eoinj1;                           * Load the eoinj line label Code RAM address into the register jr1 
            ldjr2 idle1;                            * Load the idle line label Code RAM address into the register jr2
            cwef jr1 _start row1;                   * If the start signal goes low, go to eoinj phase
            

* ### Idle phase- the uPC loops here until start signal is present ###              
idle1:      joslr inj3_start start3;                * Perform an actuation on inj3 if start 3 (only) is active
            joslr inj4_start start4;                * Perform an actuation on inj4 if start 4 (only) is active
            jmpf jr1;                               * If more than 1 start active at the same time(or none), no actuation

* ### Shortcuts definition per the injector to be actuated ###
inj3_start: dfsct hs3 hs4 ls3;                      * Set the 3 shorcuts : VBAT, VBOOST, LS
            jmpr boost1;                            * Jump to launch phase

inj4_start: dfsct hs3 hs4 ls4;                      * Set the 3 shorcuts : VBAT, VBOOST, LS
            jmpr boost1;                            * Jump to launch phase

* ### Launch phase enable boost ###
boost1:     load Iboost dac_sssc _ofs;              * Load the boost phase current threshold in the current DAC
            cwer peak1 ocur row2;                   * Jump to peak phase when current is over threshold
            stf low b0;                             * set flag0 low to force the DC-DC converter in idle mode
            stos off on on;                         * Turn VBAT off, BOOST on, LS on
            wait row12;                             * Wait for one of the previously defined conditions

* ### Peak phase continue on Vbat ###
peak1:      ldcd rst _ofs keep keep Tpeak_tot c1;   * Load the length of the total peak phase in counter 1
            load Ipeak dac_sssc _ofs;               * Load the peak current threshold in the current DAC
            cwer bypass1 tc1 row2;                  * Jump to bypass phase when tc1 reaches end of count
            cwer peak_on1 tc2 row3;                 * Jump to peak_on when tc2 reaches end of count
            cwer peak_off1 ocur row4;               * Jump to peak_off when current is over threshold
            stf high b0;                            * set flag0 high to release the DC-DC converter idle mode
            
peak_on1:   stos on off on;                         * Turn VBAT on, BOOST off, LS on
            wait row124;                            * Wait for one of the previously defined conditions

peak_off1:  ldcd rst ofs keep keep Tpeak_off c2;    * Load in the counter 2 the length of the peak_off phase
            stos off off on;                        * Turn VBAT off, BOOST off, LS on
            wait row123;                            * Wait for one of the previously defined conditions
            
* ### Bypass phase ###
bypass1:    ldcd rst ofs keep keep Tbypass c3;      * Load in the counter 3 the length of the off_phase phase
            stos off off off;                       * Turn VBAT off, BOOST off, LS off
            cwer hold1 tc3 row4;                    * Jump to hold when tc3 reaches end of count
            wait row14;                             * Wait for one of the previously defined conditions
            
* ### Hold phase on Vbat ###    
hold1:      ldcd rst _ofs keep keep Thold_tot c1;   * Load the length of the total hold phase in counter 2 
            load Ihold dac_sssc _ofs;               * Load the hold current threshold in the DAC
            cwer eoinj1 tc1 row2;                   * Jump to eoinj phase when tc1 reaches end of count
            cwer hold_on1 tc2 row3;                 * Jump to hold_on when tc2 reaches end of count
            cwer hold_off1 ocur row4;               * Jump to hold_off when current is over threshold

hold_on1:   stos on off on;                         * Turn VBAT on, BOOST off, LS on
            wait row124;                            * Wait for one of the previously defined conditions

hold_off1:  ldcd rst _ofs keep keep Thold_off c2;   * Load the length of the hold_off phase in counter 1
            stos off off on;                        * Turn VBAT off, BOOST off, LS on
            wait row123;                            * Wait for one of the previously defined conditions

* ### End of injection phase ###
eoinj1:     stos off off off;                       * Turn VBAT off, BOOST off, LS off
            stf high b0;                            * set flag0 to high to release the DC-DC converter idle mode
            jmpf jr2;                               * Jump back to idle phase

* ### End of Channel 1 - uCore1 code ###
