/*
*         Copyright (c), NXP Semiconductors Caen / France
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

#include <stdio.h>
#include <string.h>
#include "board.h"
#include "pin_mux.h"
#include "fsl_debug_console.h"

extern void nfc_example (void);

int main(void)
{
    BOARD_ConfigMPU();
    BOARD_InitPins();
    BOARD_BootClockRUN();
    BOARD_InitDebugConsole();

#ifdef BOARD_NXPNCI_INTERFACE_I2C
	PRINTF("\nRunning the NXP-NCI2.0 example (I2C interface)\n");
#else
	PRINTF("\nRunning the NXP-NCI2.0 example (SPI interface)\n");
#endif

	nfc_example();
}
