/*! @file Cam_PX6180.c 
*/


#include <string.h>		// memset() need this header
#include "lpc43xx.h"
#include "I2C.h"
#include "AppDefs.h"

#if CAMERA_SEL != CAMERA_PX6180
#warning "camera selection is not px6180! don't compile this module!"
#else

//! instance of the main control block structure
DS_CamCB SHARERAM s_ccb;

volatile unsigned long AHBRAM g_imgBuf[1600 * 16 * 2 / 4];

extern const unsigned int cg_regTabEleCnt;
extern const unsigned short cg_regTab[];
extern unsigned int InitialSensor_I2C(void);;


unsigned int I2C_Slave_ID;


const unsigned char Sensor_VGA_6180_Setting[][2] =
{
	{0xEF , 0x00},
	{0x04 , 0x00},
	{0x07 , 0xDC},
	{0x08 , 0x23},
	{0x09 , 0x00},
	{0x0A , 0x64},
	{0x0C , 0x01}, // Test mode
	{0x0F , 0x3A},
	{0x11 , 0x4E},
	{0x13 , 0x50},
	{0x14 , 0x21},
	{0x15 , 0x3A},
	{0x17 , 0x3C},
	{0x19 , 0x43},
	{0x1A , 0x64},
	{0x1B , 0x45},
	{0x1C , 0x6A},
	{0x1D , 0xFE},
	{0x1E , 0xC8},
	{0x1F , 0x16},
	{0x20 , 0x1A},
	{0x21 , 0x06},
	{0x22 , 0x8C},
	{0x23 , 0x1A},
	{0x24 , 0x06},
	{0x25 , 0xA0},
	{0x26 , 0x04},
	{0x27 , 0x04},
	{0x29 , 0x00},
	{0x2B , 0x20},
	{0x2C , 0x3A},
	{0x2D , 0x64},
	{0x2E , 0x75},
	{0x2F , 0x84},
	{0x30 , 0x92},
	{0x31 , 0x9F},
	{0x32 , 0xB5},
	{0x33 , 0xC7},
	{0x34 , 0xD5},
	{0x35 , 0xE0},
	{0x36 , 0xEF},
	{0x37 , 0xF8},
	{0x38 , 0xFD},
	{0x39 , 0x01},
	{0x3A , 0x4B},
	{0x3B , 0x08},
	{0x3C , 0x1E},
	{0x3D , 0x10},
	{0x44 , 0x00},
	{0x45 , 0x00},
	{0x46 , 0x02},
	{0x47 , 0x31},
	{0x48 , 0x3F},
	{0x49 , 0x7F},
	{0x4A , 0x7F},
	{0x4B , 0x42},
	{0x4C , 0x06},
	{0x4D , 0x64},
	{0x4E , 0x87},
	{0x4F , 0x7A},
	{0x50 , 0x75},
	{0x51 , 0x96},
	{0x52 , 0x85},
	{0x53 , 0x14},
	{0x54 , 0xFA},
	{0x55 , 0x42},
	{0x57 , 0x01},
	{0x58 , 0x02},
	{0x5B , 0x02},
	{0x5F , 0x08},
	{0x60 , 0x01},
	{0x61 , 0x82},
	{0x62 , 0x02},
	{0x63 , 0x30},
	{0x64 , 0x08},
	{0x65 , 0x40},
	{0x66 , 0x03},
	{0x67 , 0x12},
	{0x68 , 0x7A},
	{0x69 , 0x18},
	{0x6A , 0x30},
	{0x6B , 0x04},
	{0x6C , 0x0E},
	{0x6D , 0x00},
	{0x6E , 0x00},
	{0x6F , 0x91},
	{0x70 , 0x00},
	{0x71 , 0x00},
	{0x72 , 0x10},
	{0x73 , 0xC0},
	{0x74 , 0xA2},
	{0x75 , 0x0D},
	{0x76 , 0x84},
	{0x77 , 0x00},
	{0x78 , 0x01},
	{0x79 , 0x0E},
	{0x7B , 0x04},
	{0x7C , 0x90},
	{0x7D , 0x00},
	{0x7E , 0x00},
	{0x7F , 0xBF},
	{0x80 , 0x82},
	{0x81 , 0x23},
	{0x82 , 0x7E},
	{0x84 , 0x18},
	{0x85 , 0x00},
	{0x86 , 0x0A},
	{0x87 , 0xEA},
	{0x88 , 0x01},
	{0x89 , 0x00},
	{0x8A , 0x00},
	{0x8B , 0x00},
	{0x8C , 0x9E},
	{0x8E , 0x00},
	{0x8F , 0x00},
	{0x90 , 0x00},
	{0x91 , 0x00},
	{0x93 , 0x00},
	{0x94 , 0x00},
	{0x95 , 0x0A},
	{0x97 , 0x00},
	{0x98 , 0x00},
	{0x99 , 0x40},
	{0x9A , 0x40},
	{0x9B , 0x40},
	{0x9C , 0x40},
	{0x9D , 0x40},
	{0x9E , 0x40},
	{0x9F , 0x28},
	{0xA0 , 0x28},
	{0xA1 , 0x28},
	{0xA2 , 0x31},
	{0xA3 , 0x28},
	{0xA4 , 0x26},
	{0xA5 , 0x07},
	{0xA6 , 0x00},
	{0xA7 , 0x01},
	{0xD3 , 0x00},
	{0xDF , 0x20},
	{0xE0 , 0xF2},
	{0xE1 , 0x00},
	{0xE2 , 0x40},
	{0xE3 , 0x01},
	{0xE6 , 0x00},
	{0xE9 , 0x87},
	{0xEA , 0x00},
	{0xEB , 0x00},
	{0xEC , 0x00},
	{0xED , 0x00},
	{0xEE , 0x3F},
	{0xED , 0x01},
	{0xEF , 0x01},
	{0x02 , 0x02},
	{0x03 , 0x91},
	{0x04 , 0x50},
	{0x05 , 0x01},
	{0x06 , 0x00},
	{0x07 , 0x00},
	{0x08 , 0x00},
	{0x09 , 0x00},
	{0x0C , 0x34},
	{0x0D , 0xFA},
	{0x0E , 0x01},
	{0x0F , 0x00},
	{0x10 , 0x10},
	{0x11 , 0x00},
	{0x17 , 0x00},
	{0x18 , 0x00},
	{0x19 , 0x00},
	{0x1A , 0x00},
	{0x1B , 0xFB},
	{0x1C , 0x00},
	{0x1D , 0x47},
	{0x1E , 0x01},
	{0x20 , 0x16},
	{0x21 , 0x00},
	{0x22 , 0x08},
	{0x23 , 0x00},
	{0x24 , 0x05},
	{0x28 , 0x08},
	{0x2A , 0x03},
	{0x2B , 0x69},
	{0x2C , 0x72},
	{0x2D , 0x59},
	{0x2E , 0x68},
	{0x2F , 0x69},
	{0x30 , 0x6B},
	{0x33 , 0x60},
	{0x34 , 0x7A},
	{0x35 , 0x00},
	{0x36 , 0x00},
	{0x37 , 0x00},
	{0x38 , 0x00},
	{0x39 , 0x02},
	{0x3B , 0x01},
	{0x3C , 0x01},
	{0x3D , 0x01},
	{0x3E , 0x01},
	{0x41 , 0x06},
	{0x43 , 0x8A},
	{0x44 , 0x0E},
	{0x45 , 0x23},
	{0x48 , 0x50},
	{0x49 , 0x10},
	{0x4A , 0x00},
	{0x4B , 0x00},
	{0x50 , 0x02},
	{0x51 , 0x20},
	{0x52 , 0x29},
	{0x53 , 0x62},
	{0x58 , 0x00},
	{0x5D , 0x00},
	{0x5E , 0x06},
	{0x62 , 0x35},
	{0x63 , 0x7F},
	{0x64 , 0x3C},
	{0x66 , 0xE4},
	{0x67 , 0x07},
	{0x68 , 0x00},
	{0x69 , 0x32},
	{0x70 , 0xAB},
	{0x71 , 0x01},
	{0x76 , 0x00},
	{0x77 , 0x20},
	{0x78 , 0x00},
	{0x79 , 0x0F},
	{0x7A , 0x0F},
	{0x7B , 0x8A},
	{0x7D , 0x0F},
	{0x7E , 0x00},
	{0x80 , 0x00},
	{0x82 , 0x00},
	{0x91 , 0x00},
	{0x9F , 0x00},
	{0xA1 , 0x04},
	{0xA2 , 0xC0},
	{0xA4 , 0x00},
	{0xA5 , 0x00},
	{0xA6 , 0x00},
	{0xA7 , 0x08},
	{0xA8 , 0x0F},
	{0xA9 , 0x00},
	{0xAA , 0xAA},
	{0xAB , 0x55},
	{0xAC , 0x67},
	{0xB0 , 0x05},
	{0xB1 , 0x3F},
	{0xB2 , 0xCA},
	{0xB4 , 0x0C},
	{0xB6 , 0x0E},
	{0xB8 , 0x00},
	{0xB9 , 0x5E},
	{0xBA , 0x01},
	{0xBB , 0x00},
	{0xBC , 0x00},
	{0xBF , 0x00},
	{0xC0 , 0x00},
	{0xC1 , 0x00},
	{0x11 , 0x01},
	{0xEF , 0x02},
	{0x00 , 0x00},
	{0x0B , 0x50},
	{0x0C , 0x50},
	{0x0D , 0x40},
	{0x18 , 0x88},
	{0x19 , 0xC6},
	{0x1A , 0xB1},
	{0x1B , 0x87},
	{0x1C , 0x69},
	{0x1D , 0x7D},
	{0x1E , 0x87},
	{0x1F , 0x9B},
	{0x20 , 0xB4},
	{0x21 , 0x02},
	{0x22 , 0x08},
	{0x26 , 0x18},
	{0x27 , 0x05},
	{0x28 , 0x1F},
	{0x2A , 0x02},
	{0x2B , 0x00},
	{0x2C , 0x04},
	{0x2D , 0x04},
	{0x2E , 0x1F},
	{0x2F , 0x16},
	{0x30 , 0x12},
	{0x31 , 0x01},
	{0x35 , 0x04},
	{0x36 , 0x06},
	{0x37 , 0x04},
	{0x38 , 0x8F},
	{0x39 , 0x00},
	{0x3C , 0x00},
	{0x3E , 0x33},
	{0x3F , 0x12},
	{0x40 , 0x25},
	{0x41 , 0x09},
	{0x42 , 0x00},
	{0x43 , 0x00},
	{0x44 , 0x40},
	{0x45 , 0x40},
	{0x46 , 0x00},
	{0x47 , 0x00},
	{0x48 , 0x32},
	{0x49 , 0x36},
	{0x4A , 0x28},
	{0x4B , 0x01},
	{0x4C , 0x14},
	{0x4D , 0x3F},
	{0x4E , 0x02},
	{0x4F , 0x28},
	{0x50 , 0x3C},
	{0x51 , 0x02},
	{0x52 , 0x16},
	{0x53 , 0x03},
	{0x54 , 0x01},
	{0x55 , 0x00},
	{0x56 , 0x01},
	{0x57 , 0x00},
	{0x58 , 0x03},
	{0x5C , 0x12},
	{0x5D , 0x10},
	{0x5E , 0x03},
	{0x5F , 0x00},
	{0x60 , 0x00},
	{0x61 , 0x00},
	{0x62 , 0x02},
	{0x63 , 0x5F},
	{0x64 , 0x03},
	{0x65 , 0x46},
	{0x66 , 0x96},
	{0x67 , 0x00},
	{0x68 , 0x01},
	{0x69 , 0x00},
	{0x6A , 0x00},
	{0x6B , 0x00},
	{0x6C , 0x32},
	{0x6D , 0x12},
	{0x6E , 0x08},
	{0x6F , 0x00},
	{0x70 , 0x02},
	{0x71 , 0x00},
	{0x72 , 0x0E},
	{0x73 , 0x00},
	{0x8D , 0x10},
	{0x8E , 0x10},
	{0x8F , 0x10},
	{0x90 , 0x10},
	{0x91 , 0x00},
	{0x94 , 0x00},
	{0x95 , 0x01},
	{0x9B , 0x00},
	{0x9C , 0xF0},
	{0x9D , 0x01},
	{0x9E , 0x40},
	{0x9F , 0x00},
	{0xA0 , 0x00},
	{0xA1 , 0x00},
	{0xA2 , 0x00},
	{0xA3 , 0x00},
	{0xA4 , 0x02},
	{0xA5 , 0x00},
	{0xA6 , 0x02},
	{0xA8 , 0x00},
	{0xA9 , 0x20},
	{0xAA , 0x00},
	{0xAB , 0xF0},
	{0xAD , 0x00},
	{0xAE , 0x00},
	{0xB0 , 0x00},
	{0xB1 , 0x00},
	{0xB2 , 0x00},
	{0xB4 , 0x00},
	{0xB5 , 0xF0},
	{0xB6 , 0x01},
	{0xB7 , 0x40},
	{0xB8 , 0x00},
	{0xB9 , 0x00},
	{0xBA , 0x00},
	{0xBB , 0x00},
	{0xBC , 0x00},
	{0xBD , 0x01},
	{0xBE , 0x00},
	{0xBF , 0x04},
	{0xC0 , 0x00},
	{0xC1 , 0x00},
	{0xC2 , 0x00},
	{0xC3 , 0xE0},
	{0xC4 , 0x00},
	{0xC5 , 0x00},
	{0xC6 , 0x02},
	{0xC7 , 0x00},
	{0xC8 , 0x00},
	{0xC9 , 0x00},
	{0xCA , 0x00},
	{0xCB , 0x00},
	{0xCC , 0x00},
	{0xCD , 0x00},
	{0xCE , 0x00},
	{0xCF , 0x00},
	{0xD0 , 0x00},
	{0xD1 , 0x00},
	{0xD2 , 0x00},
	{0xD3 , 0x00},
	{0xD4 , 0x00},
	{0xD5 , 0x00},
	{0xD6 , 0x00},
	{0xD7 , 0x00},
	{0xD8 , 0x00},
	{0xD9 , 0x00},
	{0xDA , 0x00},
	{0xDB , 0x00},
	{0xDC , 0x00},
	{0xDD , 0x00},
	{0xDE , 0x00},
	{0xDF , 0x00},
	{0xE0 , 0x04},
	{0xE3 , 0x00},
	{0xE4 , 0x00},
	{0xE5 , 0x00},
	{0xE6 , 0x00},
	{0xEB , 0x00},
	{0x00 , 0x01},
};

extern const int cg_tabCnctOrd[8];

void VSyncIrqInit(void)
// configure VSYNC Pin Interrupt
{
	LPC_GPIO_PIN_INT_Type *pPinInt = LPC_GPIO_PIN_INT;
	LPC_SCU_Type *pSCU = LPC_SCU;
	uint32_t t;
#if PIQ_VSYNC != 6
		#error "VSync Pin IRQ slot number must be 6!"
#endif
	// Program pin int slot 6 to VSYNC pin, we use rising edge
	t = pSCU->PINTSEL1 & BFMSKINV(16, 23);
	t |= BFVAL(GPN_VSYNC, 16, 20) | BFVAL(GPT_VSYNC, 21, 23);
	pSCU->PINTSEL1 = t;
	
	pPinInt->ISEL &= BVON(PIQ_VSYNC);	// Edge sensitive
	pPinInt->SIENR = BVON(PIQ_VSYNC);	// En Rising edge int
	// pPinInt->SIENF = BVON(PIQ_VSYNC);	// PixArt6180 sensorʹ½жϣΪVSync½ͬʱ
	pPinInt->RISE = BVON(PIQ_VSYNC);
	NVIC_SetPriority(PIN_INT6_IRQn, 2);
	NVIC_EnableIRQ(PIN_INT6_IRQn);      //Enable GPIO pin 6 Interrupt
}


void SetupSGPIO()
{
	unsigned int i, idx,  t1;
	LPC_CGU_Type *pCGU = LPC_CGU;
	LPC_CCU1_Type *pCCU1 = LPC_CCU1;
	LPC_SGPIO_Type *pSGP = LPC_SGPIO;
	LPC_RGU_Type *pRGU = LPC_RGU;

	NVIC_DisableIRQ(SGPIO_IINT_IRQn);

	pCCU1->CLK_PERIPH_SGPIO_CFG = 1<<0;
	// pCCU1->CLK_PERIPH_CORE_CFG = 1<<0;

	// SGPIO 				  ClkOn, NoAutoBlock, PLL1
	pCGU->BASE_PERIPH_CLK = 0<<1 | 0<<11		| 9UL<<24;

	
	// reset SGPIO
	//					Rst SGPIO   | keep M0 reset if M0 is reset
	i =					1UL<<25 	| (pRGU->RESET_ACTIVE_STATUS1 & (1UL<<24));
	pRGU->RESET_CTRL1 = i;
	// wait while reseting
	do
	{
		t1 = pRGU->RESET_ACTIVE_STATUS1 & (1<<25);
	}while (0 == t1);
	
	
	pSGP->GPIO_OENREG &= ~(0xFF | 1UL<<SGP_SGPPXCLK | 1UL<<SGP_SGPHSYNC);	// 8???????, SGPIO9, SGPIO10??????
	// ??8?slice A, I, E, J, C, K, F, L ; ?????8????? ; ????8???,??9?????,??????
	for (i=0; i<8; i++)
	{
		idx = cg_tabCnctOrd[i];
		pSGP->OUT_MUX_CFG[idx] =	
		//	noCare	| GPIO OE	
			0UL<<0 	| 0UL<<4;

		pSGP->SLICE_MUX_CFG[idx] = 
		//	!MatchMd | CapRis	| SlcOrPinClk	| 8bit	 | InvQlf
			0UL << 0 | 0UL<<1 	| 1UL<<2 		| 3UL<<6 | 1UL<<8;

		pSGP->SGPIO_MUX_CFG[idx] = 
		//	ExtClkEn | Pin9Clk | ClkDis		| Pin10Qlf	| CnctEn	| Cnct8
			1UL<<0	 | 1UL<<1  | 1UL<<5		| 2UL<<7	| 1UL<<11	| 3UL<<12;

		pSGP->POS[idx] = 0;	// ????????????

	}

	// !!! warning: first slice must NOT use "Concact mode", must use external pin!!!
	pSGP->SGPIO_MUX_CFG[pin0Slice] = 
	//	ExtClkEn | Pin9Clk | ClkDis		| Pin10Qlf	| extpin(s) | cnct8
		1UL<<0	 | 1UL<<1  | 1UL<<5		| 2UL<<7	| 0UL<<11	| 3UL<<12;

	// CTRL_ENABLED is according to Slice, not pin!!!
	// pSGP->CTRL_ENABLED = 0xFF;

	pSGP->CTRL_ENABLED = (1UL<<pin0Slice) | (1UL<<pin1Slice) | (1UL<<pin2Slice) | (1UL<<pin3Slice) |
		(1UL<<pin4Slice) | (1UL<<pin5Slice) | 1UL<<pin6Slice | 1UL<<pin7Slice;

	// disable clocks of Slices with HSYNC pin and PXCLK pin
	pSGP->OUT_MUX_CFG[SLC_SGPHSYNC] = 0;
	pSGP->SLICE_MUX_CFG[SLC_SGPHSYNC] = 0;
	pSGP->SGPIO_MUX_CFG[SLC_SGPHSYNC] = 1UL<<5;		// CLkDis	
	pSGP->OUT_MUX_CFG[SLC_SGPPXCLK] = 0;
	pSGP->SLICE_MUX_CFG[SLC_SGPPXCLK] = 0;
	pSGP->SGPIO_MUX_CFG[SLC_SGPPXCLK] = 1UL<<5;		// CLkDis

	pSGP->CLR_EN_1 = SLCP0TO7_MASK;	
	pSGP->SET_EN_1 = 0x0001;					//interrupt when slice 0 switches data register
}



// use CGU_OUT1_CLK to output higher clock : 180/4=45MHz
void CGUOutMCLKInit(void)
{
// use CGU_OUT1_CLK to output higher clock : 180/4=45MHz
void CGUOutMCLKInit(void)
{
	DS_PinMux2D *pm = (DS_PinMux2D*) LPC_SCU;	
	LPC_CGU->BASE_CGU_OUT1_CLK = 13UL<<24;	// use IDIVB
	#if TEST_MODE != TEST_UNDERRUN
		LPC_CGU->IDIVB_CTRL = 9UL<<24;	// IDIVB use PLL1
		LPC_CGU->IDIVB_CTRL |= (4UL-1)<<2;	// set divider, 180/4 = 45MHz
	#else
		LPC_CGU->IDIVB_CTRL = 1UL<<24;		// IDIVB use IRC
		LPC_CGU->IDIVB_CTRL |= (2UL-1)<<2;	// set divider, 12/2 = 6MHz
	#endif
	pm->a2d[SPT_MCLK][SPN_MCLK]	= ALT_MCLK | SPNCFG_OUT_HSPD;	
}	
}

unsigned int SetSensorInit_VGA_320x240_6180(void)
{
	#define SENSOR_VGA_320x240_PARAMETER   Sensor_VGA_6180_Setting	
	
	uint8_t ReadData = 0xAC;	
	int i=0;
	int SettingArraySize;
				
	I2C_Slave_ID = I2C_SLAVE_0_ID_6180;

	SettingArraySize = sizeof(SENSOR_VGA_320x240_PARAMETER)/2;	
	for(i=0;i<SettingArraySize;i++)
	{
		ReadData = 0xff;		
		WriteI2CRegister(I2C_Slave_ID,SENSOR_VGA_320x240_PARAMETER[i][0],SENSOR_VGA_320x240_PARAMETER[i][1]);		
		ReadI2CRegister(I2C_Slave_ID,SENSOR_VGA_320x240_PARAMETER[i][0], &ReadData);
		if(ReadData != SENSOR_VGA_320x240_PARAMETER[i][1])
		{
		}							
	}
		
	return 1;
}

void CamInit(void)
{
	memset(&s_ccb, 0, sizeof(s_ccb));
	SysTick_Config(SystemCoreClock/4000-1);/* Generate interrupt each 250us      */
	s_ccb.pRcvDbBuf = &g_rcvDbBuf;
	s_ccb.freeRxBufCnt = IS_TWIN_RXBUF ? 2 : 1;	// double receiving buffer
	s_ccb.rdyRxBufCnt = 0;
	// hardware init starts here
	NVIC_DisableIRQ(SGPIO_IINT_IRQn);	
	PinInit();
	CGUOutMCLKInit();	
	InitialSensor_I2C();
	SetSensorInit_VGA_320x240_6180();		
	SetupSGPIO();
	VSyncIrqInit();		// VSync use GPIO

	// Release M0	
}

#endif
