#include "MAC57D54H.h"
#include "siul2.h"

void siul2_io_config(int io, short config, int sss)
{
    int mask;

    mask = config;
    mask = (mask << 16) | sss;
    
    SIUL2.MSCR[io].R = mask;
}

void siul2_gpio_hi(int gpio)
{
    int gpdo_bank = gpio / 4;
    int gpdo_index = gpio % 4;

    switch (gpdo_index) {
    case 0:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n = 1;
        break;
    case 1:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n1 = 1;
        break;
    case 2:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n2 = 1;
        break;
    case 3:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n3 = 1;
        break;
    }
}

void siul2_gpio_lo(int gpio)
{
    int gpdo_bank = gpio / 4;
    int gpdo_index = gpio % 4;

    switch (gpdo_index) {
    case 0:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n = 0;
        break;
    case 1:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n1 = 0;
        break;
    case 2:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n2 = 0;
        break;
    case 3:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n3 = 0;
        break;
    }
}

void siul2_gpio_toggle(int gpio)
{
    int gpdo_bank = gpio / 4;
    int gpdo_index = gpio % 4;

    switch (gpdo_index) {
    case 0:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n ^= 1;
        break;
    case 1:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n1 ^= 1;
        break;
    case 2:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n2 ^= 1;
        break;
    case 3:
        SIUL2.GPDO[gpdo_bank].B.PDO_4n3 ^= 1;
        break;
    }
}    
