#include "MAC57D54H.h"
#include "dma.h"

static int dma_sw0_buffer[8] = {1, 2, 3, 4, 5, 6, 7, 8};
static int dma_sw1_buffer[8];
static int dma_sw2_buffer[8];
static int dma_sw3_buffer[8];

void dma_ch0_init(void)
{
    DMA_0.TCD[0].SADDR.R         = (uint32_t)dma_sw0_buffer;
    DMA_0.TCD[0].ATTR.R          = 0x0202;
    DMA_0.TCD[0].SOFF.R          = 0x0004;
    DMA_0.TCD[0].NBYTES.MLNO.R   = sizeof(dma_sw0_buffer);
    DMA_0.TCD[0].SLAST.R         = (uint32_t)((int32_t)sizeof(dma_sw0_buffer) * -1);
    DMA_0.TCD[0].DADDR.R         = (uint32_t)dma_sw1_buffer;
    DMA_0.TCD[0].CITER.ELINKNO.R = 1;
    DMA_0.TCD[0].DOFF.R          = 0x0004;
    DMA_0.TCD[0].DLASTSGA.R      = (uint32_t)((int32_t)sizeof(dma_sw0_buffer) * -1);
    DMA_0.TCD[0].BITER.ELINKNO.R = 1;
    DMA_0.TCD[0].CSR.R           = 0x0120;
}

void dma_ch0_start(void)
{
    DMA_0.TCD[0].CSR.R = 0x0121;
}

void dma_ch1_init(void)
{
    DMA_0.TCD[1].SADDR.R         = (uint32_t)dma_sw1_buffer;
    DMA_0.TCD[1].ATTR.R          = 0x0202;
    DMA_0.TCD[1].SOFF.R          = 0x0004;
    DMA_0.TCD[1].NBYTES.MLNO.R   = sizeof(dma_sw1_buffer);
    DMA_0.TCD[1].SLAST.R         = (uint32_t)((int32_t)sizeof(dma_sw1_buffer) * -1);
    DMA_0.TCD[1].DADDR.R         = (uint32_t)dma_sw2_buffer;
    DMA_0.TCD[1].CITER.ELINKNO.R = 1;
    DMA_0.TCD[1].DOFF.R          = 0x0004;
    DMA_0.TCD[1].DLASTSGA.R      = (uint32_t)((int32_t)sizeof(dma_sw1_buffer) * -1);
    DMA_0.TCD[1].BITER.ELINKNO.R = 1;
    DMA_0.TCD[1].CSR.R           = 0x0220;
}

void dma_ch2_init(void)
{
    DMA_0.TCD[2].SADDR.R         = (uint32_t)dma_sw2_buffer;
    DMA_0.TCD[2].ATTR.R          = 0x0202;
    DMA_0.TCD[2].SOFF.R          = 0x0004;
    DMA_0.TCD[2].NBYTES.MLNO.R   = sizeof(dma_sw2_buffer);
    DMA_0.TCD[2].SLAST.R         = (uint32_t)((int32_t)sizeof(dma_sw2_buffer) * -1);
    DMA_0.TCD[2].DADDR.R         = (uint32_t)dma_sw3_buffer;
    DMA_0.TCD[2].CITER.ELINKNO.R = 1;
    DMA_0.TCD[2].DOFF.R          = 0x0004;
    DMA_0.TCD[2].DLASTSGA.R      = (uint32_t)((int32_t)sizeof(dma_sw2_buffer) * -1);
    DMA_0.TCD[2].BITER.ELINKNO.R = 1;
    DMA_0.TCD[2].CSR.R           = 0x0320;
}

void dma_ch3_init(void)
{
    DMA_0.TCD[3].SADDR.R         = (uint32_t)dma_sw3_buffer;
    DMA_0.TCD[3].ATTR.R          = 0x0202;
    DMA_0.TCD[3].SOFF.R          = 0x0004;
    DMA_0.TCD[3].NBYTES.MLNO.R   = sizeof(dma_sw3_buffer);
    DMA_0.TCD[3].SLAST.R         = (uint32_t)((int32_t)sizeof(dma_sw3_buffer) * -1);
    DMA_0.TCD[3].DADDR.R         = (uint32_t)dma_sw0_buffer;
    DMA_0.TCD[3].CITER.ELINKNO.R = 1;
    DMA_0.TCD[3].DOFF.R          = 0x0004;
    DMA_0.TCD[3].DLASTSGA.R      = (uint32_t)((int32_t)sizeof(dma_sw3_buffer) * -1);
    DMA_0.TCD[3].BITER.ELINKNO.R = 1;
    DMA_0.TCD[3].CSR.R           = 0x0020;
}

void dma_cm4_init(void)
{
    dma_ch0_init();
    dma_ch1_init();
    dma_ch2_init();
    dma_ch3_init();

    dma_ch0_start();
}
