#include "mscm.h"

static void module_init(void)
{
}

static int still_testing(void)
{
    return 1;
}

#define SIEVE_SIZE 120
/* Run the Sieve of Eratosthenes */
static int * sieve_of_eratosthenes(void)
{
    static int numbers[SIEVE_SIZE];
    int i, next_multiple;

    /* reset the number list */
    for (i = 0; i < SIEVE_SIZE; i++) {
        numbers[i] = 1;
    }

    for (i = 2; i < SIEVE_SIZE; i++) {
        if (numbers[i] == 0) continue;
        for (next_multiple = i * 2; next_multiple < SIEVE_SIZE; next_multiple += i) {
            numbers[next_multiple] = 0;
        }
    }

    return numbers;
}

int main(void)
{
    /* intialize modules handled by CA5 */
    module_init();

    /* tell the CM4 that the CA5 has finished initialization */
    mscm_interrupt_cpu(MSCM_CPU_CM4, (uint8_t)mscm_whoami());
    
    /* keep the CA5 busy */
    while (still_testing()) {
        sieve_of_eratosthenes();
    }

    return 0;
}
