/*
 * The following code was generated for MT47H64M16HR-3 DDR2 configuration on halo device
 *
 * Modified by: Pankaj Gupta
 * Date: 9/22/2011
 */

#include "MAC57D54H.h"
#include "dramc.h"
#include "dramc_soc_config.h"

#define error(x)	while(1);
#define printf(x)	

unsigned int dram_config_done = 0;
void siul_mscr_config_ddr_sdr_function(ddr_sdr_bit_mode ddr_sdr_bit_mode_conf);
void configure_dram(ddr_sdr_bit_mode);
void siul_mscr_config_ddr_sdr_function(ddr_sdr_bit_mode ddr_sdr_bit_mode_conf)
{
    unsigned int mddrc_siul_mscr_ddr_pads_drive_strength, mddrc_siul_mscr_pads_odt_conf;
    
    if(*(uint32_t*)0x3F002000 == 0x3A17B007)
    {	
        mddrc_siul_mscr_ddr_pads_drive_strength = (*(uint32_t*)0x3F00200C)<<28;
	mddrc_siul_mscr_pads_odt_conf = (*(uint32_t*)0x3F002014)<<20;
    }
    else
    {
	mddrc_siul_mscr_ddr_pads_drive_strength = MDDRC_SIUL_MSCR_DDR_PADS_DRIVE_STRENGTH;
        mddrc_siul_mscr_pads_odt_conf = MDDRC_SIUL_MSCR_PADS_ODT_CONF;
    }


   if((ddr_sdr_bit_mode_conf == DDR_32_BIT_MODE)||(ddr_sdr_bit_mode_conf == DDR_16_BIT_MODE))
   {
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ0].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf; 
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ1].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ2].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ3].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ4].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ5].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ6].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ7].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ8].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ9].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ10].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ11].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ12].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ13].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ14].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ15].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ16].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ17].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ18].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ19].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ20].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ21].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ22].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ23].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ24].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ25].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ26].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ27].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ28].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ29].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ30].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQ31].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A0].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A1].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A2].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A3].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A4].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A5].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A6].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A7].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A8].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A9].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A10].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A11].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A12].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A13].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A14].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_A15].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_BA0].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_BA1].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_BA2].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQM0].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQM1].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQM2].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQM3].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQS0].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQS1].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQS2].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DQS3].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | mddrc_siul_mscr_pads_odt_conf;
      SIUL2.MSCR[MDDRC_DDR_MSCR_CLK].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_CLKN].R = MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_CKE].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_CS].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_WE].R =   MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_RAS].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_CAS].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_ODT].R =  MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength;
      SIUL2.MSCR[MDDRC_DDR_MSCR_DUMMY].R =MDDRC_SIUL_MSCR_PADS_ODC_CONF | mddrc_siul_mscr_ddr_pads_drive_strength | MDDRC_SIUL_MSCR_IBE_CONF;

   }
   else if(ddr_sdr_bit_mode_conf == SDR_16_BIT_MODE)
   {
	SIUL2.MSCR[MDDRC_SDR_MSCR_A0].R = 0x32000001; 
	SIUL2.MSCR[MDDRC_SDR_MSCR_A1].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A2].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A3].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A4].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A5].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A6].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A7].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A8].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A9].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A10].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A11].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_A12].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_BA0].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_BA1].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_CAS].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_CKE].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_CLKN].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_CS].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ0].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ1].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ2].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ3].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ4].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ5].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ6].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ7].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ8].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ9].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ10].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ11].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ12].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ13].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ14].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQ15].R = 0x32080001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQM1].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DQM0].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_RAS].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_WE].R = 0x32000001;
	SIUL2.MSCR[MDDRC_SDR_MSCR_DUMMY1].R = 0x22080000; /* DDR_SDR_DUMMY1 */
	SIUL2.MSCR[MDDRC_SDR_MSCR_DUMMY2].R   = 0x22080000; /* DDR_SDR_DUMMY2 */       
  }	
 }

void configure_dram(ddr_sdr_bit_mode ddr_sdr_bit_mode_conf){

   unsigned int i;
   if(dram_config_done)
       return;
   
        SIUL2.MSCR[116].R = 0x32000006;
	*(unsigned int *)0x400D4980 = 0x04000000;   //for PLL clock selector at clockout0
	*(unsigned int *)0x400D4988 = 0x80070000;   //Auxiliary Clock 12 Divider 0 Configuration Register 
//           MC_CGM.DIV_UPD_TRIG.R = 1;
//           MC_CGM.SC_DC[0].R = 0x80000000; /* set DDR/SDR div to 1 */ 
//           *(uint32_t *) 0x400D4400 = 0x80010000; /* Div by 2 to give /2 clock */
//           MC_CGM.DIV_UPD_TRIG.R = 1;
//	   *(unsigned int *)0x400D47E8 = 0x80030000;   //DDR inteface = system clock /DIV,  system clock = 640Mhz. System Clock Divider 0 Configuration Register
//	   *(unsigned int *)0x400D4400 = 0x80070000;   //DDR clock %2  160Mhz System Clock Divider 0 Configuration Register

	
	if(ddr_sdr_bit_mode_conf == DDR_32_BIT_MODE)
	{
	   siul_mscr_config_ddr_sdr_function(ddr_sdr_bit_mode_conf);
#ifdef AG_TIMING
	   MDDRC.TIME_CONFIG0.R = 0x01f4281e;           //Configuring Timing Parameters for 320Mhz    //250 stable on EVB with CL4_NOT_CL5 defined
	   MDDRC.TIME_CONFIG1.R = 0x812E224D;           //for CAS latency = 4  from AG     //250 stable on EVB with CL4_NOT_CL5 defined
	   MDDRC.TIME_CONFIG2.R = 0x48a10c85;           //Configuring Timing Parameters for 320Mhz     //250 stable on EVB with CL4_NOT_CL5 defined
#else
	   MDDRC.TIME_CONFIG0.R = TIME_CONFIG_0;           //TIME_CONFIG_0 automated calculation 
	   MDDRC.TIME_CONFIG1.R = TIME_CONFIG_1;           //TIME_CONFIG_1 automated calculation
	   MDDRC.TIME_CONFIG2.R = TIME_CONFIG_2;           //TIME_CONFIG_2 automated calculation
#endif
	   MDDRC.DQS_CFG_OFF.R = 0x00000000; //DQS Config Offset Time Register
	   MDDRC.DQS_CFG.R = 0x00000000;     //DQS Config Offset Count Register
	   MDDRC.EX_AT.R = 0x33000000;       //DRAM extra attributes DRAM_TIME_CCD_OTHER[3:0] = 3, DRAM_TIME_WTR1_OTHER = 3

	   /*DDR Memory initialization*/
	   MDDRC.SYS_CONFIG.R = 0xaa800300;  //This is to ensure that clock should be started minimum 200us before CKE going high. Updated soma to reduce this to 10us
	   for(i=0;i<=0x7FFFF;i++);          //To account for delay between CLK and CLK_EN more than 100 uSec
	   MDDRC.SYS_CONFIG.R = (0xfa800000 & 0xFFFE000F) | (RDLY_HALFDQSDLY_QUARTDQSDLY<<11) | (WDLY<<8) | (EARLYODT_ENABLE<<7) | (ONDIETERMINATE_ENABLE<<6);             //Enabling clock and other parameters ODT enable
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   MDDRC.CMD.R = 0x00380000;  //Nop
	   for(i=0;i<=0xFFF;i++);  
	   MDDRC.CMD.R = 0x00100400;  //dram_precharge_all
	   MDDRC.CMD.R = 0x00020000;  //dram_emr2
	   MDDRC.CMD.R = 0x00030000;  //dram_emr3
	   MDDRC.CMD.R = 0x00010404;  //dram_emr1_enalble_dll   ODT75 ohm
           if(CAS_LATENCY == 4)
	      MDDRC.CMD.R = 0x00000742;  //dram_mr, dram_reset_dll. CAS latency = 4  from AG
           else if(CAS_LATENCY == 5) 
	      MDDRC.CMD.R = 0x00000952;  //dram_mr, dram_reset_dll. CAS latency = 5
           else
           {
              error("Wrong CAS_LATENCY");
	      return;
	   }
	   MDDRC.CMD.R = 0x00100400;  //dram_precharge_all
	   MDDRC.CMD.R = 0x00080000;  //dram_refresh    ----Time between refresh command should be minimum 197.5ns as configured for 320Mhz model
	   for(i=0;i<=0xFFF;i++);      
	   MDDRC.CMD.R = 0x00080000;  //dram_refresh

           if(CAS_LATENCY == 4)
              MDDRC.CMD.R = 0x00000642;  //dram_mr, dram_reset_dll. CAS latency = 4 from AG
           else if(CAS_LATENCY == 5) 
              MDDRC.CMD.R = 0x00000852;  //dram_mr, dram_init_dev_op. CAS latency = 5

	   if(*(uint32_t*)0x3F002000 == 0x3A17B007)
	   {
              MDDRC.CMD.R = (0x00010780 | (*(uint32_t*)0x3F002008) | (*(uint32_t*)0x3F002010));  //dram_emr1_ena_ocd_default   ODT50 ohm REDUCED DRIVE
              MDDRC.CMD.R = (0x00010400 | (*(uint32_t*)0x3F002008) | (*(uint32_t*)0x3F002010));  //dram_emr1_ena_ocd_exit    ODT50 ohm   REDUCED DRIVE
           }
	   else
	   {
              MDDRC.CMD.R = 0x000107C4;  //dram_emr1_ena_ocd_default   ODT50 ohm FULL DRIVE
              MDDRC.CMD.R = 0x00010444;  //dram_emr1_ena_ocd_exit    ODT50 ohm   FULL DRIVE
           }
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.CMD.R = 0x00380000;  //dram_nop
	   MDDRC.SYS_CONFIG.R &= 0xEFFFFFFF;  //clearing command mode
	   printf("DDR2 initialization completed");
	}
	else if (ddr_sdr_bit_mode_conf == DDR_16_BIT_MODE)
	{
                siul_mscr_config_ddr_sdr_function(ddr_sdr_bit_mode_conf);
	        MDDRC.DQS_CFG_OFF.R = 0x00000000;
		MDDRC.DQS_CFG.R = 0x00000000;
		MDDRC.TIME_CONFIG0.R = TIME_CONFIG_0;           //TIME_CONFIG_0 automated calculation 
                MDDRC.TIME_CONFIG1.R = TIME_CONFIG_1;           //TIME_CONFIG_1 automated calculation
                MDDRC.TIME_CONFIG2.R = TIME_CONFIG_2;           //TIME_CONFIG_2 automated calculation

		/*DDR Memory initialization*/
		MDDRC.SYS_CONFIG.R = 0xA8422b00;   //This is to ensure that clock should be started minimum 200us before CKE going high. Updated soma to reduce this to 10us
                for(i=0;i<=0x7FFFF;i++);      //To account for delay between CLK and CLK_EN
		MDDRC.SYS_CONFIG.R = (0xf8420000 & 0xFFFE000F) | (RDLY_HALFDQSDLY_QUARTDQSDLY<<11) | (WDLY<<8) | (EARLYODT_ENABLE<<7) | (ONDIETERMINATE_ENABLE<<6);             //Enabling clock and other parameters ODT enable
		MDDRC.EX_AT.R = 0x33000000; //DRAM extra attributes DRAM_TIME_CCD_OTHER[3:0] = 3, DRAM_TIME_WTR1_OTHER = 3
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00380000;  //Nop
		MDDRC.CMD.R = 0x00100400;  //dram_precharge_all
		MDDRC.CMD.R = 0x00020000;  //dram_emr2
		MDDRC.CMD.R = 0x00030000;  //dram_emr3
		MDDRC.CMD.R = 0x00010404;  //dram_enalble_dll  ODT75 ohm
           if(CAS_LATENCY == 4)
	        MDDRC.CMD.R = 0x00000743;  //dram_mr, dram_reset_dll. CAS latency = 4,  Write recovery = 4
           else if(CAS_LATENCY == 5) 
	        MDDRC.CMD.R = 0x00000953;  //dram_mr, dram_reset_dll. CAS latency = 5,   Write recovery = 5
		MDDRC.CMD.R = 0x00100400;  //dram_precharge_all
		MDDRC.CMD.R = 0x00080000;  //dram_refresh
                for(i=0;i<=0xFFF;i++);      
		MDDRC.CMD.R = 0x00080000;  //dram_refresh
           if(CAS_LATENCY == 4)
	        MDDRC.CMD.R = 0x00000643;  //dram_mr, dram_reset_dll. CAS latency = 4,  Write recovery = 4
           else if(CAS_LATENCY == 5) 
	        MDDRC.CMD.R = 0x00000853;  //dram_mr, dram_reset_dll. CAS latency = 5,   Write recovery = 5
	   if(*(uint32_t*)0x3F002000 == 0x3A17B007)
	   {
              MDDRC.CMD.R = (0x00010780 | (*(uint32_t*)0x3F002008) | (*(uint32_t*)0x3F002010));  //dram_emr1_ena_ocd_default   ODT50 ohm REDUCED DRIVE
              MDDRC.CMD.R = (0x00010400 | (*(uint32_t*)0x3F002008) | (*(uint32_t*)0x3F002010));  //dram_emr1_ena_ocd_exit    ODT50 ohm   REDUCED DRIVE
           }
	   else
	   {
              MDDRC.CMD.R = 0x000107C4;  //dram_emr1_ena_ocd_default   ODT50 ohm FULL DRIVE
              MDDRC.CMD.R = 0x00010444;  //dram_emr1_ena_ocd_exit    ODT50 ohm   FULL DRIVE
           }
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.CMD.R = 0x00380000;  //dram_nop
		MDDRC.SYS_CONFIG.R &= 0xEFFFFFFF;	//clearing command mode
	}
   else if(ddr_sdr_bit_mode_conf == SDR_16_BIT_MODE)
   {
       MC_CGM.DIV_UPD_TRIG.R = 1;
       MC_CGM.SC_DC1.R = 0x80010000; /* set DDR/SDR div to 2 */ 
       *(uint32_t *) 0x400D4400 = 0x80030000; /* Div by 4 to give /2 clock */
       MC_CGM.DIV_UPD_TRIG.R = 1;      

       /* numbers based on simulations */
       MDDRC.SYS_CONFIG.R = 0xaa800300; /* enable */
	
        siul_mscr_config_ddr_sdr_function(ddr_sdr_bit_mode_conf);
	
	MDDRC.DQS_CFG_OFF.R =  0x00000000;
	MDDRC.DQS_CFG.R =  0x00000000;

	MDDRC.SYS_CONFIG.R = 0xf2e02100;  	
	MDDRC.TIME_CONFIG0.R = 0x01f4281e; 
	MDDRC.TIME_CONFIG1.R = 0xfeab1127; 
	MDDRC.TIME_CONFIG2.R = 0x38e42064; 
	MDDRC.EX_AT.R = 0x33C00000; /* enabled SDR mode - CAS = 3 */	
	
	/* startup routine */
	MDDRC.CMD.R = 0x00100400;  //dram_precharge_all
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00080000;  //Refresh command
	MDDRC.CMD.R = 0x00000033;  //write to config register
        MDDRC.SYS_CONFIG.R &= 0xEFFFFFFF;	/*clearing command mode, End Command */
   }
   dram_config_done = 1;
}