/*
 * File:		arm_cm4.h
 * Purpose:		Definitions common to all ARM Cortex M4 processors
 *
 * Notes:
 */

#ifndef _CPU_ARM_CM4_H
#define _CPU_ARM_CM4_H
#include "typedefs.h"

/*ARM Cortex M4 implementation for interrupt priority shift*/
#define ARM_INTERRUPT_LEVEL_BITS          4

/***********************************************************************/
// function prototypes for arm_cm4.c

void write_vtor (uint32_t);
void enable_irq (uint32_t);
void disable_irq (uint32_t);
void set_irq_priority (uint32_t, uint8_t);
uint16_t route_interrupt (uint32_t irq, uint16_t cpu);

/***********************************************************************/
  /*!< Macro to enable all interrupts. */
#define EnableInterrupts asm(" CPSIE i");

  /*!< Macro to disable all interrupts. */
#define DisableInterrupts asm(" CPSID i");
/***********************************************************************/


/***********************************************************************/
#endif	/* _CPU_ARM_CM4_H */

