
DEFAULTS {

    heap_reserve = 8K
    stack_reserve = 16K

}

MEMORY {

    // Start the application at 0x2008000 so as to not overwrite angel

    gram2_memory  : ORIGIN = 0x3f130000,	 	LENGTH = 100K-stack_reserve
    gram1_memory  : ORIGIN = 0x3f000000,	 	LENGTH = 1216K
    stack_ram : org = (0x3f130000+100K-stack_reserve)    len = stack_reserve

    flash_rsvd1  : ORIGIN = 0x00000000, LENGTH = 0
    flash_memory : ORIGIN = .,          LENGTH = 16M
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0

}

//
// Program layout for running out of RAM.
//
//

SECTIONS
{

//
// The text segment
//
    .ddr2                                            	: > gram1_memory
    .picbase                                            : > gram2_memory
    .text                                               : > .
    .syscall                                            : > .
    .intercall                                          : > .
    .interfunc                                          : > .
    .fixaddr                                            : > .
    .fixtype                                            : > .
    .rodata                                             : > .
    .secinfo                                            : > .
	.intvec    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */

//
// The data segment
//

    .pidbase                                  ALIGN(16) : > .
    .sdabase                                            : > .
    .sbss                                               : > .
    .sdata                                              : > .
    .data                                               : > .
    .bss                                                : > .
    .ghcovfz					  CLEAR : > .
    .ghcovcz					  CLEAR : > .
    .ghcovdz					  CLEAR : > .
    .heap                   ALIGN(16) PAD( heap_reserve +
	    // Add space for call-graph profiling if used:
	    (isdefined(__ghs_indgcount)?(2000+(sizeof(.text)/2)):0) +
	    // Add estimated space for call-count profiling if used:
	    (isdefined(__ghs_indmcount)?10000:0) )
	    						: > .
    .stack                 ALIGN(16) PAD(stack_reserve) : > stack_ram
//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    //__ghs_romstart  = MEMADDR(flash_rsvd1);
    //__ghs_romend    = MEMENDADDR(flash_rsvd2);
   __ghs_ramstart  = MEMADDR(gram2_memory);
    __ghs_ramend    = MEMENDADDR(gram2_memory);
	
	
	/*-------- LABELS USED IN CODE ---------------------------*/

	/* Stack Address Parameters */
	__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram);

	/* Interrupt Handler Parameters */
	//__IVPR = ADDR(.xptn_vectors);
        
}
