#include "MAC57D54H.h"
#include "DCUcommon.h"
#include "halo_ports.h"

typedef struct
{
    uint32_t width;
    uint32_t height;
    uint32_t HorFrontPorch;
    uint32_t HorPulseWidth;
    uint32_t HorBackPorch;
    uint32_t VerFrontPorch;
    uint32_t VerPulseWidth;
    uint32_t VerBackPorch;
} PanelTiming;

void DCU0_IO(uint8_t,PanelTiming);

/* define this variable if the TCON needs patched to provide timing signals where they are expected */
#define _PATCHTCON
//#define _DCUTAG_EN

/********************************************************/
/* Allocate required timing signals to panel            */
/*                                                      */
/* Bit position in signals defines active signals       */
/* 0b00000001 : PCLK                                    */
/* 0b00000010 : DE                                      */
/* 0b00000100 : HSYNC                                   */
/* 0b00001000 : VSYNC                                   */
/********************************************************/
void DCU0_IO(uint8_t signals, PanelTiming p) 
{
    uint32_t i;

    /* Route DCU0 signals through TCON_0 */
    SIUL2.GPR1.R = 0x00000000;
    if (signals & 0x01) SIUL2.MSCR[PA3].R = 0x20000001;	/* PCLK */
    /* Patch TCON if required */
#if 1
    TCON.CTRL1.R = 0x00000008;	/* 8-bits per component, TTL mode */
    TCON.BMC.R = 0x00000014;		/* PCLK on D2, RGB out, MSB down, no swap */
    TCON.CTRL1.B.TCON_BYPASS=0;	/* Disable TCON bypass */

    if (p.HorPulseWidth == 1)
    {
	TCON.PULSE[1].B.FUNC_SEL = 0;
	TCON.PULSE[1].B.SET = p.HorFrontPorch + p.HorBackPorch + p.width;		/* HSYNC timing */
	TCON.PULSE[1].B.COMPARATOR_SEL = 0;
	TCON.PULSE[1].B.RESET = p.HorFrontPorch + p.HorBackPorch + p.width - 1;	/* HSYNC timing */
	TCON.PULSE[2].B.FUNC_SEL = 0;				/* DE timing */
	TCON.PULSE[2].B.SET = p.HorBackPorch -1;		/* DE timing */
	TCON.PULSE[2].B.COMPARATOR_SEL = 0;			/* DE timing */
	TCON.PULSE[2].B.RESET = p.HorBackPorch + p.width - 1;	/* DE timing */
	TCON.COMP[0].R = p.HorFrontPorch + p.HorBackPorch + p.width - 1;	/* VSYNC comparator  */
    }
    else
    {
	TCON.PULSE[1].R = p.HorFrontPorch + p.HorBackPorch + p.width;	/* HSYNC timing */
	TCON.PULSE[2].B.FUNC_SEL = 0;				/* DE timing */
	TCON.PULSE[2].B.SET = p.HorBackPorch;			/* DE timing */
	TCON.PULSE[2].B.COMPARATOR_SEL = 0;			/* DE timing */
	TCON.PULSE[2].B.RESET = p.HorBackPorch + p.width;	/* DE timing */
	TCON.COMP[0].R = p.HorFrontPorch + p.HorBackPorch + p.width;	/* VSYNC comparator  */
    }
    TCON.PULSE[0].B.FUNC_SEL = 1;	/* VSYNC timing */
    TCON.PULSE[0].B.SET = p.VerPulseWidth - 1;
    TCON.PULSE[0].B.COMPARATOR_SEL = 0;
    TCON.PULSE[0].B.RESET = p.VerFrontPorch + p.height + p.VerBackPorch + p.VerPulseWidth - 1;
    TCON.PULSE[3].B.FUNC_SEL = 2;						/* DE Keep out pulse */
    TCON.PULSE[3].B.SET = p.VerPulseWidth + p.VerBackPorch;			/* DE Keep out pulse */
    TCON.PULSE[3].B.COMPARATOR_SEL = 0;					/* DE Keep out pulse */
    TCON.PULSE[3].B.RESET = p.height + p.VerBackPorch + p.VerPulseWidth;	/* DE Keep out pulse */

    TCON.SMX[6].R = 0x6DB000A4;	/* DE created by mix (X&Y), X=PULSE2, Y=PULSE3,  */
    //TCON.OMUX_LOW.R = 0x00003062;	/* VSYNC on 0, HSYNC on 1, DE on 2 */
	TCON.OMUX_LOW.R = 0x00060860;
    //if (signals & 0x02) SIUL2.MSCR[PA1].R = 0x20000001;	/* DE */
    //if (signals & 0x04) SIUL2.MSCR[PA2].R = 0x20000001;	/* HSYNC */
    //if (signals & 0x08) SIUL2.MSCR[PA0].R = 0x20000001;	/* VSYNC */    
	if (signals & 0x02) SIUL2.MSCR[PA4].R = 0x20000002;	/* DE */
    if (signals & 0x04) SIUL2.MSCR[PA2].R = 0x20000001;	/* HSYNC */
    if (signals & 0x08) SIUL2.MSCR[PA1].R = 0x20000001;	/* VSYNC */   	
#ifdef _DCUTAG_EN
    SIUL2.MSCR[PA4].R = 0x20000002;	/* tag */
#endif
    TCON.CTRL1.B.TCON_EN=1;		/* Enable TCON */
#else
    TCON.CTRL1.B.TCON_BYPASS=1;	/* Disable TCON */
    if (signals & 0x02) SIUL2.MSCR[PA4].R = 0x20000002;	/* DE */
    if (signals & 0x04) SIUL2.MSCR[PA2].R = 0x20000001;	/* HSYNC */
    if (signals & 0x08) SIUL2.MSCR[PA1].R = 0x20000001;	/* VSYNC */    
#ifdef _DCUTAG_EN
    SIUL2.MSCR[PA0].R = 0x20000001;	/* tag */
#endif
#endif
    /* Config port A as output (red & green) */
    for(i=PA5;i<PB0;i++) SIUL2.MSCR[i].R = 0x20000001;	/* Enable output buffer */
    /* Config port B as output for green and blue */
    for(i=PB0;i<(PB12+1);i++) SIUL2.MSCR[i].R = 0x20000001;	/* Enable output buffer */
}

int8_t Panel_setup(uint32_t dcu, uint32_t freq)
{
    PanelTiming p = {_PANEL_WIDTH,_PANEL_HEIGHT,_PANEL_FPH,_PANEL_PWH,_PANEL_BPH,_PANEL_FPV,_PANEL_PWV,_PANEL_BPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);
	    
	DCU_0.DISP_SIZE.B.DELTA_Y = _PANEL_HEIGHT;
	if ((_PANEL_WIDTH % 16) == 0)
	    DCU_0.DISP_SIZE.B.DELTA_X = _PANEL_WIDTH/16;
	else return -1;
	DCU_0.HSYN_PARA.B.BP_H = _PANEL_BPH;
	DCU_0.HSYN_PARA.B.PW_H = _PANEL_PWH;
	DCU_0.HSYN_PARA.B.FP_H = _PANEL_FPH;
	DCU_0.VSYN_PARA.B.BP_V = _PANEL_BPV;
	DCU_0.VSYN_PARA.B.PW_V = _PANEL_PWV;
	DCU_0.VSYN_PARA.B.FP_V = _PANEL_FPV;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/_PANEL_FREQ)-1;	/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; 				/* Invert HSYNC and VSYNC */
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.B.DELTA_Y = _PANEL_HEIGHT;
	if ((_PANEL_WIDTH % 16) == 0)
	    DCU_0.DISP_SIZE.B.DELTA_X = _PANEL_WIDTH/16;
	else return -2;
	DCU_1.HSYN_PARA.B.BP_H = _PANEL_BPH;
	DCU_1.HSYN_PARA.B.PW_H = _PANEL_PWH;
	DCU_1.HSYN_PARA.B.FP_H = _PANEL_FPH;
	DCU_1.VSYN_PARA.B.BP_V = _PANEL_BPV;
	DCU_1.VSYN_PARA.B.PW_V = _PANEL_PWV;
	DCU_1.VSYN_PARA.B.FP_V = _PANEL_FPV;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/_PANEL_FREQ)-1;	/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; 				/* Invert HSYNC and VSYNC */
    }
    return 0;
}

void TX09_setup(uint32_t dcu, uint32_t freq)
{
    PanelTiming p = {240,320,_TX09FPH,_TX09PWH,_TX09BPH,_TX09FPV,_TX09PWV,_TX09BPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);
	    
	DCU_0.DISP_SIZE.R = _TX09PANELSIZE;
	DCU_0.HSYN_PARA.R = _TX09HPARA;
	DCU_0.VSYN_PARA.R = _TX09VPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/5.33)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _TX09PANELSIZE;
	DCU_1.HSYN_PARA.R = _TX09HPARA;
	DCU_1.VSYN_PARA.R = _TX09VPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/5.33)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}

void LQ043_setup(uint32_t dcu,uint32_t freq)
{
    PanelTiming p = {480,272,_LQ043FPH,_LQ043PWH,_LQ043BPH,_LQ043FPV,_LQ043PWV,_LQ043BPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0D,p);
	    
	DCU_0.DISP_SIZE.R = _LQ043PANELSIZE;
	DCU_0.HSYN_PARA.R = _LQ043HPARA; 
	DCU_0.VSYN_PARA.R = _LQ043VPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/8)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _LQ043PANELSIZE;
	DCU_1.HSYN_PARA.R = _LQ043HPARA;
	DCU_1.VSYN_PARA.R = _LQ043VPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/8)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}

void LQ088_setup(uint32_t dcu,uint32_t freq)
{
    PanelTiming p = {640,240,_LQ088FPH,_LQ088PWH,_LQ088BPH,_LQ088FPV,_LQ088PWV,_LQ088BPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);
	    
	DCU_0.DISP_SIZE.R = _LQ088PANELSIZE;
	DCU_0.HSYN_PARA.R = _LQ088HPARA;
	DCU_0.VSYN_PARA.R = _LQ088VPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/8)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _LQ088PANELSIZE;
	DCU_1.HSYN_PARA.R = _LQ088HPARA;
	DCU_1.VSYN_PARA.R = _LQ088VPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/8)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}


/********************************************************************************/
/* 2D-ACE configuration for T55382GD050 (800 x 480) panel						*/
/********************************************************************************/
void T55382GD050_setup(uint32_t dcu,uint32_t freq)
{
    PanelTiming p = {800,480,_T55382GD050FPH,_T55382GD050PWH,_T55382GD050BPH,_T55382GD050FPV,_T55382GD050PWV,_T55382GD050BPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);

	DCU_0.DISP_SIZE.R = _T55382GD050PANELSIZE;
	DCU_0.HSYN_PARA.R = _T55382GD050HPARA;
	DCU_0.VSYN_PARA.R = _T55382GD050VPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/31)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _T55382GD050PANELSIZE;
	DCU_1.HSYN_PARA.R = _T55382GD050HPARA;
	DCU_1.VSYN_PARA.R = _T55382GD050VPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/31)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}

/********************************************************************************/
/* 2D-ACE configuration for LQ050Y3DC01 (800 x 480) panel						*/
/********************************************************************************/
void LQ050_setup(uint32_t dcu,uint32_t freq)
{
    PanelTiming p = {800,480,_LQ050FPH,_LQ050PWH,_LQ050BPH,_LQ050FPV,_LQ050PWV,_LQ050BPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);

	DCU_0.DISP_SIZE.R = _LQ050PANELSIZE;
	DCU_0.HSYN_PARA.R = _LQ050HPARA;
	DCU_0.VSYN_PARA.R = _LQ050VPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/30)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _LQ050PANELSIZE;
	DCU_1.HSYN_PARA.R = _LQ050HPARA;
	DCU_1.VSYN_PARA.R = _LQ050VPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/30)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}


/********************************************************************************/
/* 2D-ACE configuration for DVI SVGA (800 x 600) panel						*/
/********************************************************************************/
void SVGA_setup(uint32_t dcu,uint32_t freq)
{
    PanelTiming p = {800,600,_SVGAFPH,_SVGAPWH,_SVGABPH,_SVGAFPV,_SVGAPWV,_SVGABPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);
	    
	DCU_0.DISP_SIZE.R = _SVGAPANELSIZE;
	DCU_0.HSYN_PARA.R = _SVGAHPARA;
	DCU_0.VSYN_PARA.R = _SVGAVPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/40)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _SVGAPANELSIZE;
	DCU_1.HSYN_PARA.R = _SVGAHPARA;
	DCU_1.VSYN_PARA.R = _SVGAVPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/40)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}

/********************************************************************************/
/* 2D-ACE configuration for DVI XGA (1024 x 768) panel						*/
/********************************************************************************/
void XGA_setup(uint32_t dcu,uint32_t freq)
{
    PanelTiming p = {1024,768,_XGAFPH,_XGAPWH,_XGABPH,_XGAFPV,_XGAPWV,_XGABPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);
	    
	DCU_0.DISP_SIZE.R = _XGAPANELSIZE;
	DCU_0.HSYN_PARA.R = _XGAHPARA;
	DCU_0.VSYN_PARA.R = _XGAVPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/60)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _XGAPANELSIZE;
	DCU_1.HSYN_PARA.R = _XGAHPARA;
	DCU_1.VSYN_PARA.R = _XGAVPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/60)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}

/********************************************************************************/
/* 2D-ACE configuration for DVI SXGA (1280 x 1024) panel						*/
/********************************************************************************/
void SXGA_setup(uint32_t dcu,uint32_t freq)
{
    PanelTiming p = {1280,1024,_SXGAFPH,_SXGAPWH,_SXGABPH,_SXGAFPV,_SXGAPWV,_SXGABPV};
    if (dcu == 0)
    {
	/* Config I/O */
	DCU0_IO(0x0F,p);
	    
	DCU_0.DISP_SIZE.R = _SXGAPANELSIZE;
	DCU_0.HSYN_PARA.R = _SXGAHPARA;
	DCU_0.VSYN_PARA.R = _SXGAVPARA;
    
	DCU_0.DIV_RATIO.R = (uint32_t)(freq/120)-1;		/* Clock divider */
	DCU_0.SYNPOL.R = 0x00000003; // Synchro neg.
    }
    if (dcu == 1)
    {
	DCU_1.DISP_SIZE.R = _SXGAPANELSIZE;
	DCU_1.HSYN_PARA.R = _SXGAHPARA;
	DCU_1.VSYN_PARA.R = _SXGAVPARA;
    
	DCU_1.DIV_RATIO.R = (uint32_t)(freq/120)-1;		/* Clock divider */
	DCU_1.SYNPOL.R = 0x00000003; // Synchro neg.
    }
}
