/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.nfc.NdefRecord;
import android.os.Build;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import org.ndeftools.Record;

public class UriRecord
extends Record {
    private static final short TNF_WELL_KNOWN = 1;
    private static final byte[] RTD_URI = new byte[]{85};
    public static final Charset DEFAULT_URI_CHARSET = Charset.forName("UTF-8");
    @Deprecated
    private static final String[] URI_PREFIX_MAP = new String[]{"", "http://www.", "https://www.", "http://", "https://", "tel:", "mailto:", "ftp://anonymous:anonymous@", "ftp://ftp.", "ftps://", "sftp://", "smb://", "nfs://", "ftp://", "dav://", "news:", "telnet://", "imap:", "rtsp://", "urn:", "pop:", "sip:", "sips:", "tftp:", "btspp://", "btl2cap://", "btgoep://", "tcpobex://", "irdaobex://", "file://", "urn:epc:id:", "urn:epc:tag:", "urn:epc:pat:", "urn:epc:raw:", "urn:epc:"};
    private Uri uri;

    @SuppressLint(value={"NewApi"})
    public static UriRecord parseNdefRecord(NdefRecord ndefRecord) {
        if (Build.VERSION.SDK_INT >= 16) {
            return new UriRecord(ndefRecord.toUri());
        }
        byte[] payload = ndefRecord.getPayload();
        if (payload.length < 2) {
            return null;
        }
        int prefixIndex = payload[0] & 0xFFFFFFFF;
        if (prefixIndex < 0 || prefixIndex >= URI_PREFIX_MAP.length) {
            return null;
        }
        String prefix = URI_PREFIX_MAP[prefixIndex];
        String suffix = new String(Arrays.copyOfRange(payload, 1, payload.length), Charset.forName("UTF-8"));
        return new UriRecord(Uri.parse((String)(String.valueOf(prefix) + suffix)));
    }

    public UriRecord(Uri uri) {
        this.uri = uri;
    }

    public UriRecord() {
    }

    public UriRecord(String uriString) {
        this(Uri.parse((String)uriString));
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri) {
        this.uri = uri;
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriRecord other = (UriRecord)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals((Object)other.uri));
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (!this.hasUri()) {
            throw new IllegalArgumentException("Expected URI");
        }
        if (Build.VERSION.SDK_INT >= 14) {
            return NdefRecord.createUri((Uri)this.uri);
        }
        return UriRecord.createUri(this.uri);
    }

    @SuppressLint(value={"NewApi"})
    public static NdefRecord createUri(Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        String uriString = (uri = UriRecord.normalizeScheme(uri)).toString();
        if (uriString.length() == 0) {
            throw new IllegalArgumentException("uri is empty");
        }
        byte prefix = 0;
        int i = 1;
        while (i < URI_PREFIX_MAP.length) {
            if (uriString.startsWith(URI_PREFIX_MAP[i])) {
                prefix = (byte)i;
                uriString = uriString.substring(URI_PREFIX_MAP[i].length());
                break;
            }
            ++i;
        }
        byte[] uriBytes = uriString.getBytes(Charset.forName("UTF-8"));
        byte[] recordBytes = new byte[uriBytes.length + 1];
        recordBytes[0] = prefix;
        System.arraycopy(uriBytes, 0, recordBytes, 1, uriBytes.length);
        return new NdefRecord(1, RTD_URI, new byte[0], recordBytes);
    }

    public static Uri normalizeScheme(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return uri;
        }
        String lowerScheme = scheme.toLowerCase(Locale.US);
        if (scheme.equals(lowerScheme)) {
            return uri;
        }
        return uri.buildUpon().scheme(lowerScheme).build();
    }
}

