/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.nfc.NdefRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ndeftools.Record;

public class SignatureRecord
extends Record {
    public static byte[] type = new byte[]{83, 105, 103};
    private byte version = 1;
    private SignatureType signatureType;
    private byte[] signature;
    private String signatureUri;
    private CertificateFormat certificateFormat;
    private String certificateUri;
    private List<byte[]> certificates = new ArrayList<byte[]>();

    public static SignatureRecord parseNdefRecord(NdefRecord ndefRecord) {
        byte[] payload = ndefRecord.getPayload();
        SignatureRecord signatureRecord = new SignatureRecord();
        int index = 0;
        int version = payload[index++] & 0xFF;
        signatureRecord.setVersion((byte)version);
        int header = payload[index++] & 0xFF;
        boolean signatureUriPresent = (header & 0x80) != 0;
        SignatureType type = SignatureType.toSignatureType(header & 0x7F);
        signatureRecord.setSignatureType(type);
        if (signatureUriPresent || type != SignatureType.NOT_PRESENT) {
            int size;
            if ((size = ((payload[index++] & 0xFF) << 8) + ((payload[index++] & 0xFF) << 0)) > 0) {
                byte[] signatureOrUri = new byte[size];
                System.arraycopy(payload, index, signatureOrUri, 0, size);
                index += size;
                if (signatureUriPresent) {
                    signatureRecord.setSignatureUri(new String(signatureOrUri, Charset.forName("UTF-8")));
                } else {
                    signatureRecord.setSignature(signatureOrUri);
                }
            }
            int certificateHeader = payload[index++] & 0xFF;
            signatureRecord.setCertificateFormat(CertificateFormat.toCertificateFormat(certificateHeader >> 4 & 7));
            int numberOfCertificates = certificateHeader & 0xF;
            int i = 0;
            while (i < numberOfCertificates) {
                int certificateSize = ((payload[index++] & 0xFF) << 8) + ((payload[index++] & 0xFF) << 0);
                byte[] certificate = new byte[certificateSize];
                System.arraycopy(payload, index, certificate, 0, certificateSize);
                index += certificateSize;
                signatureRecord.add(certificate);
                ++i;
            }
            if ((certificateHeader & 0x80) != 0) {
                int certificateUriSize = ((payload[index++] & 0xFF) << 8) + ((payload[index++] & 0xFF) << 0);
                byte[] certificateUri = new byte[certificateUriSize];
                System.arraycopy(payload, index, certificateUri, 0, certificateUriSize);
                index += certificateUriSize;
                signatureRecord.setCertificateUri(new String(certificateUri, Charset.forName("UTF-8")));
            }
        }
        return signatureRecord;
    }

    public SignatureRecord() {
    }

    public SignatureRecord(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public SignatureRecord(SignatureType signatureType, byte[] signature) {
        this(signatureType);
        this.signature = signature;
    }

    public SignatureRecord(SignatureType signatureType, String signatureUri) {
        this(signatureType);
        this.signatureUri = signatureUri;
    }

    public SignatureRecord(SignatureType signatureType, byte[] signature, CertificateFormat certificateFormat) {
        this(signatureType, signature);
        this.certificateFormat = certificateFormat;
    }

    public SignatureRecord(SignatureType signatureType, String signatureUri, CertificateFormat certificateFormat) {
        this(signatureType, signatureUri);
        this.certificateFormat = certificateFormat;
    }

    public SignatureRecord(SignatureType signatureType, byte[] signature, CertificateFormat certificateFormat, String certificateUri) {
        this(signatureType, signature, certificateFormat);
        this.signature = signature;
    }

    public SignatureRecord(SignatureType signatureType, String signatureUri, CertificateFormat certificateFormat, String certificateUri) {
        this(signatureType, signatureUri, certificateFormat);
        this.signatureUri = signatureUri;
    }

    public boolean isStartMarker() {
        return this.signatureType == SignatureType.NOT_PRESENT && this.signature == null && this.signatureUri == null;
    }

    public boolean hasCertificateUri() {
        return this.certificateUri != null;
    }

    public boolean hasSignature() {
        return this.signature != null;
    }

    public boolean hasSignatureUri() {
        return this.signatureUri != null;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public CertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }

    public void setCertificateFormat(CertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    public List<byte[]> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<byte[]> certificates) {
        this.certificates = certificates;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String getSignatureUri() {
        return this.signatureUri;
    }

    public void setSignatureUri(String signatureUri) {
        this.signatureUri = signatureUri;
    }

    public String getCertificateUri() {
        return this.certificateUri;
    }

    public void setCertificateUri(String certificateUri) {
        this.certificateUri = certificateUri;
    }

    public boolean hasSignatureType() {
        return this.signatureType != null;
    }

    public boolean hasCertificateFormat() {
        return this.certificateFormat != null;
    }

    public void add(byte[] certificate) {
        this.certificates.add(certificate);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.certificateFormat == null ? 0 : this.certificateFormat.hashCode());
        result = 31 * result + (this.certificateUri == null ? 0 : this.certificateUri.hashCode());
        result = 31 * result + (this.certificates == null ? 0 : this.certificatesHash());
        result = 31 * result + Arrays.hashCode(this.signature);
        result = 31 * result + (this.signatureType == null ? 0 : this.signatureType.hashCode());
        result = 31 * result + (this.signatureUri == null ? 0 : this.signatureUri.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureRecord other = (SignatureRecord)obj;
        if (this.certificateFormat != other.certificateFormat) {
            return false;
        }
        if (this.certificateUri == null ? other.certificateUri != null : !this.certificateUri.equals(other.certificateUri)) {
            return false;
        }
        if (!Arrays.equals(this.signature, other.signature)) {
            return false;
        }
        if (this.signatureType != other.signatureType) {
            return false;
        }
        if (this.signatureUri == null ? other.signatureUri != null : !this.signatureUri.equals(other.signatureUri)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        return this.certificatesEquals(other);
    }

    private int certificatesHash() {
        int hash;
        if (this.certificates != null) {
            hash = this.certificates.size();
            for (byte[] certificate : this.certificates) {
                hash += Arrays.hashCode(certificate);
            }
        } else {
            hash = 0;
        }
        return hash;
    }

    private boolean certificatesEquals(SignatureRecord other) {
        if (this.certificates == null) {
            if (other.certificates != null) {
                return false;
            }
        } else {
            if (other.certificates == null) {
                return false;
            }
            if (other.certificates.size() != this.certificates.size()) {
                return false;
            }
            int i = 0;
            while (i < this.certificates.size()) {
                byte[] thisCertificate;
                byte[] otherCertificate = other.certificates.get(i);
                if (!Arrays.equals(otherCertificate, thisCertificate = this.certificates.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (this.isStartMarker()) {
            byte[] byArray = new byte[2];
            byArray[0] = 1;
            return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, byArray);
        }
        try {
            byte[] signatureOrUri;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.version);
            if (!this.hasSignatureType()) {
                throw new IllegalArgumentException("Expected signature type");
            }
            if (this.hasSignature() && this.hasSignatureUri()) {
                throw new IllegalArgumentException("Expected signature or signature uri, not both");
            }
            if (!this.hasSignature() && !this.hasSignatureUri()) {
                throw new IllegalArgumentException("Expected signature or signature uri");
            }
            baos.write((this.hasSignatureUri() ? 1 : 0) << 7 | this.signatureType.getValue() & 0x7F);
            if (this.hasSignature()) {
                signatureOrUri = this.signature;
                if (signatureOrUri.length > 65535) {
                    throw new IllegalArgumentException("Expected signature size " + signatureOrUri.length + " <= 65535");
                }
            } else {
                signatureOrUri = this.signatureUri.getBytes(Charset.forName("UTF-8"));
                if (signatureOrUri.length > 65535) {
                    throw new IllegalArgumentException("Expected signature uri byte size " + signatureOrUri.length + " <= 65535");
                }
            }
            baos.write(signatureOrUri.length >> 8 & 0xFF);
            baos.write(signatureOrUri.length & 0xFF);
            baos.write(signatureOrUri);
            if (!this.hasCertificateFormat()) {
                throw new IllegalArgumentException("Expected certificate format");
            }
            if (this.certificates.size() > 16) {
                throw new IllegalArgumentException("Expected number of certificates " + this.certificates.size() + " <= 15");
            }
            baos.write((this.hasCertificateUri() ? 1 : 0) << 7 | this.certificateFormat.getValue() << 4 | this.certificates.size() & 0xF);
            int i = 0;
            while (i < this.certificates.size()) {
                byte[] certificate = this.certificates.get(i);
                if (certificate.length > 65535) {
                    throw new IllegalArgumentException("Expected certificate " + i + " size " + certificate.length + " <= 65535");
                }
                baos.write(certificate.length >> 8 & 0xFF);
                baos.write(certificate.length & 0xFF);
                baos.write(certificate);
                ++i;
            }
            if (this.hasCertificateUri()) {
                byte[] certificateUriBytes = this.certificateUri.getBytes(Charset.forName("UTF-8"));
                if (certificateUriBytes.length > 65535) {
                    throw new IllegalArgumentException("Expected certificate uri byte size " + certificateUriBytes.length + " <= 65535");
                }
                baos.write(certificateUriBytes.length >> 8 & 0xFF);
                baos.write(certificateUriBytes.length & 0xFF);
                baos.write(certificateUriBytes);
            }
            return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum CertificateFormat {
        X_509(0),
        X9_68(1);

        private byte value;

        private CertificateFormat(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static CertificateFormat toCertificateFormat(int i) {
            CertificateFormat[] certificateFormatArray = CertificateFormat.values();
            int n = certificateFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                CertificateFormat type = certificateFormatArray[n2];
                if (type.value == i) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unexpected certificate format " + i);
        }
    }

    public static enum SignatureType {
        NOT_PRESENT(0),
        RSASSA_PSS_SHA_1(1),
        RSASSA_PKCS1_v1_5_WITH_SHA_1(2),
        DSA(3),
        ECDSA(4);

        private byte value;

        private SignatureType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static SignatureType toSignatureType(int i) {
            SignatureType[] signatureTypeArray = SignatureType.values();
            int n = signatureTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SignatureType type = signatureTypeArray[n2];
                if (type.value == i) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unexpected signature type " + i);
        }
    }
}

