/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import java.util.ArrayList;
import java.util.List;
import org.ndeftools.Message;
import org.ndeftools.Record;

public class GcDataRecord
extends Record {
    public static byte[] type = new byte[]{100};
    private List<Record> records;

    public static GcDataRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        byte[] payload = ndefRecord.getPayload();
        GcDataRecord.normalizeMessageBeginEnd(payload);
        return new GcDataRecord(Message.parseNdefMessage(payload));
    }

    public GcDataRecord() {
        this(new ArrayList<Record>());
    }

    public GcDataRecord(List<Record> records) {
        this.records = records;
    }

    public void add(Record record) {
        this.records.add(record);
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void remove(Record record) {
        this.records.remove(record);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.records == null ? 0 : this.records.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GcDataRecord other = (GcDataRecord)obj;
        return !(this.records == null ? other.records != null : !this.records.equals(other.records));
    }

    @Override
    public NdefRecord getNdefRecord() {
        NdefRecord[] ndefRecords = new NdefRecord[this.records.size()];
        int i = 0;
        while (i < this.records.size()) {
            ndefRecords[i] = this.records.get(i).getNdefRecord();
            ++i;
        }
        return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, new NdefMessage(ndefRecords).toByteArray());
    }
}

