/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools;

import android.annotation.SuppressLint;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.os.Build;
import java.util.Arrays;
import org.ndeftools.AbsoluteUriRecord;
import org.ndeftools.EmptyRecord;
import org.ndeftools.MimeRecord;
import org.ndeftools.UnknownRecord;
import org.ndeftools.UnsupportedRecord;
import org.ndeftools.externaltype.ExternalTypeRecord;
import org.ndeftools.wellknown.ActionRecord;
import org.ndeftools.wellknown.GcActionRecord;
import org.ndeftools.wellknown.GcDataRecord;
import org.ndeftools.wellknown.GcTargetRecord;
import org.ndeftools.wellknown.GenericControlRecord;
import org.ndeftools.wellknown.SignatureRecord;
import org.ndeftools.wellknown.SmartPosterRecord;
import org.ndeftools.wellknown.TextRecord;
import org.ndeftools.wellknown.UriRecord;
import org.ndeftools.wellknown.handover.AlternativeCarrierRecord;
import org.ndeftools.wellknown.handover.CollisionResolutionRecord;
import org.ndeftools.wellknown.handover.ErrorRecord;
import org.ndeftools.wellknown.handover.HandoverCarrierRecord;
import org.ndeftools.wellknown.handover.HandoverRequestRecord;
import org.ndeftools.wellknown.handover.HandoverSelectRecord;

public abstract class Record {
    protected byte[] EMPTY = new byte[0];
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private static final byte FLAG_SR = 16;
    private static final byte FLAG_IL = 8;
    protected byte[] id = null;

    protected static void normalizeMessageBeginEnd(byte[] ndefMessage) {
        Record.normalizeMessageBeginEnd(ndefMessage, 0, ndefMessage.length);
    }

    protected static void normalizeMessageBeginEnd(byte[] ndefMessage, int offset, int length) {
        int count = offset;
        while (count < offset + length) {
            int payloadLength;
            int headerCount = count;
            int header = ndefMessage[count++] & 0xFF;
            if (count >= offset + length) {
                return;
            }
            int typeLength = ndefMessage[count++] & 0xFF;
            if (count >= offset + length) {
                return;
            }
            if ((header & 0x10) != 0) {
                payloadLength = ndefMessage[count++] & 0xFF;
                if (count >= offset + length) {
                    return;
                }
            } else {
                if (count + 4 >= offset + length) {
                    return;
                }
                payloadLength = ((ndefMessage[count] & 0xFF) << 24) + ((ndefMessage[count + 1] & 0xFF) << 16) + ((ndefMessage[count + 2] & 0xFF) << 8) + ((ndefMessage[count + 3] & 0xFF) << 0);
                count += 4;
            }
            count = (header & 8) != 0 ? count + (typeLength + payloadLength + (ndefMessage[count++] & 0xFF)) : (count += typeLength + payloadLength);
            header = headerCount == offset ? (header |= 0xFFFFFF80) : (header &= 0x7F);
            header = count == offset + length ? (header |= 0x40) : (header &= 0xFFFFFFBF);
            ndefMessage[headerCount] = (byte)header;
        }
    }

    public static Record parse(NdefRecord ndefRecord) throws FormatException {
        short tnf = ndefRecord.getTnf();
        Record record = null;
        switch (tnf) {
            case 0: {
                record = EmptyRecord.parse(ndefRecord);
                break;
            }
            case 1: {
                record = Record.parseWellKnown(ndefRecord);
                break;
            }
            case 2: {
                record = MimeRecord.parse(ndefRecord);
                break;
            }
            case 3: {
                record = AbsoluteUriRecord.parse(ndefRecord);
                break;
            }
            case 4: {
                record = ExternalTypeRecord.parse(ndefRecord);
                break;
            }
            case 5: {
                record = UnknownRecord.parse(ndefRecord);
            }
        }
        if (record == null) {
            record = UnsupportedRecord.parse(ndefRecord);
        }
        if (ndefRecord.getId().length > 0) {
            record.setId(ndefRecord.getId());
        }
        return record;
    }

    protected static Record parseWellKnown(NdefRecord ndefRecord) throws FormatException {
        block26: {
            byte[] type;
            block27: {
                block25: {
                    type = ndefRecord.getType();
                    if (type.length != 1) break block25;
                    switch (type[0]) {
                        case 85: {
                            return UriRecord.parseNdefRecord(ndefRecord);
                        }
                        case 84: {
                            return TextRecord.parseNdefRecord(ndefRecord);
                        }
                        case 116: {
                            return GcTargetRecord.parseNdefRecord(ndefRecord);
                        }
                        case 100: {
                            return GcDataRecord.parseNdefRecord(ndefRecord);
                        }
                        case 97: {
                            return GcActionRecord.parseNdefRecord(ndefRecord);
                        }
                    }
                    break block26;
                }
                if (type.length != 2) break block27;
                switch (type[0]) {
                    case 83: {
                        if (type[1] == 112) {
                            return SmartPosterRecord.parseNdefRecord(ndefRecord);
                        }
                        break block26;
                    }
                    case 71: {
                        if (type[1] == 99) {
                            return GenericControlRecord.parseNdefRecord(ndefRecord);
                        }
                        break block26;
                    }
                    case 97: {
                        if (type[1] == 99) {
                            return AlternativeCarrierRecord.parseNdefRecord(ndefRecord);
                        }
                        break block26;
                    }
                    case 99: {
                        if (type[1] == 114) {
                            return CollisionResolutionRecord.parseNdefRecord(ndefRecord);
                        }
                        break block26;
                    }
                    case 72: {
                        if (type[1] == 99) {
                            return HandoverCarrierRecord.parseNdefRecord(ndefRecord);
                        }
                        if (type[1] == 115) {
                            return HandoverSelectRecord.parseNdefRecord(ndefRecord);
                        }
                        if (type[1] == 114) {
                            return HandoverRequestRecord.parseNdefRecord(ndefRecord);
                        }
                        break block26;
                    }
                }
                break block26;
            }
            if (type.length == 3) {
                if (type[0] == 97 && type[1] == 99 && type[2] == 116) {
                    return ActionRecord.parseNdefRecord(ndefRecord);
                }
                if (type[0] == 101 && type[1] == 114 && type[2] == 114) {
                    return ErrorRecord.parseNdefRecord(ndefRecord);
                }
                if (type[0] == 83 && type[1] == 105 && type[2] == 103) {
                    return SignatureRecord.parseNdefRecord(ndefRecord);
                }
            }
        }
        return null;
    }

    protected static Record parse(byte[] record) throws FormatException {
        NdefMessage message = new NdefMessage(record);
        if (message.getRecords().length != 1) {
            throw new IllegalArgumentException("Single record expected");
        }
        return Record.parse(message.getRecords()[0]);
    }

    protected static Record parse(byte[] record, int offset, int length) throws FormatException {
        byte[] recordsPayload = new byte[length];
        System.arraycopy(record, offset, recordsPayload, 0, length);
        return Record.parse(recordsPayload);
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.id = key.getBytes();
    }

    public String getKey() {
        return this.id == null ? null : new String(this.id);
    }

    public boolean hasKey() {
        return this.id != null && this.id.length > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        return Arrays.equals(this.id, other.id);
    }

    public abstract NdefRecord getNdefRecord();

    @SuppressLint(value={"NewApi"})
    public byte[] toByteArray() {
        if (Build.VERSION.SDK_INT >= 16) {
            return new NdefMessage(this.getNdefRecord(), new NdefRecord[0]).toByteArray();
        }
        return new NdefMessage(new NdefRecord[]{this.getNdefRecord()}).toByteArray();
    }
}

