/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools;

import android.content.Intent;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import org.ndeftools.Record;

public class Message
extends ArrayList<Record> {
    private static final long serialVersionUID = 1L;

    public static Message parseNdefMessage(byte[] payload) throws FormatException {
        return new Message(new NdefMessage(payload));
    }

    public static Message parseNdefMessage(byte[] payload, int offset, int length) throws FormatException {
        byte[] messagePayload = new byte[length];
        System.arraycopy(payload, offset, messagePayload, 0, length);
        return new Message(new NdefMessage(messagePayload));
    }

    public Message() {
    }

    public Message(NdefMessage ndefMessage) throws FormatException {
        NdefRecord[] ndefRecordArray = ndefMessage.getRecords();
        int n = ndefRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            NdefRecord record = ndefRecordArray[n2];
            this.add(Record.parse(record));
            ++n2;
        }
    }

    public NdefMessage getNdefMessage() {
        NdefRecord[] ndefRecords = new NdefRecord[this.size()];
        int i = 0;
        while (i < ndefRecords.length) {
            ndefRecords[i] = ((Record)this.get(i)).getNdefRecord();
            ++i;
        }
        return new NdefMessage(ndefRecords);
    }

    public Message(Intent intent) throws FormatException {
        this(intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES"));
    }

    public Message(Parcelable[] messages) throws FormatException {
        int i = 0;
        while (i < messages.length) {
            NdefMessage message = (NdefMessage)messages[i];
            NdefRecord[] ndefRecordArray = message.getRecords();
            int n = ndefRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                NdefRecord record = ndefRecordArray[n2];
                this.add(Record.parse(record));
                ++n2;
            }
            ++i;
        }
    }

    public Message(List<Record> list) {
        super(list);
    }

    public Message(int capacity) {
        super(capacity);
    }

    public Message(Record[] records) {
        Record[] recordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Record record = recordArray[n2];
            this.add(record);
            ++n2;
        }
    }
}

