#include "LPC82x.h"
#include "uart.h"

#define GET_BYTE(b1)           ((uint8_t)  (b1 & 0xff))
#define GET_WORD(b1,b2)        ((uint16_t)((b1 & 0xff)<<8 |(b2 & 0xff)))
#define GET_LONG(b1,b2,b3,b4)  ((uint32_t)((b1 & 0xff)<<24|(b2 & 0xff)<<16|(b3 & 0xff)<<8|(b4 & 0xff)))

#define RXD                    18                      //
//#define RXD                    25                      //
#define TXD                    7                       //
//#define TXD                    24                       //

typedef enum {WAIT_CMD, START_TRAINING, SET_PARAMETER, READ_PARAMETER, READ_MODE} COM_STATE_T;

extern uint8_t  service_comm_timer;
extern uint8_t  send_pos_data;                 /* flag to send pos data via com port if touch task is active */
extern uint8_t  ts_loaded;                     /* flag to indicate training set is loaded*/

extern void     COM_Init(void);
extern void     COM_Task(void);
