/*
 * File:		mpr121.c
 * Purpose:		12 channel touch sensor for Tower Mechatronic board 
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "common.h"
#include "iic.h"
#include "pit.h"

// left ear = 0x1, 0x4, 0x2, 0x8
// right ear = 0x100, 0x200, 0x400, 0x800

#define I2C_ID		0x5A
#define INIT_MPR121(r,d) I2CsendByte(d, r, I2C_ID ); PITDelay(10, 0);

void InitMPR121( void )
{
	PITDelay(10, 0);
	INIT_MPR121(0x2B, 0x01) //AN3891 A
	INIT_MPR121(0x2C, 0x01) //AN3891 A
	INIT_MPR121(0x2D, 0x00) //AN3891 A
	INIT_MPR121(0x2E, 0x00) //AN3891 A
	INIT_MPR121(0x2F, 0x01) //AN3891 B
	INIT_MPR121(0x30, 0x01) //AN3891 B
	INIT_MPR121(0x31, 0xFF) //AN3891 B
	INIT_MPR121(0x32, 0x02) //AN3891 B
	INIT_MPR121(0x41, 0x0F) //AN3892 C
	INIT_MPR121(0x42, 0x0A) //AN3892 C
	INIT_MPR121(0x43, 0x0F) //AN3892 C
	INIT_MPR121(0x44, 0x0A) //AN3892 C
	INIT_MPR121(0x45, 0x0F) //AN3892 C
	INIT_MPR121(0x46, 0x0A) //AN3892 C
	INIT_MPR121(0x47, 0x0F) //AN3892 C
	INIT_MPR121(0x48, 0x0A) //AN3892 C
	INIT_MPR121(0x49, 0x0F) //AN3892 C
	INIT_MPR121(0x4A, 0x0A) //AN3892 C
	INIT_MPR121(0x4B, 0x0F) //AN3892 C
	INIT_MPR121(0x4C, 0x0A) //AN3892 C
	INIT_MPR121(0x4D, 0x0F) //AN3892 C
	INIT_MPR121(0x4E, 0x0A) //AN3892 C
	INIT_MPR121(0x4F, 0x0F) //AN3892 C
	INIT_MPR121(0x50, 0x0A) //AN3892 C
	INIT_MPR121(0x51, 0x0F) //AN3892 C
	INIT_MPR121(0x52, 0x0A) //AN3892 C
	INIT_MPR121(0x53, 0x0F) //AN3892 C
	INIT_MPR121(0x54, 0x0A) //AN3892 C
	INIT_MPR121(0x55, 0x0F) //AN3892 C
	INIT_MPR121(0x56, 0x0A) //AN3892 C
	INIT_MPR121(0x57, 0x0F) //AN3892 C
	INIT_MPR121(0x58, 0x0A) //AN3892 C
	INIT_MPR121(0x5D, 0x04) //AN3890 D
	INIT_MPR121(0x7B, 0x0B) //AN3889 F
	INIT_MPR121(0x7D, 0x9C) //AN3889 F
	INIT_MPR121(0x7E, 0x65) //AN3889 F
	INIT_MPR121(0x7F, 0x8C) //AN3889 F
	INIT_MPR121(0x5E, 0x0C) //AN3890 E
}

uint16 ReadMPR121_Status( void )
{
	uint16 temp;

	PITDelay(10, 0);
	temp = I2CreceiveByte( 0x01, I2C_ID );
	PITDelay(10, 0);
	temp = temp << 8;
	temp |= I2CreceiveByte( 0x00, I2C_ID );
	return( temp );	
}
