/********************************************************************************
*                                                                     
*       Copyright (C) 2007 Freescale Semiconductor, Inc.              								              
*														              
* Filename:    main.c                													              
* Revision:      										              													                       
* 
* Notes: This is a test code targeted to be used with TWR-S12G64 board
         Refer to TWR-S12G64 Schematic for electrical connections details.       
               
               
*********************************************************************************/

#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "S12SCIV5.h"

/*********************************************************************************/

/* PORT LOGIC defines */
#define OUTPUT         1
#define INPUT          0

#define PULLUP_ENABLE  0
#define PULLDWN_ENABLE 1

#define ENABLE         1

/* LED defines */
#define LED1_DRIVER_INIT DDRP_DDRP0= 1
#define LED2_DRIVER_INIT DDRP_DDRP1= 1
#define LED3_DRIVER_INIT DDRP_DDRP2= 1
#define LED4_DRIVER_INIT DDRP_DDRP3= 1

#define TOGGLE_DELAY                 0xFFFF


/* LEDs are driven with neg logic */

#define LED1_ON   PTP_PTP0  = 0
#define LED1_OFF  PTP_PTP0  = 1

#define LED2_ON   PTP_PTP1  = 0
#define LED2_OFF  PTP_PTP1  = 1

#define LED3_ON   PTP_PTP2  = 0
#define LED3_OFF  PTP_PTP2  = 1

#define LED4_ON   PTP_PTP3  = 0
#define LED4_OFF  PTP_PTP3  = 1

#define TX0_CHAR_NUMB        26
#define TX1_CHAR_NUMB        19
#define BACKSPACE             8
/****************************** LOCAL VAIABLES ***********************************/
 
unsigned char        TXD0[TX0_CHAR_NUMB]       = {"TWR-S12G64 DEMO Running  "};
unsigned char        TXD1[TX1_CHAR_NUMB]       = {"ADC CH0 Result =  "};
unsigned char        Tx_Byte_Index  = 0;
static unsigned int  delay          = 0;
unsigned char        Delay_Ctr      = 0;
unsigned int         ATD_Delay_Val  = TOGGLE_DELAY;
unsigned char        ADC_Tx         = 0;

/******************************** FUNCTION PROTOTYPES ****************************/
void CPMU_Init(void);
void RV1_AN10_Init(void);
void Switches_Driver_Init(void);
void SCI0_Init(void);

void Toggle_Delay(void);
void Tx_Delay(void);

void Send_TWR_ID(void);
void Read_ADCCH0_Result(void);
void Send_ADC_Msg(void);

/******************************************************************************
Function Name  : main
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : Main procedure for this TWR-S1264 DEMO
                 1.- Configures CPMU to a 25MHz frequency
                 2.- Configures ADC converter for 8 bit at PAD10.
                 3.- Configure AD4-7 as digital inputs to read SW1-4 state.
                 4.- Configures SCI0 to 9600 Baud rate, 8 bit Data, parity 
                     none, one stop bit and no flow control.
                 5.- Configure RS232 tranceiver enable with PT0AD7

Functional Description: 
                 This DEMO application for TWR-S12G64 shows LED1-4 sweep
                 and user can use SW1-4 to select which of the LED1-4 remains 
                 off. The LEDs sweep speed depends on RV1 potentiometer value, 
                 the lower the conversion result, the slower the sweep on the 
                 LEDs. User can monitor the conversion result using a terminal 
                 window and connecting the DEMO board to a serial channel to a 
                 PC. The connection requires a cable adaptor connected J5.
                  
******************************************************************************/
void main(void) 
{
   CPMU_Init();
   RV1_AN10_Init();  
   Switches_Driver_Init();
   SCI0_Init();
        
   /* P0-3 initialization to control LED1-4 */
   LED1_DRIVER_INIT;
   LED2_DRIVER_INIT;           
   LED3_DRIVER_INIT;  
   LED4_DRIVER_INIT;   
   
   /* Send Header information thrugh SCI0 */
   Send_TWR_ID();
   LF;  
   Send_ADC_Msg();
   
   for(;;) /* Loop forever */
   {                                        
      /* Load ADC CH0 value to be shown on Terminal */
      Read_ADCCH0_Result();
      DisplayString("0x");
      DisplayByte (ADC_Tx);
      
      /* overwrite over the same sapace of ADC result on terminal window */
      PutChar(BACKSPACE);
      PutChar(BACKSPACE);
      PutChar(BACKSPACE);
      PutChar(BACKSPACE);
             
      if(PT1AD_PT1AD4)
      {
         LED1_ON;
         
         for(Delay_Ctr = 0; Delay_Ctr < 2; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }           
      }
      
      LED1_OFF;
           
      
      if(PT1AD_PT1AD5)
      {
         LED2_ON;
         for(Delay_Ctr = 0; Delay_Ctr < 6; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }
      }
      
      LED2_OFF;
      
      if(PT1AD_PT1AD6)
      {
         LED3_ON;
         for(Delay_Ctr = 0; Delay_Ctr < 2; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }
      }
      
      LED3_OFF;
      
      
      if(PT1AD_PT1AD7)
      {
         LED4_ON;
         for(Delay_Ctr = 0; Delay_Ctr < 6; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }               
      }
      
      LED4_OFF;
      
      for(Delay_Ctr = 0; Delay_Ctr < 12; Delay_Ctr++)
      {                
          Toggle_Delay();                
      }                   
      
      if(PT1AD_PT1AD7)
      {
         LED4_ON;
         for(Delay_Ctr = 0; Delay_Ctr < 6; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }               
      }
      
      LED4_OFF;               
      
      
      if(PT1AD_PT1AD6)
      {
         LED3_ON;
         for(Delay_Ctr = 0; Delay_Ctr < 2; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }
      }
      
      LED3_OFF;
      
      if(PT1AD_PT1AD5)
      {
         LED2_ON;
         for(Delay_Ctr = 0; Delay_Ctr < 6; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }
      }
      
      LED2_OFF;

      if(PT1AD_PT1AD4)
      {
         LED1_ON;
         for(Delay_Ctr = 0; Delay_Ctr < 2; Delay_Ctr++)
         {                
            Toggle_Delay();                
         }
      }
      
      LED1_OFF;
   
   } /* for */                 
}/* main */



/******************************************************************************
Function Name  : CPMU_Init
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : CPMU configuration to run at 25MHz bus clk.                               
******************************************************************************/
void CPMU_Init(void)
{
   /* 
      Initialise the system clock for Normal mode: 
      - 50MHz VCO, 50MHz PLL, 25MHz Bus CLK, from 8MHz Crystal 
   */
	
   CPMUSYNR    = 0x58; /* VCOFRQ -> 48MHz < fVCO<= 50MHz SYNDIV = 24  */

   CPMUREFDIV  = 0x07; /* REFDIV =  7                                 */     

   CPMUPOSTDIV = 0x00; /* POSTDIV = 0, FBus 0 FPLL/2                  */

   while(!CPMUFLG_LOCK)
   {
      ;                /* 
                          Wait for VCO to stabilize, if failure occurs 
                          WD will be triggered
                       */
   }			 
 
   CPMUCLKS_PLLSEL = 1;/* Switch clk to use PLL */
}


/******************************************************************************
Function Name  : Toggle_Delay
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : General Delay function. Time is not calibrated to a specific
                 value.                               
******************************************************************************/
void Toggle_Delay(void)
{   
   for(delay =0;delay < ATD_Delay_Val; delay++)
   {
      ; 
   }
}

/******************************************************************************
Function Name  : Tx_Delay
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : General Delay function. Time is not calibrated to a specific
                 value.                               
******************************************************************************/
void Tx_Delay(void)
{   
   uint tx_delay = 0;
   
   for(tx_delay =0;tx_delay < TOGGLE_DELAY; tx_delay++)
   {
      ; 
   }
}

/******************************************************************************
Function Name  : Switches_Driver_Init
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : Switches port driver configuration, pull ups required since
                 SW1-4 will drive low when activated.                               
******************************************************************************/
void Switches_Driver_Init(void)
{
   PIE1AD = (  PIE1AD_PIE1AD4_MASK 
            || PIE1AD_PIE1AD5_MASK 
            || PIE1AD_PIE1AD6_MASK
            || PIE1AD_PIE1AD7_MASK);                    

   PPS1AD = (  PPS1AD_PPS1AD4_MASK 
            || PPS1AD_PPS1AD5_MASK 
            || PPS1AD_PPS1AD6_MASK
            || PPS1AD_PPS1AD7_MASK);           

   /* Enable Pull ups */
   
   PER1AD_PER1AD4 = ENABLE;
   PER1AD_PER1AD5 = ENABLE;
   PER1AD_PER1AD6 = ENABLE;
   PER1AD_PER1AD7 = ENABLE;           
  
  /* Make sure the jumpers at JP1 for SW1-4 are installed */
   DDR1AD_DDR1AD4 = INPUT;
   DDR1AD_DDR1AD5 = INPUT;
   DDR1AD_DDR1AD6 = INPUT;
   DDR1AD_DDR1AD7 = INPUT;           
  
   /* Set AD4-7 as digital inputs */
   ATDDIENL_IEN4 = ENABLE;
   ATDDIENL_IEN5 = ENABLE;
   ATDDIENL_IEN6 = ENABLE;
   ATDDIENL_IEN7 = ENABLE;
}


void RV1_AN10_Init(void)
{
   /* Continuous 8-Bit Conversion */
           
   ATDCTL1 = 0x0F;  /* 8-Bit resolution */              

   ATDCTL3 = 0x88;  /* Right Justified Data, Single conversion sequence */              

   ATDCTL4 = 0x01;  /* 8MHz ATD Clock, 4 ATD Clock cycles sample time */              

   ATDCTL5 = 0x2A;  /* Start Continuous Conversions on PAD10 */ 
}


void Send_TWR_ID(void)
{

  /* Check communication */
  for(Tx_Byte_Index=0;Tx_Byte_Index < TX0_CHAR_NUMB - 1;Tx_Byte_Index++) 
  {
     /* Start data transmission */
     SCI0DRL = TXD0[Tx_Byte_Index];
     while(!(SCI0SR1_TDRE & 1));        
      
     (void)SCI0SR1; /* Required to perform the flag clearing sequence */          
  }
  
  LF;
}

void Send_ADC_Msg(void)
{

  /* Check communication */
  for(Tx_Byte_Index=0;Tx_Byte_Index < TX1_CHAR_NUMB - 1;Tx_Byte_Index++) 
  {
     /* Start data transmission */
     SCI0DRL = TXD1[Tx_Byte_Index];
     while(!(SCI0SR1_TDRE & 1));        
      
     (void)SCI0SR1; /* Required to perform the flag clearing sequence */          
  }
}



void Read_ADCCH0_Result(void)
{
   while (!ATDSTAT0_SCF);          /* wait for conversion sequence to complete */
   ADC_Tx = (unsigned char)ATDDR0;
   ATD_Delay_Val = (ADC_Tx <<8);   /* store result in variable to avoid overwriting */
   ATDSTAT0_SCF = 1;               /* Clear Sequence Complete Flag for next conversion */
 
}

void SCI0_Init(void)
{
   /* Configure AD7 "PAD15" port as outputs to drive MAX3387 FORCEOFF pin */
   
   DDR0AD_DDR0AD7 = OUTPUT;
                                           
   /* Disable all AD port interrupts */
   
   PIE01AD = 0x0000;         
                        
   /* Enable MAX3387 FORCEOFF = 1 */
   
   PT0AD_PT0AD7 = ENABLE;
   
   /* Set baud rate = 0xA3 @ buss clock = 25 MHz */
   /* SCI0BD = BusCLK/[16*9600]                  */
   SCI0BD = 0x00A3;             
           
   SCI0CR2  |= 0x08;     /* Enable Tx for SCI0, signal at PIN 53 of 64 pin LQFP */  

   /* The following sequence is to perform a flag clearing sequence */
   (void)SCI0SR1;
   SCI0DRL = 0;
}




