/*
*                    Copyright (c), NXP Semiconductors
*
*                       (C) NXP Semiconductors 2018
*
*         All rights are reserved. Reproduction in whole or in part is
*        prohibited without the written consent of the copyright owner.
*    NXP reserves the right to make changes without notice at any time.
*   NXP makes no warranty, expressed, implied or statutory, including but
*   not limited to any implied warranty of merchantability or fitness for any
*  particular purpose, or that the use will not infringe any third party patent,
*   copyright or trademark. NXP must not be liable for any loss or damage
*                            arising from its use.
*/

#ifndef NDEF_RECORDINTERNALS_H_
#define NDEF_RECORDINTERNALS_H_

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* ********************************************************************************************
* Includes
* ******************************************************************************************* */

#include <stdint.h>
#include "NDEF_Status.h"
#include "NDEF_Config.h"
#include "NDEF_Record.h"

/* ********************************************************************************************
* MACROS/Defines
* ******************************************************************************************* */
#define NULL_TERM	'\0'
#define NULL_TERM_LEN	1
#define ERROR_OCURRED	0x01

#define TEXT_TYPE_FIELD	"T"
#define TEXT_TYPE_FIELD_LEN	1

#define BTSSP_TYPE_BREDR      "application/vnd.bluetooth.ep.oob"
#define BTSSP_TYPE_BREDR_LEN  0x20U
#define BTSSP_TYPE_LE         "application/vnd.bluetooth.le.oob"
#define BTSSP_TYPE_LE_LEN     0x20U
#define URI_TYPE_FIELD	"U"
#define URI_TYPE_FIELD_LEN	1

/* ********************************************************************************************
* Types/Structure Declarations
* ******************************************************************************************* */
	typedef struct
	{
		NDEF_Record_Header_t sHeader;
		uint32_t dwOffsetToPayload;
	}INT_FetchedHeader_t;


/* ********************************************************************************************
* Function Prototypes
* ******************************************************************************************* */

	extern Status_t INT_Uri_Free(void  *pRecord);
	extern Status_t INT_Text_Free(void * pRecord);
	extern Status_t INT_Btssp_Free(void * pRecord);
	extern Status_t INT_BtsspLe_Free(void * pRecord);
	extern Status_t INT_Generic_Free(void * pRecord);
	extern Status_t INT_Text_Serialize(void *pRecord, uint8_t * pOutput, uint32_t * pOffset);
	extern Status_t INT_BtsspBrEdr_Serialize(void *pRecord, uint8_t * pOutput, uint32_t * pOffset);
	extern Status_t INT_BtsspLe_Serialize(void *pRecord, uint8_t * pOutput, uint32_t * pOffset);
	extern Status_t INT_GenPayload_Serialize(void *pRecord, uint8_t * pOutput, uint32_t * pOffset);
	extern Status_t INT_Uri_Serialize(void *pRecord, uint8_t * pOutput, uint32_t * pOffset);
	extern Status_t INT_Header_Serialize(void *pRecord, uint8_t * pOutput, uint32_t * pOffset);

	extern void * INT_ParsePayload(INT_FetchedHeader_t * pFetchedHeader, const uint8_t * pInput);
	extern void * INT_BtsspBrEdr_Parse(INT_FetchedHeader_t * pFetchedHeader,const uint8_t * pInput);
	extern void * INT_BtsspLe_Parse(INT_FetchedHeader_t * pFetchedHeader, const uint8_t * pInput);
	extern void * INT_GenPayload_Parse(INT_FetchedHeader_t * pFetchedHeader, const uint8_t * pInput);
	extern void * INT_Uri_Parse(INT_FetchedHeader_t * pFetchedHeader, const uint8_t * pInput);
	extern void * INT_Text_Parse(INT_FetchedHeader_t * pFetchedHeader, const uint8_t * pInput);
	extern INT_FetchedHeader_t * Msg_FetchHeaders(const uint8_t * pInput, uint32_t dwLength, uint16_t * pNumOfRecords);
	extern void INT_FreeFetchedHeaders(INT_FetchedHeader_t * pNode, uint16_t wNumOfRecords);

	extern uint32_t INT_Header_CalcSize(void *pRecord);

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* NDEF_RECORDINTERNALS_H_ */

