/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown.handover;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import java.util.ArrayList;
import java.util.List;
import org.ndeftools.Message;
import org.ndeftools.Record;
import org.ndeftools.wellknown.handover.AlternativeCarrierRecord;
import org.ndeftools.wellknown.handover.ErrorRecord;

public class HandoverSelectRecord
extends Record {
    private byte majorVersion = 1;
    private byte minorVersion = (byte)2;
    private List<AlternativeCarrierRecord> alternativeCarriers;
    private ErrorRecord error;

    public static HandoverSelectRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        byte[] payload = ndefRecord.getPayload();
        HandoverSelectRecord handoverSelectRecord = new HandoverSelectRecord();
        byte minorVersion = (byte)(payload[0] & 0xF);
        byte majorVersion = (byte)(payload[0] >> 4 & 0xF);
        handoverSelectRecord.setMinorVersion(minorVersion);
        handoverSelectRecord.setMajorVersion(majorVersion);
        if (payload.length > 1) {
            HandoverSelectRecord.normalizeMessageBeginEnd(payload, 1, payload.length - 1);
            Message records = Message.parseNdefMessage(payload, 1, payload.length - 1);
            int i = 0;
            while (i < records.size()) {
                Record record = (Record)records.get(i);
                if (record instanceof AlternativeCarrierRecord) {
                    handoverSelectRecord.add((AlternativeCarrierRecord)record);
                } else if (record instanceof ErrorRecord && i == records.size() - 1) {
                    handoverSelectRecord.setError((ErrorRecord)record);
                }
                ++i;
            }
        }
        return handoverSelectRecord;
    }

    public HandoverSelectRecord() {
        this.alternativeCarriers = new ArrayList<AlternativeCarrierRecord>();
    }

    public HandoverSelectRecord(byte majorVersion, byte minorVersion) {
        this(majorVersion, minorVersion, new ArrayList<AlternativeCarrierRecord>());
    }

    public HandoverSelectRecord(byte majorVersion, byte minorVersion, List<AlternativeCarrierRecord> alternativeCarriers) {
        this(majorVersion, minorVersion, alternativeCarriers, null);
    }

    public HandoverSelectRecord(byte majorVersion, byte minorVersion, List<AlternativeCarrierRecord> alternativeCarriers, ErrorRecord error) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.alternativeCarriers = alternativeCarriers;
        this.error = error;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(byte minorVersion) {
        this.minorVersion = minorVersion;
    }

    public List<AlternativeCarrierRecord> getAlternativeCarriers() {
        return this.alternativeCarriers;
    }

    public void setAlternativeCarriers(List<AlternativeCarrierRecord> alternativeCarriers) {
        this.alternativeCarriers = alternativeCarriers;
    }

    public ErrorRecord getError() {
        return this.error;
    }

    public void setError(ErrorRecord error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean hasAlternativeCarriers() {
        return !this.alternativeCarriers.isEmpty();
    }

    public void add(AlternativeCarrierRecord record) {
        this.alternativeCarriers.add(record);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternativeCarriers == null ? 0 : this.alternativeCarriers.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HandoverSelectRecord other = (HandoverSelectRecord)obj;
        if (this.alternativeCarriers == null ? other.alternativeCarriers != null : !this.alternativeCarriers.equals(other.alternativeCarriers)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        return this.minorVersion == other.minorVersion;
    }

    @Override
    public NdefRecord getNdefRecord() {
        ArrayList<NdefRecord> records = new ArrayList<NdefRecord>();
        if (this.hasAlternativeCarriers()) {
            for (Record record : this.alternativeCarriers) {
                records.add(record.getNdefRecord());
            }
        }
        if (this.hasError()) {
            records.add(this.error.getNdefRecord());
        }
        byte[] byArray = new NdefMessage(records.toArray(new NdefRecord[records.size()])).toByteArray();
        byte[] payload = new byte[byArray.length + 1];
        payload[0] = (byte)(this.majorVersion << 4 | this.minorVersion);
        System.arraycopy(byArray, 0, payload, 1, byArray.length);
        return new NdefRecord(1, NdefRecord.RTD_HANDOVER_SELECT, this.id != null ? this.id : this.EMPTY, payload);
    }
}

